/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.ElementTypesAreNonnullByDefault;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.DoubleConsumer;
import java.util.stream.DoubleStream;
import javax.annotation.CheckForNull;

@Immutable
@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class ImmutableDoubleArray
implements Serializable {
    private static final ImmutableDoubleArray EMPTY = new ImmutableDoubleArray(new double[0]);
    private final double[] array;
    private final transient int start;
    private final int end;

    public static ImmutableDoubleArray of() {
        return EMPTY;
    }

    public static ImmutableDoubleArray of(double d) {
        return new ImmutableDoubleArray(new double[]{d});
    }

    public static ImmutableDoubleArray of(double d, double d2) {
        return new ImmutableDoubleArray(new double[]{d, d2});
    }

    public static ImmutableDoubleArray of(double d, double d2, double d3) {
        return new ImmutableDoubleArray(new double[]{d, d2, d3});
    }

    public static ImmutableDoubleArray of(double d, double d2, double d3, double d4) {
        return new ImmutableDoubleArray(new double[]{d, d2, d3, d4});
    }

    public static ImmutableDoubleArray of(double d, double d2, double d3, double d4, double d5) {
        return new ImmutableDoubleArray(new double[]{d, d2, d3, d4, d5});
    }

    public static ImmutableDoubleArray of(double d, double d2, double d3, double d4, double d5, double d6) {
        return new ImmutableDoubleArray(new double[]{d, d2, d3, d4, d5, d6});
    }

    public static ImmutableDoubleArray of(double d, double ... dArray) {
        Preconditions.checkArgument(dArray.length <= 0x7FFFFFFE, "the total number of elements must fit in an int");
        double[] dArray2 = new double[dArray.length + 1];
        dArray2[0] = d;
        System.arraycopy(dArray, 0, dArray2, 1, dArray.length);
        return new ImmutableDoubleArray(dArray2);
    }

    public static ImmutableDoubleArray copyOf(double[] dArray) {
        return dArray.length == 0 ? EMPTY : new ImmutableDoubleArray(Arrays.copyOf(dArray, dArray.length));
    }

    public static ImmutableDoubleArray copyOf(Collection<Double> collection) {
        return collection.isEmpty() ? EMPTY : new ImmutableDoubleArray(Doubles.toArray(collection));
    }

    public static ImmutableDoubleArray copyOf(Iterable<Double> iterable) {
        if (iterable instanceof Collection) {
            return ImmutableDoubleArray.copyOf((Collection)iterable);
        }
        return ImmutableDoubleArray.builder().addAll(iterable).build();
    }

    public static ImmutableDoubleArray copyOf(DoubleStream doubleStream) {
        double[] dArray = doubleStream.toArray();
        return dArray.length == 0 ? EMPTY : new ImmutableDoubleArray(dArray);
    }

    public static Builder builder(int n) {
        Preconditions.checkArgument(n >= 0, "Invalid initialCapacity: %s", n);
        return new Builder(n);
    }

    public static Builder builder() {
        return new Builder(10);
    }

    private ImmutableDoubleArray(double[] dArray) {
        this(dArray, 0, dArray.length);
    }

    private ImmutableDoubleArray(double[] dArray, int n, int n2) {
        this.array = dArray;
        this.start = n;
        this.end = n2;
    }

    public int length() {
        return this.end - this.start;
    }

    public boolean isEmpty() {
        return this.end == this.start;
    }

    public double get(int n) {
        Preconditions.checkElementIndex(n, this.length());
        return this.array[this.start + n];
    }

    public int indexOf(double d) {
        for (int i = this.start; i < this.end; ++i) {
            if (!ImmutableDoubleArray.areEqual(this.array[i], d)) continue;
            return i - this.start;
        }
        return -1;
    }

    public int lastIndexOf(double d) {
        for (int i = this.end - 1; i >= this.start; --i) {
            if (!ImmutableDoubleArray.areEqual(this.array[i], d)) continue;
            return i - this.start;
        }
        return -1;
    }

    public boolean contains(double d) {
        return this.indexOf(d) >= 0;
    }

    public void forEach(DoubleConsumer doubleConsumer) {
        Preconditions.checkNotNull(doubleConsumer);
        for (int i = this.start; i < this.end; ++i) {
            doubleConsumer.accept(this.array[i]);
        }
    }

    public DoubleStream stream() {
        return Arrays.stream(this.array, this.start, this.end);
    }

    public double[] toArray() {
        return Arrays.copyOfRange(this.array, this.start, this.end);
    }

    public ImmutableDoubleArray subArray(int n, int n2) {
        Preconditions.checkPositionIndexes(n, n2, this.length());
        return n == n2 ? EMPTY : new ImmutableDoubleArray(this.array, this.start + n, this.start + n2);
    }

    private Spliterator.OfDouble spliterator() {
        return Spliterators.spliterator(this.array, this.start, this.end, 1040);
    }

    public List<Double> asList() {
        return new AsList(this);
    }

    public boolean equals(@CheckForNull Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ImmutableDoubleArray)) {
            return false;
        }
        ImmutableDoubleArray immutableDoubleArray = (ImmutableDoubleArray)object;
        if (this.length() != immutableDoubleArray.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (ImmutableDoubleArray.areEqual(this.get(i), immutableDoubleArray.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean areEqual(double d, double d2) {
        return Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
    }

    public int hashCode() {
        int n = 1;
        for (int i = this.start; i < this.end; ++i) {
            n *= 31;
            n += Doubles.hashCode(this.array[i]);
        }
        return n;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(this.length() * 5);
        stringBuilder.append('[').append(this.array[this.start]);
        for (int i = this.start + 1; i < this.end; ++i) {
            stringBuilder.append(", ").append(this.array[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public ImmutableDoubleArray trimmed() {
        return this.isPartialView() ? new ImmutableDoubleArray(this.toArray()) : this;
    }

    private boolean isPartialView() {
        return this.start > 0 || this.end < this.array.length;
    }

    Object writeReplace() {
        return this.trimmed();
    }

    Object readResolve() {
        return this.isEmpty() ? EMPTY : this;
    }

    static class AsList
    extends AbstractList<Double>
    implements Serializable,
    RandomAccess {
        private final ImmutableDoubleArray parent;

        private AsList(ImmutableDoubleArray immutableDoubleArray) {
            this.parent = immutableDoubleArray;
        }

        @Override
        public int size() {
            return this.parent.length();
        }

        @Override
        public Double get(int n) {
            return this.parent.get(n);
        }

        @Override
        public boolean contains(@CheckForNull Object object) {
            return this.indexOf(object) >= 0;
        }

        @Override
        public int indexOf(@CheckForNull Object object) {
            return object instanceof Double ? this.parent.indexOf((Double)object) : -1;
        }

        @Override
        public int lastIndexOf(@CheckForNull Object object) {
            return object instanceof Double ? this.parent.lastIndexOf((Double)object) : -1;
        }

        @Override
        public List<Double> subList(int n, int n2) {
            return this.parent.subArray(n, n2).asList();
        }

        @Override
        public Spliterator<Double> spliterator() {
            return this.parent.spliterator();
        }

        @Override
        public boolean equals(@CheckForNull Object object) {
            if (object instanceof AsList) {
                AsList asList2 = (AsList)object;
                return this.parent.equals(asList2.parent);
            }
            if (!(object instanceof List)) {
                return false;
            }
            List list = (List)object;
            if (this.size() != list.size()) {
                return false;
            }
            int n = this.parent.start;
            for (Object e : list) {
                if (e instanceof Double && ImmutableDoubleArray.areEqual(this.parent.array[n++], (Double)e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return this.parent.hashCode();
        }

        @Override
        public String toString() {
            return this.parent.toString();
        }
    }

    public static final class Builder {
        private double[] array;
        private int count = 0;

        Builder(int n) {
            this.array = new double[n];
        }

        @CanIgnoreReturnValue
        public Builder add(double d) {
            this.ensureRoomFor(1);
            this.array[this.count] = d;
            ++this.count;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAll(double[] dArray) {
            this.ensureRoomFor(dArray.length);
            System.arraycopy(dArray, 0, this.array, this.count, dArray.length);
            this.count += dArray.length;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAll(Iterable<Double> iterable) {
            if (iterable instanceof Collection) {
                return this.addAll((Collection)iterable);
            }
            for (Double d : iterable) {
                this.add(d);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAll(Collection<Double> collection) {
            this.ensureRoomFor(collection.size());
            for (Double d : collection) {
                this.array[this.count++] = d;
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAll(DoubleStream doubleStream) {
            Spliterator.OfDouble ofDouble = doubleStream.spliterator();
            long l = ofDouble.getExactSizeIfKnown();
            if (l > 0L) {
                this.ensureRoomFor(Ints.saturatedCast(l));
            }
            ofDouble.forEachRemaining(this::add);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAll(ImmutableDoubleArray immutableDoubleArray) {
            this.ensureRoomFor(immutableDoubleArray.length());
            System.arraycopy(immutableDoubleArray.array, immutableDoubleArray.start, this.array, this.count, immutableDoubleArray.length());
            this.count += immutableDoubleArray.length();
            return this;
        }

        private void ensureRoomFor(int n) {
            int n2 = this.count + n;
            if (n2 > this.array.length) {
                this.array = Arrays.copyOf(this.array, Builder.expandedCapacity(this.array.length, n2));
            }
        }

        private static int expandedCapacity(int n, int n2) {
            if (n2 < 0) {
                throw new AssertionError((Object)"cannot store more than MAX_VALUE elements");
            }
            int n3 = n + (n >> 1) + 1;
            if (n3 < n2) {
                n3 = Integer.highestOneBit(n2 - 1) << 1;
            }
            if (n3 < 0) {
                n3 = Integer.MAX_VALUE;
            }
            return n3;
        }

        public ImmutableDoubleArray build() {
            return this.count == 0 ? EMPTY : new ImmutableDoubleArray(this.array, 0, this.count);
        }
    }
}

