/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.math.DoubleUtils;
import com.google.common.math.ElementTypesAreNonnullByDefault;
import com.google.common.math.MathPreconditions;
import java.math.RoundingMode;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
abstract class ToDoubleRounder<X extends Number> {
    ToDoubleRounder() {
    }

    abstract double roundToDoubleArbitrarily(X var1);

    abstract int sign(X var1);

    abstract X toX(double var1, RoundingMode var3);

    abstract X minus(X var1, X var2);

    final double roundToDouble(X x, RoundingMode roundingMode) {
        Preconditions.checkNotNull(x, "x");
        Preconditions.checkNotNull(roundingMode, "mode");
        double d = this.roundToDoubleArbitrarily(x);
        if (Double.isInfinite(d)) {
            switch (roundingMode) {
                case DOWN: 
                case HALF_EVEN: 
                case HALF_DOWN: 
                case HALF_UP: {
                    return Double.MAX_VALUE * (double)this.sign(x);
                }
                case FLOOR: {
                    return d == Double.POSITIVE_INFINITY ? Double.MAX_VALUE : Double.NEGATIVE_INFINITY;
                }
                case CEILING: {
                    return d == Double.POSITIVE_INFINITY ? Double.POSITIVE_INFINITY : -1.7976931348623157E308;
                }
                case UP: {
                    return d;
                }
                case UNNECESSARY: {
                    throw new ArithmeticException(x + " cannot be represented precisely as a double");
                }
            }
        }
        X x2 = this.toX(d, RoundingMode.UNNECESSARY);
        int n = ((Comparable)x).compareTo(x2);
        switch (roundingMode) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(n == 0);
                return d;
            }
            case FLOOR: {
                return n >= 0 ? d : DoubleUtils.nextDown(d);
            }
            case CEILING: {
                return n <= 0 ? d : Math.nextUp(d);
            }
            case DOWN: {
                if (this.sign(x) >= 0) {
                    return n >= 0 ? d : DoubleUtils.nextDown(d);
                }
                return n <= 0 ? d : Math.nextUp(d);
            }
            case UP: {
                if (this.sign(x) >= 0) {
                    return n <= 0 ? d : Math.nextUp(d);
                }
                return n >= 0 ? d : DoubleUtils.nextDown(d);
            }
            case HALF_EVEN: 
            case HALF_DOWN: 
            case HALF_UP: {
                X x3;
                double d2;
                X x4;
                double d3;
                if (n >= 0) {
                    d3 = d;
                    x4 = x2;
                    d2 = Math.nextUp(d);
                    if (d2 == Double.POSITIVE_INFINITY) {
                        return d3;
                    }
                    x3 = this.toX(d2, RoundingMode.CEILING);
                } else {
                    d2 = d;
                    x3 = x2;
                    d3 = DoubleUtils.nextDown(d);
                    if (d3 == Double.NEGATIVE_INFINITY) {
                        return d2;
                    }
                    x4 = this.toX(d3, RoundingMode.FLOOR);
                }
                X x5 = this.minus(x, x4);
                X x6 = this.minus(x3, x);
                int n2 = ((Comparable)x5).compareTo(x6);
                if (n2 < 0) {
                    return d3;
                }
                if (n2 > 0) {
                    return d2;
                }
                switch (roundingMode) {
                    case HALF_EVEN: {
                        return (Double.doubleToRawLongBits(d3) & 1L) == 0L ? d3 : d2;
                    }
                    case HALF_DOWN: {
                        return this.sign(x) >= 0 ? d3 : d2;
                    }
                    case HALF_UP: {
                        return this.sign(x) >= 0 ? d2 : d3;
                    }
                }
                throw new AssertionError((Object)"impossible");
            }
        }
        throw new AssertionError((Object)"impossible");
    }
}

