/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import com.google.common.io.IgnoreJRERequirement;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryFlag;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
abstract class TempFileCreator {
    static final TempFileCreator INSTANCE = TempFileCreator.pickSecureCreator();

    abstract File createTempDir();

    abstract File createTempFile(String var1) throws IOException;

    private static TempFileCreator pickSecureCreator() {
        try {
            Class.forName("java.nio.file.Path");
            return new JavaNioCreator();
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                int n = (Integer)Class.forName("android.os.Build$VERSION").getField("SDK_INT").get(null);
                int n2 = (Integer)Class.forName("android.os.Build$VERSION_CODES").getField("JELLY_BEAN").get(null);
                if (n < n2) {
                    return new ThrowingCreator();
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return new ThrowingCreator();
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return new ThrowingCreator();
            }
            catch (IllegalAccessException illegalAccessException) {
                return new ThrowingCreator();
            }
            return new JavaIoCreator();
        }
    }

    @IgnoreJRERequirement
    @VisibleForTesting
    static void testMakingUserPermissionsFromScratch() throws IOException {
        FileAttribute<?> fileAttribute = JavaNioCreator.userPermissions().get();
    }

    private TempFileCreator() {
    }

    private static final class ThrowingCreator
    extends TempFileCreator {
        private static final String MESSAGE = "Guava cannot securely create temporary files or directories under SDK versions before Jelly Bean. You can create one yourself, either in the insecure default directory or in a more secure directory, such as context.getCacheDir(). For more information, see the Javadoc for Files.createTempDir().";

        private ThrowingCreator() {
        }

        @Override
        File createTempDir() {
            throw new IllegalStateException(MESSAGE);
        }

        @Override
        File createTempFile(String string) throws IOException {
            throw new IOException(MESSAGE);
        }
    }

    private static final class JavaIoCreator
    extends TempFileCreator {
        private static final int TEMP_DIR_ATTEMPTS = 10000;

        private JavaIoCreator() {
        }

        @Override
        File createTempDir() {
            File file = new File(StandardSystemProperty.JAVA_IO_TMPDIR.value());
            String string = System.currentTimeMillis() + "-";
            for (int i = 0; i < 10000; ++i) {
                File file2 = new File(file, string + i);
                if (!file2.mkdir()) continue;
                return file2;
            }
            throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + string + "0 to " + string + 9999 + ')');
        }

        @Override
        File createTempFile(String string) throws IOException {
            return File.createTempFile(string, null, null);
        }
    }

    @IgnoreJRERequirement
    private static final class JavaNioCreator
    extends TempFileCreator {
        private static final PermissionSupplier filePermissions;
        private static final PermissionSupplier directoryPermissions;

        private JavaNioCreator() {
        }

        @Override
        File createTempDir() {
            try {
                return Files.createTempDirectory(Paths.get(StandardSystemProperty.JAVA_IO_TMPDIR.value(), new String[0]), null, directoryPermissions.get()).toFile();
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Failed to create directory", iOException);
            }
        }

        @Override
        File createTempFile(String string) throws IOException {
            return Files.createTempFile(Paths.get(StandardSystemProperty.JAVA_IO_TMPDIR.value(), new String[0]), string, null, filePermissions.get()).toFile();
        }

        private static PermissionSupplier userPermissions() {
            try {
                UserPrincipal userPrincipal = FileSystems.getDefault().getUserPrincipalLookupService().lookupPrincipalByName(JavaNioCreator.getUsername());
                final ImmutableList<AclEntry> immutableList = ImmutableList.of(AclEntry.newBuilder().setType(AclEntryType.ALLOW).setPrincipal(userPrincipal).setPermissions(EnumSet.allOf(AclEntryPermission.class)).setFlags(AclEntryFlag.DIRECTORY_INHERIT, AclEntryFlag.FILE_INHERIT).build());
                FileAttribute<ImmutableList<AclEntry>> fileAttribute = new FileAttribute<ImmutableList<AclEntry>>(){

                    @Override
                    public String name() {
                        return "acl:acl";
                    }

                    @Override
                    public ImmutableList<AclEntry> value() {
                        return immutableList;
                    }
                };
                return () -> fileAttribute;
            }
            catch (IOException iOException) {
                return () -> {
                    throw new IOException("Could not find user", iOException);
                };
            }
        }

        private static String getUsername() {
            String string = Objects.requireNonNull(StandardSystemProperty.USER_NAME.value());
            try {
                Class<?> clazz = Class.forName("java.lang.ProcessHandle");
                Class<?> clazz2 = Class.forName("java.lang.ProcessHandle$Info");
                Class<?> clazz3 = Class.forName("java.util.Optional");
                Method method = clazz.getMethod("current", new Class[0]);
                Method method2 = clazz.getMethod("info", new Class[0]);
                Method method3 = clazz2.getMethod("user", new Class[0]);
                Method method4 = clazz3.getMethod("orElse", Object.class);
                Object object = method.invoke(null, new Object[0]);
                Object object2 = method2.invoke(object, new Object[0]);
                Object object3 = method3.invoke(object2, new Object[0]);
                return (String)Objects.requireNonNull(method4.invoke(object3, string));
            }
            catch (ClassNotFoundException classNotFoundException) {
                return string;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwables.throwIfUnchecked(invocationTargetException.getCause());
                return string;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return string;
            }
            catch (IllegalAccessException illegalAccessException) {
                return string;
            }
        }

        static {
            Set<String> set = FileSystems.getDefault().supportedFileAttributeViews();
            if (set.contains("posix")) {
                filePermissions = () -> PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-------"));
                directoryPermissions = () -> PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------"));
            } else {
                filePermissions = set.contains("acl") ? (directoryPermissions = JavaNioCreator.userPermissions()) : (directoryPermissions = () -> {
                    throw new IOException("unrecognized FileSystem type " + FileSystems.getDefault());
                });
            }
        }

        @IgnoreJRERequirement
        private static interface PermissionSupplier {
            public FileAttribute<?> get() throws IOException;
        }
    }
}

