/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.GraphConnections;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
final class UndirectedGraphConnections<N, V>
implements GraphConnections<N, V> {
    private final Map<N, V> adjacentNodeValues;

    private UndirectedGraphConnections(Map<N, V> map) {
        this.adjacentNodeValues = Preconditions.checkNotNull(map);
    }

    static <N, V> UndirectedGraphConnections<N, V> of(ElementOrder<N> elementOrder) {
        switch (elementOrder.type()) {
            case UNORDERED: {
                return new UndirectedGraphConnections(new HashMap(2, 1.0f));
            }
            case STABLE: {
                return new UndirectedGraphConnections(new LinkedHashMap(2, 1.0f));
            }
        }
        throw new AssertionError((Object)elementOrder.type());
    }

    static <N, V> UndirectedGraphConnections<N, V> ofImmutable(Map<N, V> map) {
        return new UndirectedGraphConnections<N, V>(ImmutableMap.copyOf(map));
    }

    @Override
    public Set<N> adjacentNodes() {
        return Collections.unmodifiableSet(this.adjacentNodeValues.keySet());
    }

    @Override
    public Set<N> predecessors() {
        return this.adjacentNodes();
    }

    @Override
    public Set<N> successors() {
        return this.adjacentNodes();
    }

    @Override
    public Iterator<EndpointPair<N>> incidentEdgeIterator(N n) {
        return Iterators.transform(this.adjacentNodeValues.keySet().iterator(), object2 -> EndpointPair.unordered(n, object2));
    }

    @Override
    @CheckForNull
    public V value(N n) {
        return this.adjacentNodeValues.get(n);
    }

    @Override
    public void removePredecessor(N n) {
        V v = this.removeSuccessor(n);
    }

    @Override
    @CheckForNull
    public V removeSuccessor(N n) {
        return this.adjacentNodeValues.remove(n);
    }

    @Override
    public void addPredecessor(N n, V v) {
        V v2 = this.addSuccessor(n, v);
    }

    @Override
    @CheckForNull
    public V addSuccessor(N n, V v) {
        return this.adjacentNodeValues.put(n, v);
    }
}

