/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.graph.AbstractGraphBuilder;
import com.google.common.graph.AbstractValueGraph;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.GraphConnections;
import com.google.common.graph.Graphs;
import com.google.common.graph.IncidentEdgeSet;
import com.google.common.graph.MapIteratorCache;
import com.google.common.graph.MapRetrievalCache;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
class StandardValueGraph<N, V>
extends AbstractValueGraph<N, V> {
    private final boolean isDirected;
    private final boolean allowsSelfLoops;
    private final ElementOrder<N> nodeOrder;
    final MapIteratorCache<N, GraphConnections<N, V>> nodeConnections;
    long edgeCount;

    StandardValueGraph(AbstractGraphBuilder<? super N> abstractGraphBuilder) {
        this(abstractGraphBuilder, abstractGraphBuilder.nodeOrder.createMap(abstractGraphBuilder.expectedNodeCount.or(10)), 0L);
    }

    StandardValueGraph(AbstractGraphBuilder<? super N> abstractGraphBuilder, Map<N, GraphConnections<N, V>> map, long l) {
        this.isDirected = abstractGraphBuilder.directed;
        this.allowsSelfLoops = abstractGraphBuilder.allowsSelfLoops;
        this.nodeOrder = abstractGraphBuilder.nodeOrder.cast();
        this.nodeConnections = map instanceof TreeMap ? new MapRetrievalCache<N, GraphConnections<N, V>>(map) : new MapIteratorCache<N, GraphConnections<N, V>>(map);
        this.edgeCount = Graphs.checkNonNegative(l);
    }

    @Override
    public Set<N> nodes() {
        return this.nodeConnections.unmodifiableKeySet();
    }

    @Override
    public boolean isDirected() {
        return this.isDirected;
    }

    @Override
    public boolean allowsSelfLoops() {
        return this.allowsSelfLoops;
    }

    @Override
    public ElementOrder<N> nodeOrder() {
        return this.nodeOrder;
    }

    @Override
    public Set<N> adjacentNodes(N n) {
        return this.nodeInvalidatableSet(this.checkedConnections(n).adjacentNodes(), n);
    }

    @Override
    public Set<N> predecessors(N n) {
        return this.nodeInvalidatableSet(this.checkedConnections(n).predecessors(), n);
    }

    @Override
    public Set<N> successors(N n) {
        return this.nodeInvalidatableSet(this.checkedConnections(n).successors(), n);
    }

    @Override
    public Set<EndpointPair<N>> incidentEdges(N n) {
        final GraphConnections<N, V> graphConnections = this.checkedConnections(n);
        IncidentEdgeSet incidentEdgeSet = new IncidentEdgeSet<N>(this, this, n){

            @Override
            public Iterator<EndpointPair<N>> iterator() {
                return graphConnections.incidentEdgeIterator(this.node);
            }
        };
        return this.nodeInvalidatableSet(incidentEdgeSet, n);
    }

    @Override
    public boolean hasEdgeConnecting(N n, N n2) {
        return this.hasEdgeConnectingInternal(Preconditions.checkNotNull(n), Preconditions.checkNotNull(n2));
    }

    @Override
    public boolean hasEdgeConnecting(EndpointPair<N> endpointPair) {
        Preconditions.checkNotNull(endpointPair);
        return this.isOrderingCompatible(endpointPair) && this.hasEdgeConnectingInternal(endpointPair.nodeU(), endpointPair.nodeV());
    }

    @Override
    @CheckForNull
    public V edgeValueOrDefault(N n, N n2, @CheckForNull V v) {
        return this.edgeValueOrDefaultInternal(Preconditions.checkNotNull(n), Preconditions.checkNotNull(n2), v);
    }

    @Override
    @CheckForNull
    public V edgeValueOrDefault(EndpointPair<N> endpointPair, @CheckForNull V v) {
        this.validateEndpoints(endpointPair);
        return this.edgeValueOrDefaultInternal(endpointPair.nodeU(), endpointPair.nodeV(), v);
    }

    @Override
    protected long edgeCount() {
        return this.edgeCount;
    }

    private final GraphConnections<N, V> checkedConnections(N n) {
        GraphConnections<N, V> graphConnections = this.nodeConnections.get(n);
        if (graphConnections == null) {
            Preconditions.checkNotNull(n);
            throw new IllegalArgumentException("Node " + n + " is not an element of this graph.");
        }
        return graphConnections;
    }

    final boolean containsNode(@CheckForNull N n) {
        return this.nodeConnections.containsKey(n);
    }

    private final boolean hasEdgeConnectingInternal(N n, N n2) {
        GraphConnections<N, V> graphConnections = this.nodeConnections.get(n);
        return graphConnections != null && graphConnections.successors().contains(n2);
    }

    @CheckForNull
    private final V edgeValueOrDefaultInternal(N n, N n2, @CheckForNull V v) {
        V v2;
        GraphConnections<N, V> graphConnections = this.nodeConnections.get(n);
        V v3 = v2 = graphConnections == null ? null : (V)graphConnections.value(n2);
        if (v2 == null) {
            return v;
        }
        return v2;
    }
}

