/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.graph.AbstractGraphBuilder;
import com.google.common.graph.DirectedGraphConnections;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.GraphConnections;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.StandardValueGraph;
import com.google.common.graph.UndirectedGraphConnections;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
final class StandardMutableValueGraph<N, V>
extends StandardValueGraph<N, V>
implements MutableValueGraph<N, V> {
    private final ElementOrder<N> incidentEdgeOrder;

    StandardMutableValueGraph(AbstractGraphBuilder<? super N> abstractGraphBuilder) {
        super(abstractGraphBuilder);
        this.incidentEdgeOrder = abstractGraphBuilder.incidentEdgeOrder.cast();
    }

    @Override
    public ElementOrder<N> incidentEdgeOrder() {
        return this.incidentEdgeOrder;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean addNode(N n) {
        Preconditions.checkNotNull(n, "node");
        if (this.containsNode(n)) {
            return false;
        }
        this.addNodeInternal(n);
        return true;
    }

    @CanIgnoreReturnValue
    private GraphConnections<N, V> addNodeInternal(N n) {
        GraphConnections<N, V> graphConnections = this.newConnections();
        Preconditions.checkState(this.nodeConnections.put(n, graphConnections) == null);
        return graphConnections;
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V putEdgeValue(N n, N n2, V v) {
        GraphConnections<N, V> graphConnections;
        Preconditions.checkNotNull(n, "nodeU");
        Preconditions.checkNotNull(n2, "nodeV");
        Preconditions.checkNotNull(v, "value");
        if (!this.allowsSelfLoops()) {
            Preconditions.checkArgument(!n.equals(n2), "Cannot add self-loop edge on node %s, as self-loops are not allowed. To construct a graph that allows self-loops, call allowsSelfLoops(true) on the Builder.", n);
        }
        if ((graphConnections = (GraphConnections<N, V>)this.nodeConnections.get(n)) == null) {
            graphConnections = this.addNodeInternal(n);
        }
        V v2 = graphConnections.addSuccessor(n2, v);
        GraphConnections<N, V> graphConnections2 = (GraphConnections<N, V>)this.nodeConnections.get(n2);
        if (graphConnections2 == null) {
            graphConnections2 = this.addNodeInternal(n2);
        }
        graphConnections2.addPredecessor(n, v);
        if (v2 == null) {
            Graphs.checkPositive(++this.edgeCount);
        }
        return v2;
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V putEdgeValue(EndpointPair<N> endpointPair, V v) {
        this.validateEndpoints(endpointPair);
        return this.putEdgeValue(endpointPair.nodeU(), endpointPair.nodeV(), v);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean removeNode(N n) {
        Preconditions.checkNotNull(n, "node");
        GraphConnections graphConnections = (GraphConnections)this.nodeConnections.get(n);
        if (graphConnections == null) {
            return false;
        }
        if (this.allowsSelfLoops() && graphConnections.removeSuccessor(n) != null) {
            graphConnections.removePredecessor(n);
            --this.edgeCount;
        }
        for (Object e : ImmutableList.copyOf(graphConnections.successors())) {
            Objects.requireNonNull((GraphConnections)this.nodeConnections.getWithoutCaching(e)).removePredecessor(n);
            Objects.requireNonNull(graphConnections.removeSuccessor(e));
            --this.edgeCount;
        }
        if (this.isDirected()) {
            for (Object e : ImmutableList.copyOf(graphConnections.predecessors())) {
                Preconditions.checkState(Objects.requireNonNull((GraphConnections)this.nodeConnections.getWithoutCaching(e)).removeSuccessor(n) != null);
                graphConnections.removePredecessor(e);
                --this.edgeCount;
            }
        }
        this.nodeConnections.remove(n);
        Graphs.checkNonNegative(this.edgeCount);
        return true;
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V removeEdge(N n, N n2) {
        Preconditions.checkNotNull(n, "nodeU");
        Preconditions.checkNotNull(n2, "nodeV");
        GraphConnections graphConnections = (GraphConnections)this.nodeConnections.get(n);
        GraphConnections graphConnections2 = (GraphConnections)this.nodeConnections.get(n2);
        if (graphConnections == null || graphConnections2 == null) {
            return null;
        }
        Object v = graphConnections.removeSuccessor(n2);
        if (v != null) {
            graphConnections2.removePredecessor(n);
            Graphs.checkNonNegative(--this.edgeCount);
        }
        return v;
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V removeEdge(EndpointPair<N> endpointPair) {
        this.validateEndpoints(endpointPair);
        return this.removeEdge(endpointPair.nodeU(), endpointPair.nodeV());
    }

    private GraphConnections<N, V> newConnections() {
        return this.isDirected() ? DirectedGraphConnections.of(this.incidentEdgeOrder) : UndirectedGraphConnections.of(this.incidentEdgeOrder);
    }
}

