/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
abstract class MultiEdgesConnecting<E>
extends AbstractSet<E> {
    private final Map<E, ?> outEdgeToNode;
    private final Object targetNode;

    MultiEdgesConnecting(Map<E, ?> map, Object object) {
        this.outEdgeToNode = Preconditions.checkNotNull(map);
        this.targetNode = Preconditions.checkNotNull(object);
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        final Iterator<Map.Entry<E, ?>> iterator2 = this.outEdgeToNode.entrySet().iterator();
        return new AbstractIterator<E>(){

            @Override
            @CheckForNull
            protected E computeNext() {
                while (iterator2.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator2.next();
                    if (!MultiEdgesConnecting.this.targetNode.equals(entry.getValue())) continue;
                    return entry.getKey();
                }
                return this.endOfData();
            }
        };
    }

    @Override
    public boolean contains(@CheckForNull Object object) {
        return this.targetNode.equals(this.outEdgeToNode.get(object));
    }
}

