/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.BaseGraph;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import java.util.AbstractSet;
import java.util.Set;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
abstract class IncidentEdgeSet<N>
extends AbstractSet<EndpointPair<N>> {
    final N node;
    final BaseGraph<N> graph;

    IncidentEdgeSet(BaseGraph<N> baseGraph, N n) {
        this.graph = baseGraph;
        this.node = n;
    }

    @Override
    public boolean remove(@CheckForNull Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        if (this.graph.isDirected()) {
            return this.graph.inDegree(this.node) + this.graph.outDegree(this.node) - (this.graph.successors((Object)this.node).contains(this.node) ? 1 : 0);
        }
        return this.graph.adjacentNodes(this.node).size();
    }

    @Override
    public boolean contains(@CheckForNull Object object) {
        if (!(object instanceof EndpointPair)) {
            return false;
        }
        EndpointPair endpointPair = (EndpointPair)object;
        if (this.graph.isDirected()) {
            if (!endpointPair.isOrdered()) {
                return false;
            }
            Object n = endpointPair.source();
            Object n2 = endpointPair.target();
            return this.node.equals(n) && this.graph.successors((Object)this.node).contains(n2) || this.node.equals(n2) && this.graph.predecessors((Object)this.node).contains(n);
        }
        if (endpointPair.isOrdered()) {
            return false;
        }
        Set<N> set = this.graph.adjacentNodes(this.node);
        Object n = endpointPair.nodeU();
        Object n3 = endpointPair.nodeV();
        return this.node.equals(n3) && set.contains(n) || this.node.equals(n) && set.contains(n3);
    }
}

