/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.AbstractGraph;
import com.google.common.graph.BaseGraph;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import java.util.Set;

@ElementTypesAreNonnullByDefault
abstract class ForwardingGraph<N>
extends AbstractGraph<N> {
    ForwardingGraph() {
    }

    abstract BaseGraph<N> delegate();

    @Override
    public Set<N> nodes() {
        return this.delegate().nodes();
    }

    @Override
    protected long edgeCount() {
        return this.delegate().edges().size();
    }

    @Override
    public boolean isDirected() {
        return this.delegate().isDirected();
    }

    @Override
    public boolean allowsSelfLoops() {
        return this.delegate().allowsSelfLoops();
    }

    @Override
    public ElementOrder<N> nodeOrder() {
        return this.delegate().nodeOrder();
    }

    @Override
    public ElementOrder<N> incidentEdgeOrder() {
        return this.delegate().incidentEdgeOrder();
    }

    @Override
    public Set<N> adjacentNodes(N n) {
        return this.delegate().adjacentNodes(n);
    }

    @Override
    public Set<N> predecessors(N n) {
        return this.delegate().predecessors((Object)n);
    }

    @Override
    public Set<N> successors(N n) {
        return this.delegate().successors((Object)n);
    }

    @Override
    public Set<EndpointPair<N>> incidentEdges(N n) {
        return this.delegate().incidentEdges(n);
    }

    @Override
    public int degree(N n) {
        return this.delegate().degree(n);
    }

    @Override
    public int inDegree(N n) {
        return this.delegate().inDegree(n);
    }

    @Override
    public int outDegree(N n) {
        return this.delegate().outDegree(n);
    }

    @Override
    public boolean hasEdgeConnecting(N n, N n2) {
        return this.delegate().hasEdgeConnecting(n, n2);
    }

    @Override
    public boolean hasEdgeConnecting(EndpointPair<N> endpointPair) {
        return this.delegate().hasEdgeConnecting(endpointPair);
    }
}

