/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.graph.BaseGraph;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.EndpointPairIterator;
import com.google.common.graph.IncidentEdgeSet;
import com.google.common.graph.InvalidatableSet;
import com.google.common.math.IntMath;
import com.google.common.primitives.Ints;
import java.util.AbstractSet;
import java.util.Set;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
abstract class AbstractBaseGraph<N>
implements BaseGraph<N> {
    AbstractBaseGraph() {
    }

    protected long edgeCount() {
        long l = 0L;
        for (Object n : this.nodes()) {
            l += (long)this.degree(n);
        }
        Preconditions.checkState((l & 1L) == 0L);
        return l >>> 1;
    }

    @Override
    public Set<EndpointPair<N>> edges() {
        return new AbstractSet<EndpointPair<N>>(){

            @Override
            public UnmodifiableIterator<EndpointPair<N>> iterator() {
                return EndpointPairIterator.of(AbstractBaseGraph.this);
            }

            @Override
            public int size() {
                return Ints.saturatedCast(AbstractBaseGraph.this.edgeCount());
            }

            @Override
            public boolean remove(@CheckForNull Object object) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean contains(@CheckForNull Object object) {
                if (!(object instanceof EndpointPair)) {
                    return false;
                }
                EndpointPair endpointPair = (EndpointPair)object;
                return AbstractBaseGraph.this.isOrderingCompatible(endpointPair) && AbstractBaseGraph.this.nodes().contains(endpointPair.nodeU()) && AbstractBaseGraph.this.successors(endpointPair.nodeU()).contains(endpointPair.nodeV());
            }
        };
    }

    @Override
    public ElementOrder<N> incidentEdgeOrder() {
        return ElementOrder.unordered();
    }

    @Override
    public Set<EndpointPair<N>> incidentEdges(N n) {
        Preconditions.checkNotNull(n);
        Preconditions.checkArgument(this.nodes().contains(n), "Node %s is not an element of this graph.", n);
        IncidentEdgeSet incidentEdgeSet = new IncidentEdgeSet<N>(this, this, n){

            @Override
            public UnmodifiableIterator<EndpointPair<N>> iterator() {
                if (this.graph.isDirected()) {
                    return Iterators.unmodifiableIterator(Iterators.concat(Iterators.transform(this.graph.predecessors(this.node).iterator(), object -> EndpointPair.ordered(object, this.node)), Iterators.transform(Sets.difference(this.graph.successors(this.node), ImmutableSet.of(this.node)).iterator(), object -> EndpointPair.ordered(this.node, object))));
                }
                return Iterators.unmodifiableIterator(Iterators.transform(this.graph.adjacentNodes(this.node).iterator(), object -> EndpointPair.unordered(this.node, object)));
            }
        };
        return this.nodeInvalidatableSet(incidentEdgeSet, n);
    }

    @Override
    public int degree(N n) {
        if (this.isDirected()) {
            return IntMath.saturatedAdd(this.predecessors((Object)n).size(), this.successors((Object)n).size());
        }
        Set<N> set = this.adjacentNodes(n);
        int n2 = this.allowsSelfLoops() && set.contains(n) ? 1 : 0;
        return IntMath.saturatedAdd(set.size(), n2);
    }

    @Override
    public int inDegree(N n) {
        return this.isDirected() ? this.predecessors((Object)n).size() : this.degree(n);
    }

    @Override
    public int outDegree(N n) {
        return this.isDirected() ? this.successors((Object)n).size() : this.degree(n);
    }

    @Override
    public boolean hasEdgeConnecting(N n, N n2) {
        Preconditions.checkNotNull(n);
        Preconditions.checkNotNull(n2);
        return this.nodes().contains(n) && this.successors((Object)n).contains(n2);
    }

    @Override
    public boolean hasEdgeConnecting(EndpointPair<N> endpointPair) {
        Preconditions.checkNotNull(endpointPair);
        if (!this.isOrderingCompatible(endpointPair)) {
            return false;
        }
        N n = endpointPair.nodeU();
        N n2 = endpointPair.nodeV();
        return this.nodes().contains(n) && this.successors((Object)n).contains(n2);
    }

    protected final void validateEndpoints(EndpointPair<?> endpointPair) {
        Preconditions.checkNotNull(endpointPair);
        Preconditions.checkArgument(this.isOrderingCompatible(endpointPair), "Mismatch: endpoints' ordering is not compatible with directionality of the graph");
    }

    protected final boolean isOrderingCompatible(EndpointPair<?> endpointPair) {
        return endpointPair.isOrdered() == this.isDirected();
    }

    protected final <T> Set<T> nodeInvalidatableSet(Set<T> set, N n) {
        return InvalidatableSet.of(set, () -> this.nodes().contains(n), () -> String.format("Node %s that was used to generate this set is no longer in the graph.", n));
    }

    protected final <T> Set<T> nodePairInvalidatableSet(Set<T> set, N n, N n2) {
        return InvalidatableSet.of(set, () -> this.nodes().contains(n) && this.nodes().contains(n2), () -> String.format("Node %s or node %s that were used to generate this set are no longer in the graph.", n, n2));
    }
}

