/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedAsList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.SortedIterables;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableSortedSet<E>
extends ImmutableSortedSet<E> {
    static final RegularImmutableSortedSet<Comparable> NATURAL_EMPTY_SET = new RegularImmutableSortedSet(ImmutableList.of(), Ordering.natural());
    private final transient ImmutableList<E> elements;

    RegularImmutableSortedSet(ImmutableList<E> immutableList, Comparator<? super E> comparator) {
        super(comparator);
        this.elements = immutableList;
    }

    @Override
    @CheckForNull
    Object[] internalArray() {
        return this.elements.internalArray();
    }

    @Override
    int internalArrayStart() {
        return this.elements.internalArrayStart();
    }

    @Override
    int internalArrayEnd() {
        return this.elements.internalArrayEnd();
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return this.elements.iterator();
    }

    @Override
    @GwtIncompatible
    public UnmodifiableIterator<E> descendingIterator() {
        return this.elements.reverse().iterator();
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.asList().spliterator();
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        this.elements.forEach(consumer);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean contains(@CheckForNull Object object) {
        try {
            return object != null && this.unsafeBinarySearch(object) >= 0;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection instanceof Multiset) {
            collection = ((Multiset)collection).elementSet();
        }
        if (!SortedIterables.hasSameComparator(this.comparator(), collection) || collection.size() <= 1) {
            return super.containsAll(collection);
        }
        Iterator iterator2 = this.iterator();
        Iterator<?> iterator3 = collection.iterator();
        if (!iterator2.hasNext()) {
            return false;
        }
        Object obj = iterator3.next();
        Object e = iterator2.next();
        try {
            while (true) {
                int n;
                if ((n = this.unsafeCompare(e, obj)) < 0) {
                    if (!iterator2.hasNext()) {
                        return false;
                    }
                    e = iterator2.next();
                    continue;
                }
                if (n == 0) {
                    if (!iterator3.hasNext()) {
                        return true;
                    }
                    obj = iterator3.next();
                    continue;
                }
                if (n > 0) break;
            }
            return false;
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
    }

    private int unsafeBinarySearch(Object object) throws ClassCastException {
        return Collections.binarySearch(this.elements, object, this.unsafeComparator());
    }

    @Override
    boolean isPartialView() {
        return this.elements.isPartialView();
    }

    @Override
    int copyIntoArray(@Nullable Object[] objectArray, int n) {
        return this.elements.copyIntoArray(objectArray, n);
    }

    @Override
    public boolean equals(@CheckForNull Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set set = (Set)object;
        if (this.size() != set.size()) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        if (SortedIterables.hasSameComparator(this.comparator, set)) {
            Iterator iterator2 = set.iterator();
            try {
                for (Object e : this) {
                    Object e2 = iterator2.next();
                    if (e2 != null && this.unsafeCompare(e, e2) == 0) continue;
                    return false;
                }
                return true;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NoSuchElementException noSuchElementException) {
                return false;
            }
        }
        return this.containsAll(set);
    }

    @Override
    public E first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elements.get(0);
    }

    @Override
    public E last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elements.get(this.size() - 1);
    }

    @Override
    @CheckForNull
    public E lower(E e) {
        int n = this.headIndex(e, false) - 1;
        return n == -1 ? null : (E)this.elements.get(n);
    }

    @Override
    @CheckForNull
    public E floor(E e) {
        int n = this.headIndex(e, true) - 1;
        return n == -1 ? null : (E)this.elements.get(n);
    }

    @Override
    @CheckForNull
    public E ceiling(E e) {
        int n = this.tailIndex(e, true);
        return n == this.size() ? null : (E)this.elements.get(n);
    }

    @Override
    @CheckForNull
    public E higher(E e) {
        int n = this.tailIndex(e, false);
        return n == this.size() ? null : (E)this.elements.get(n);
    }

    @Override
    ImmutableSortedSet<E> headSetImpl(E e, boolean bl) {
        return this.getSubSet(0, this.headIndex(e, bl));
    }

    int headIndex(E e, boolean bl) {
        int n = Collections.binarySearch(this.elements, Preconditions.checkNotNull(e), this.comparator());
        if (n >= 0) {
            return bl ? n + 1 : n;
        }
        return ~n;
    }

    @Override
    ImmutableSortedSet<E> subSetImpl(E e, boolean bl, E e2, boolean bl2) {
        return this.tailSetImpl(e, bl).headSetImpl(e2, bl2);
    }

    @Override
    ImmutableSortedSet<E> tailSetImpl(E e, boolean bl) {
        return this.getSubSet(this.tailIndex(e, bl), this.size());
    }

    int tailIndex(E e, boolean bl) {
        int n = Collections.binarySearch(this.elements, Preconditions.checkNotNull(e), this.comparator());
        if (n >= 0) {
            return bl ? n : n + 1;
        }
        return ~n;
    }

    Comparator<Object> unsafeComparator() {
        return this.comparator;
    }

    RegularImmutableSortedSet<E> getSubSet(int n, int n2) {
        if (n == 0 && n2 == this.size()) {
            return this;
        }
        if (n < n2) {
            return new RegularImmutableSortedSet<E>(this.elements.subList(n, n2), this.comparator);
        }
        return RegularImmutableSortedSet.emptySet(this.comparator);
    }

    @Override
    int indexOf(@CheckForNull Object object) {
        int n;
        if (object == null) {
            return -1;
        }
        try {
            n = Collections.binarySearch(this.elements, object, this.unsafeComparator());
        }
        catch (ClassCastException classCastException) {
            return -1;
        }
        return n >= 0 ? n : -1;
    }

    @Override
    ImmutableList<E> createAsList() {
        return this.size() <= 1 ? this.elements : new ImmutableSortedAsList<E>(this, this.elements);
    }

    @Override
    ImmutableSortedSet<E> createDescendingSet() {
        Comparator comparator = Collections.reverseOrder(this.comparator);
        return this.isEmpty() ? RegularImmutableSortedSet.emptySet(comparator) : new RegularImmutableSortedSet<E>(this.elements.reverse(), comparator);
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }
}

