/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.collect.CompactHashSet;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class Platform {
    static <K, V> Map<K, V> newHashMapWithExpectedSize(int n) {
        return Maps.newHashMapWithExpectedSize(n);
    }

    static <K, V> Map<K, V> newLinkedHashMapWithExpectedSize(int n) {
        return Maps.newLinkedHashMapWithExpectedSize(n);
    }

    static <E> Set<E> newHashSetWithExpectedSize(int n) {
        return Sets.newHashSetWithExpectedSize(n);
    }

    static <E> Set<E> newConcurrentHashSet() {
        return ConcurrentHashMap.newKeySet();
    }

    static <E> Set<E> newLinkedHashSetWithExpectedSize(int n) {
        return Sets.newLinkedHashSetWithExpectedSize(n);
    }

    static <K, V> Map<K, V> preservesInsertionOrderOnPutsMap() {
        return Maps.newLinkedHashMap();
    }

    static <E> Set<E> preservesInsertionOrderOnAddsSet() {
        return CompactHashSet.create();
    }

    static <T> T[] newArray(T[] TArray, int n) {
        T[] TArray2 = TArray.length == 0 ? TArray : Arrays.copyOf(TArray, 0);
        return Arrays.copyOf(TArray2, n);
    }

    static <T> T[] copy(Object[] objectArray, int n, int n2, T[] TArray) {
        return Arrays.copyOfRange(objectArray, n, n2, TArray.getClass());
    }

    @J2ktIncompatible
    static MapMaker tryWeakKeys(MapMaker mapMaker) {
        return mapMaker.weakKeys();
    }

    static <E extends Enum<E>> Class<E> getDeclaringClassOrObjectForJ2cl(E e) {
        return e.getDeclaringClass();
    }

    static int reduceIterationsIfGwt(int n) {
        return n;
    }

    static int reduceExponentIfGwt(int n) {
        return n;
    }

    private Platform() {
    }
}

