/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class JdkBackedImmutableMultiset<E>
extends ImmutableMultiset<E> {
    private final Map<E, Integer> delegateMap;
    private final ImmutableList<Multiset.Entry<E>> entries;
    private final long size;
    @LazyInit
    @CheckForNull
    private transient ImmutableSet<E> elementSet;

    static <E> ImmutableMultiset<E> create(Collection<? extends Multiset.Entry<? extends E>> collection) {
        Object[] objectArray = collection.toArray(new Multiset.Entry[0]);
        HashMap hashMap = Maps.newHashMapWithExpectedSize(objectArray.length);
        long l = 0L;
        for (int i = 0; i < objectArray.length; ++i) {
            Multiset.Entry entry = objectArray[i];
            int n = entry.getCount();
            l += (long)n;
            Object e = Preconditions.checkNotNull(entry.getElement());
            hashMap.put(e, n);
            if (entry instanceof Multisets.ImmutableEntry) continue;
            objectArray[i] = Multisets.immutableEntry(e, n);
        }
        return new JdkBackedImmutableMultiset(hashMap, ImmutableList.asImmutableList(objectArray), l);
    }

    private JdkBackedImmutableMultiset(Map<E, Integer> map, ImmutableList<Multiset.Entry<E>> immutableList, long l) {
        this.delegateMap = map;
        this.entries = immutableList;
        this.size = l;
    }

    @Override
    public int count(@CheckForNull Object object) {
        return this.delegateMap.getOrDefault(object, 0);
    }

    @Override
    public ImmutableSet<E> elementSet() {
        ImmutableSet<E> immutableSet = this.elementSet;
        return immutableSet == null ? (this.elementSet = new ImmutableMultiset.ElementSet<E>(this.entries, this)) : immutableSet;
    }

    @Override
    Multiset.Entry<E> getEntry(int n) {
        return (Multiset.Entry)this.entries.get(n);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.size);
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }
}

