/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMapEntry;
import com.google.common.collect.ImmutableMapEntrySet;
import com.google.common.collect.ImmutableMapKeySet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.RegularImmutableMap;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.j2objc.annotations.RetainedWith;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class JdkBackedImmutableBiMap<K, V>
extends ImmutableBiMap<K, V> {
    private final transient ImmutableList<Map.Entry<K, V>> entries;
    private final Map<K, V> forwardDelegate;
    private final Map<V, K> backwardDelegate;
    @LazyInit
    @CheckForNull
    @RetainedWith
    private transient JdkBackedImmutableBiMap<V, K> inverse;

    @VisibleForTesting
    static <K, V> ImmutableBiMap<K, V> create(int n, @Nullable Map.Entry<K, V>[] entryArray) {
        HashMap hashMap = Maps.newHashMapWithExpectedSize(n);
        HashMap hashMap2 = Maps.newHashMapWithExpectedSize(n);
        for (int i = 0; i < n; ++i) {
            ImmutableMapEntry<K, V> immutableMapEntry = RegularImmutableMap.makeImmutable(Objects.requireNonNull(entryArray[i]));
            entryArray[i] = immutableMapEntry;
            Object v = hashMap.putIfAbsent(immutableMapEntry.getKey(), immutableMapEntry.getValue());
            if (v != null) {
                throw JdkBackedImmutableBiMap.conflictException("key", immutableMapEntry.getKey() + "=" + v, entryArray[i]);
            }
            Object k = hashMap2.putIfAbsent(immutableMapEntry.getValue(), immutableMapEntry.getKey());
            if (k == null) continue;
            throw JdkBackedImmutableBiMap.conflictException("value", k + "=" + immutableMapEntry.getValue(), entryArray[i]);
        }
        ImmutableList<Map.Entry<K, V>> immutableList = ImmutableList.asImmutableList(entryArray, n);
        return new JdkBackedImmutableBiMap<K, V>(immutableList, hashMap, hashMap2);
    }

    private JdkBackedImmutableBiMap(ImmutableList<Map.Entry<K, V>> immutableList, Map<K, V> map, Map<V, K> map2) {
        this.entries = immutableList;
        this.forwardDelegate = map;
        this.backwardDelegate = map2;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public ImmutableBiMap<V, K> inverse() {
        JdkBackedImmutableBiMap<K, V> jdkBackedImmutableBiMap = this.inverse;
        if (jdkBackedImmutableBiMap == null) {
            this.inverse = jdkBackedImmutableBiMap = new JdkBackedImmutableBiMap<K, V>(new InverseEntries(), this.backwardDelegate, this.forwardDelegate);
            jdkBackedImmutableBiMap.inverse = this;
        }
        return jdkBackedImmutableBiMap;
    }

    @Override
    @CheckForNull
    public V get(@CheckForNull Object object) {
        return this.forwardDelegate.get(object);
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new ImmutableMapEntrySet.RegularEntrySet<K, V>(this, this.entries);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new ImmutableMapKeySet(this);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }

    private final class InverseEntries
    extends ImmutableList<Map.Entry<V, K>> {
        private InverseEntries() {
        }

        @Override
        public Map.Entry<V, K> get(int n) {
            Map.Entry entry = (Map.Entry)JdkBackedImmutableBiMap.this.entries.get(n);
            return Maps.immutableEntry(entry.getValue(), entry.getKey());
        }

        @Override
        boolean isPartialView() {
            return false;
        }

        @Override
        public int size() {
            return JdkBackedImmutableBiMap.this.entries.size();
        }

        @Override
        @J2ktIncompatible
        @GwtIncompatible
        Object writeReplace() {
            return super.writeReplace();
        }
    }
}

