/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectCollectors;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableAsList;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMapEntrySet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.RegularImmutableList;
import com.google.common.collect.RegularImmutableSortedSet;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.DoNotCall;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.SortedMap;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public final class ImmutableSortedMap<K, V>
extends ImmutableMap<K, V>
implements NavigableMap<K, V> {
    private static final Comparator<?> NATURAL_ORDER = Ordering.natural();
    private static final ImmutableSortedMap<Comparable<?>, Object> NATURAL_EMPTY_MAP = new ImmutableSortedMap(ImmutableSortedSet.emptySet(Ordering.natural()), ImmutableList.of());
    private final transient RegularImmutableSortedSet<K> keySet;
    private final transient ImmutableList<V> valueList;
    @CheckForNull
    private transient ImmutableSortedMap<K, V> descendingMap;
    private static final long serialVersionUID = 0L;

    public static <T, K, V> Collector<T, ?, ImmutableSortedMap<K, V>> toImmutableSortedMap(Comparator<? super K> comparator, Function<? super T, ? extends K> function, Function<? super T, ? extends V> function2) {
        return CollectCollectors.toImmutableSortedMap(comparator, function, function2);
    }

    public static <T, K, V> Collector<T, ?, ImmutableSortedMap<K, V>> toImmutableSortedMap(Comparator<? super K> comparator, Function<? super T, ? extends K> function, Function<? super T, ? extends V> function2, BinaryOperator<V> binaryOperator) {
        return CollectCollectors.toImmutableSortedMap(comparator, function, function2, binaryOperator);
    }

    static <K, V> ImmutableSortedMap<K, V> emptyMap(Comparator<? super K> comparator) {
        if (Ordering.natural().equals(comparator)) {
            return ImmutableSortedMap.of();
        }
        return new ImmutableSortedMap(ImmutableSortedSet.emptySet(comparator), ImmutableList.of());
    }

    public static <K, V> ImmutableSortedMap<K, V> of() {
        return NATURAL_EMPTY_MAP;
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k, V v) {
        return ImmutableSortedMap.of(Ordering.natural(), k, v);
    }

    private static <K, V> ImmutableSortedMap<K, V> of(Comparator<? super K> comparator, K k, V v) {
        return new ImmutableSortedMap<K, V>(new RegularImmutableSortedSet<K>(ImmutableList.of(k), Preconditions.checkNotNull(comparator)), ImmutableList.of(v));
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2) {
        return ImmutableSortedMap.fromEntries(ImmutableSortedMap.entryOf(k, v), ImmutableSortedMap.entryOf(k2, v2));
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3) {
        return ImmutableSortedMap.fromEntries(ImmutableSortedMap.entryOf(k, v), ImmutableSortedMap.entryOf(k2, v2), ImmutableSortedMap.entryOf(k3, v3));
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4) {
        return ImmutableSortedMap.fromEntries(ImmutableSortedMap.entryOf(k, v), ImmutableSortedMap.entryOf(k2, v2), ImmutableSortedMap.entryOf(k3, v3), ImmutableSortedMap.entryOf(k4, v4));
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return ImmutableSortedMap.fromEntries(ImmutableSortedMap.entryOf(k, v), ImmutableSortedMap.entryOf(k2, v2), ImmutableSortedMap.entryOf(k3, v3), ImmutableSortedMap.entryOf(k4, v4), ImmutableSortedMap.entryOf(k5, v5));
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        return ImmutableSortedMap.fromEntries(ImmutableSortedMap.entryOf(k, v), ImmutableSortedMap.entryOf(k2, v2), ImmutableSortedMap.entryOf(k3, v3), ImmutableSortedMap.entryOf(k4, v4), ImmutableSortedMap.entryOf(k5, v5), ImmutableSortedMap.entryOf(k6, v6));
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        return ImmutableSortedMap.fromEntries(ImmutableSortedMap.entryOf(k, v), ImmutableSortedMap.entryOf(k2, v2), ImmutableSortedMap.entryOf(k3, v3), ImmutableSortedMap.entryOf(k4, v4), ImmutableSortedMap.entryOf(k5, v5), ImmutableSortedMap.entryOf(k6, v6), ImmutableSortedMap.entryOf(k7, v7));
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        return ImmutableSortedMap.fromEntries(ImmutableSortedMap.entryOf(k, v), ImmutableSortedMap.entryOf(k2, v2), ImmutableSortedMap.entryOf(k3, v3), ImmutableSortedMap.entryOf(k4, v4), ImmutableSortedMap.entryOf(k5, v5), ImmutableSortedMap.entryOf(k6, v6), ImmutableSortedMap.entryOf(k7, v7), ImmutableSortedMap.entryOf(k8, v8));
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9) {
        return ImmutableSortedMap.fromEntries(ImmutableSortedMap.entryOf(k, v), ImmutableSortedMap.entryOf(k2, v2), ImmutableSortedMap.entryOf(k3, v3), ImmutableSortedMap.entryOf(k4, v4), ImmutableSortedMap.entryOf(k5, v5), ImmutableSortedMap.entryOf(k6, v6), ImmutableSortedMap.entryOf(k7, v7), ImmutableSortedMap.entryOf(k8, v8), ImmutableSortedMap.entryOf(k9, v9));
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10) {
        return ImmutableSortedMap.fromEntries(ImmutableSortedMap.entryOf(k, v), ImmutableSortedMap.entryOf(k2, v2), ImmutableSortedMap.entryOf(k3, v3), ImmutableSortedMap.entryOf(k4, v4), ImmutableSortedMap.entryOf(k5, v5), ImmutableSortedMap.entryOf(k6, v6), ImmutableSortedMap.entryOf(k7, v7), ImmutableSortedMap.entryOf(k8, v8), ImmutableSortedMap.entryOf(k9, v9), ImmutableSortedMap.entryOf(k10, v10));
    }

    public static <K, V> ImmutableSortedMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        Ordering ordering = (Ordering)NATURAL_ORDER;
        return ImmutableSortedMap.copyOfInternal(map, ordering);
    }

    public static <K, V> ImmutableSortedMap<K, V> copyOf(Map<? extends K, ? extends V> map, Comparator<? super K> comparator) {
        return ImmutableSortedMap.copyOfInternal(map, Preconditions.checkNotNull(comparator));
    }

    public static <K, V> ImmutableSortedMap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable) {
        Ordering ordering = (Ordering)NATURAL_ORDER;
        return ImmutableSortedMap.copyOf(iterable, ordering);
    }

    public static <K, V> ImmutableSortedMap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable, Comparator<? super K> comparator) {
        return ImmutableSortedMap.fromEntries(Preconditions.checkNotNull(comparator), false, iterable);
    }

    public static <K, V> ImmutableSortedMap<K, V> copyOfSorted(SortedMap<K, ? extends V> sortedMap) {
        ImmutableSortedMap immutableSortedMap;
        Comparator<Object> comparator = sortedMap.comparator();
        if (comparator == null) {
            comparator = NATURAL_ORDER;
        }
        if (sortedMap instanceof ImmutableSortedMap && !(immutableSortedMap = (ImmutableSortedMap)sortedMap).isPartialView()) {
            return immutableSortedMap;
        }
        return ImmutableSortedMap.fromEntries(comparator, true, sortedMap.entrySet());
    }

    private static <K, V> ImmutableSortedMap<K, V> copyOfInternal(Map<? extends K, ? extends V> map, Comparator<? super K> comparator) {
        SortedMap sortedMap;
        boolean bl = false;
        if (map instanceof SortedMap) {
            sortedMap = (SortedMap)map;
            Comparator comparator2 = sortedMap.comparator();
            boolean bl2 = comparator2 == null ? comparator == NATURAL_ORDER : (bl = comparator.equals(comparator2));
        }
        if (bl && map instanceof ImmutableSortedMap && !((ImmutableSortedMap)(sortedMap = (ImmutableSortedMap)map)).isPartialView()) {
            return sortedMap;
        }
        return ImmutableSortedMap.fromEntries(comparator, bl, map.entrySet());
    }

    private static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> fromEntries(Map.Entry<K, V> ... entryArray) {
        return ImmutableSortedMap.fromEntries(Ordering.natural(), false, entryArray, entryArray.length);
    }

    private static <K, V> ImmutableSortedMap<K, V> fromEntries(Comparator<? super K> comparator, boolean bl, Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable) {
        Map.Entry[] entryArray = Iterables.toArray(iterable, EMPTY_ENTRY_ARRAY);
        return ImmutableSortedMap.fromEntries(comparator, bl, entryArray, entryArray.length);
    }

    private static <K, V> ImmutableSortedMap<K, V> fromEntries(Comparator<? super K> comparator, boolean bl, @Nullable Map.Entry<K, V>[] entryArray, int n) {
        switch (n) {
            case 0: {
                return ImmutableSortedMap.emptyMap(comparator);
            }
            case 1: {
                Map.Entry<K, V> entry3 = Objects.requireNonNull(entryArray[0]);
                return ImmutableSortedMap.of(comparator, entry3.getKey(), entry3.getValue());
            }
        }
        Object[] objectArray = new Object[n];
        Object[] objectArray2 = new Object[n];
        if (bl) {
            for (int i = 0; i < n; ++i) {
                Map.Entry<K, V> entry4 = Objects.requireNonNull(entryArray[i]);
                K k = entry4.getKey();
                V v = entry4.getValue();
                CollectPreconditions.checkEntryNotNull(k, v);
                objectArray[i] = k;
                objectArray2[i] = v;
            }
        } else {
            Arrays.sort(entryArray, 0, n, (entry, entry2) -> {
                Objects.requireNonNull(entry);
                Objects.requireNonNull(entry2);
                return comparator.compare(entry.getKey(), entry2.getKey());
            });
            Map.Entry<K, V> entry5 = Objects.requireNonNull(entryArray[0]);
            K k = entry5.getKey();
            objectArray[0] = k;
            objectArray2[0] = entry5.getValue();
            CollectPreconditions.checkEntryNotNull(objectArray[0], objectArray2[0]);
            for (int i = 1; i < n; ++i) {
                Map.Entry<K, V> entry6 = Objects.requireNonNull(entryArray[i - 1]);
                Map.Entry<K, V> entry7 = Objects.requireNonNull(entryArray[i]);
                K k2 = entry7.getKey();
                V v = entry7.getValue();
                CollectPreconditions.checkEntryNotNull(k2, v);
                objectArray[i] = k2;
                objectArray2[i] = v;
                ImmutableSortedMap.checkNoConflict(comparator.compare(k, k2) != 0, "key", entry6, entry7);
                k = k2;
            }
        }
        return new ImmutableSortedMap(new RegularImmutableSortedSet<K>(new RegularImmutableList(objectArray), comparator), new RegularImmutableList(objectArray2));
    }

    public static <K extends Comparable<?>, V> Builder<K, V> naturalOrder() {
        return new Builder(Ordering.natural());
    }

    public static <K, V> Builder<K, V> orderedBy(Comparator<K> comparator) {
        return new Builder(comparator);
    }

    public static <K extends Comparable<?>, V> Builder<K, V> reverseOrder() {
        return new Builder(Ordering.natural().reverse());
    }

    ImmutableSortedMap(RegularImmutableSortedSet<K> regularImmutableSortedSet, ImmutableList<V> immutableList) {
        this(regularImmutableSortedSet, immutableList, null);
    }

    ImmutableSortedMap(RegularImmutableSortedSet<K> regularImmutableSortedSet, ImmutableList<V> immutableList, @CheckForNull ImmutableSortedMap<K, V> immutableSortedMap) {
        this.keySet = regularImmutableSortedSet;
        this.valueList = immutableList;
        this.descendingMap = immutableSortedMap;
    }

    @Override
    public int size() {
        return this.valueList.size();
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        Preconditions.checkNotNull(biConsumer);
        ImmutableList immutableList = this.keySet.asList();
        for (int i = 0; i < this.size(); ++i) {
            biConsumer.accept(immutableList.get(i), this.valueList.get(i));
        }
    }

    @Override
    @CheckForNull
    public V get(@CheckForNull Object object) {
        int n = this.keySet.indexOf(object);
        return n == -1 ? null : (V)this.valueList.get(n);
    }

    @Override
    boolean isPartialView() {
        return this.keySet.isPartialView() || this.valueList.isPartialView();
    }

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        return super.entrySet();
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        class EntrySet
        extends ImmutableMapEntrySet<K, V> {
            EntrySet() {
            }

            @Override
            public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
                return this.asList().iterator();
            }

            @Override
            public Spliterator<Map.Entry<K, V>> spliterator() {
                return this.asList().spliterator();
            }

            @Override
            public void forEach(Consumer<? super Map.Entry<K, V>> consumer) {
                this.asList().forEach(consumer);
            }

            @Override
            ImmutableList<Map.Entry<K, V>> createAsList() {
                return new ImmutableAsList<Map.Entry<K, V>>(){

                    @Override
                    public Map.Entry<K, V> get(int n) {
                        return new AbstractMap.SimpleImmutableEntry(ImmutableSortedMap.this.keySet.asList().get(n), ImmutableSortedMap.this.valueList.get(n));
                    }

                    @Override
                    public Spliterator<Map.Entry<K, V>> spliterator() {
                        return CollectSpliterators.indexed(this.size(), 1297, n -> this.get(n));
                    }

                    @Override
                    ImmutableCollection<Map.Entry<K, V>> delegateCollection() {
                        return this;
                    }

                    @Override
                    @J2ktIncompatible
                    @GwtIncompatible
                    Object writeReplace() {
                        return super.writeReplace();
                    }
                };
            }

            @Override
            ImmutableMap<K, V> map() {
                return ImmutableSortedMap.this;
            }

            @Override
            @J2ktIncompatible
            @GwtIncompatible
            Object writeReplace() {
                return super.writeReplace();
            }
        }
        return this.isEmpty() ? ImmutableSet.of() : new EntrySet();
    }

    @Override
    public ImmutableSortedSet<K> keySet() {
        return this.keySet;
    }

    @Override
    ImmutableSet<K> createKeySet() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    public ImmutableCollection<V> values() {
        return this.valueList;
    }

    @Override
    ImmutableCollection<V> createValues() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    public Comparator<? super K> comparator() {
        return ((ImmutableSortedSet)this.keySet()).comparator();
    }

    @Override
    public K firstKey() {
        return (K)((ImmutableSortedSet)this.keySet()).first();
    }

    @Override
    public K lastKey() {
        return (K)((ImmutableSortedSet)this.keySet()).last();
    }

    private ImmutableSortedMap<K, V> getSubMap(int n, int n2) {
        if (n == 0 && n2 == this.size()) {
            return this;
        }
        if (n == n2) {
            return ImmutableSortedMap.emptyMap(this.comparator());
        }
        return new ImmutableSortedMap<K, V>(this.keySet.getSubSet(n, n2), this.valueList.subList(n, n2));
    }

    @Override
    public ImmutableSortedMap<K, V> headMap(K k) {
        return this.headMap((Object)k, false);
    }

    @Override
    public ImmutableSortedMap<K, V> headMap(K k, boolean bl) {
        return this.getSubMap(0, this.keySet.headIndex(Preconditions.checkNotNull(k), bl));
    }

    @Override
    public ImmutableSortedMap<K, V> subMap(K k, K k2) {
        return this.subMap((Object)k, true, (Object)k2, false);
    }

    @Override
    public ImmutableSortedMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
        Preconditions.checkNotNull(k);
        Preconditions.checkNotNull(k2);
        Preconditions.checkArgument(this.comparator().compare(k, k2) <= 0, "expected fromKey <= toKey but %s > %s", k, k2);
        return ((ImmutableSortedMap)this.headMap((Object)k2, bl2)).tailMap((Object)k, bl);
    }

    @Override
    public ImmutableSortedMap<K, V> tailMap(K k) {
        return this.tailMap((Object)k, true);
    }

    @Override
    public ImmutableSortedMap<K, V> tailMap(K k, boolean bl) {
        return this.getSubMap(this.keySet.tailIndex(Preconditions.checkNotNull(k), bl), this.size());
    }

    @Override
    @CheckForNull
    public Map.Entry<K, V> lowerEntry(K k) {
        return ((ImmutableSortedMap)this.headMap((Object)k, false)).lastEntry();
    }

    @Override
    @CheckForNull
    public K lowerKey(K k) {
        return Maps.keyOrNull(this.lowerEntry(k));
    }

    @Override
    @CheckForNull
    public Map.Entry<K, V> floorEntry(K k) {
        return ((ImmutableSortedMap)this.headMap((Object)k, true)).lastEntry();
    }

    @Override
    @CheckForNull
    public K floorKey(K k) {
        return Maps.keyOrNull(this.floorEntry(k));
    }

    @Override
    @CheckForNull
    public Map.Entry<K, V> ceilingEntry(K k) {
        return ((ImmutableSortedMap)this.tailMap((Object)k, true)).firstEntry();
    }

    @Override
    @CheckForNull
    public K ceilingKey(K k) {
        return Maps.keyOrNull(this.ceilingEntry(k));
    }

    @Override
    @CheckForNull
    public Map.Entry<K, V> higherEntry(K k) {
        return ((ImmutableSortedMap)this.tailMap((Object)k, false)).firstEntry();
    }

    @Override
    @CheckForNull
    public K higherKey(K k) {
        return Maps.keyOrNull(this.higherEntry(k));
    }

    @Override
    @CheckForNull
    public Map.Entry<K, V> firstEntry() {
        return this.isEmpty() ? null : (Map.Entry)((ImmutableCollection)((Object)this.entrySet())).asList().get(0);
    }

    @Override
    @CheckForNull
    public Map.Entry<K, V> lastEntry() {
        return this.isEmpty() ? null : (Map.Entry)((ImmutableCollection)((Object)this.entrySet())).asList().get(this.size() - 1);
    }

    @Override
    @Deprecated
    @CheckForNull
    @CanIgnoreReturnValue
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final Map.Entry<K, V> pollFirstEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CheckForNull
    @CanIgnoreReturnValue
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final Map.Entry<K, V> pollLastEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableSortedMap<K, V> descendingMap() {
        ImmutableSortedMap<K, V> immutableSortedMap = this.descendingMap;
        if (immutableSortedMap == null) {
            if (this.isEmpty()) {
                return ImmutableSortedMap.emptyMap(Ordering.from(this.comparator()).reverse());
            }
            return new ImmutableSortedMap<K, V>((RegularImmutableSortedSet)this.keySet.descendingSet(), this.valueList.reverse(), this);
        }
        return immutableSortedMap;
    }

    @Override
    public ImmutableSortedSet<K> navigableKeySet() {
        return this.keySet;
    }

    @Override
    public ImmutableSortedSet<K> descendingKeySet() {
        return this.keySet.descendingSet();
    }

    @Override
    @J2ktIncompatible
    Object writeReplace() {
        return new SerializedForm(this);
    }

    @J2ktIncompatible
    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Use SerializedForm");
    }

    @Deprecated
    @DoNotCall(value="Use toImmutableSortedMap")
    public static <T, K, V> Collector<T, ?, ImmutableMap<K, V>> toImmutableMap(Function<? super T, ? extends K> function, Function<? super T, ? extends V> function2) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="Use toImmutableSortedMap")
    public static <T, K, V> Collector<T, ?, ImmutableMap<K, V>> toImmutableMap(Function<? super T, ? extends K> function, Function<? super T, ? extends V> function2, BinaryOperator<V> binaryOperator) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="Use naturalOrder")
    public static <K, V> Builder<K, V> builder() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="Use naturalOrder (which does not accept an expected size)")
    public static <K, V> Builder<K, V> builderWithExpectedSize(int n) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="Pass a key of type Comparable")
    public static <K, V> ImmutableSortedMap<K, V> of(K k, V v) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="Pass keys of type Comparable")
    public static <K, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="Pass keys of type Comparable")
    public static <K, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="Pass keys of type Comparable")
    public static <K, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="Pass keys of type Comparable")
    public static <K, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="Pass keys of type Comparable")
    public static <K, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="Pass keys of type Comparable")
    public static <K, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="Pass keys of type Comparable")
    public static <K, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="Pass keys of type Comparable")
    public static <K, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @DoNotCall(value="Pass keys of type Comparable")
    public static <K, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @SafeVarargs
    @DoNotCall(value="ImmutableSortedMap.ofEntries not currently available; use ImmutableSortedMap.copyOf")
    public static <K, V> ImmutableSortedMap<K, V> ofEntries(Map.Entry<? extends K, ? extends V> ... entryArray) {
        throw new UnsupportedOperationException();
    }

    @J2ktIncompatible
    private static class SerializedForm<K, V>
    extends ImmutableMap.SerializedForm<K, V> {
        private final Comparator<? super K> comparator;
        private static final long serialVersionUID = 0L;

        SerializedForm(ImmutableSortedMap<K, V> immutableSortedMap) {
            super(immutableSortedMap);
            this.comparator = immutableSortedMap.comparator();
        }

        @Override
        Builder<K, V> makeBuilder(int n) {
            return new Builder(this.comparator);
        }
    }

    public static class Builder<K, V>
    extends ImmutableMap.Builder<K, V> {
        private final Comparator<? super K> comparator;

        public Builder(Comparator<? super K> comparator) {
            this.comparator = Preconditions.checkNotNull(comparator);
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> put(K k, V v) {
            super.put(k, v);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> put(Map.Entry<? extends K, ? extends V> entry) {
            super.put(entry);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> putAll(Map<? extends K, ? extends V> map) {
            super.putAll(map);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> putAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable) {
            super.putAll(iterable);
            return this;
        }

        @Override
        @Deprecated
        @CanIgnoreReturnValue
        @DoNotCall(value="Always throws UnsupportedOperationException")
        public final Builder<K, V> orderEntriesByValue(Comparator<? super V> comparator) {
            throw new UnsupportedOperationException("Not available on ImmutableSortedMap.Builder");
        }

        @Override
        Builder<K, V> combine(ImmutableMap.Builder<K, V> builder) {
            super.combine(builder);
            return this;
        }

        @Override
        public ImmutableSortedMap<K, V> build() {
            return this.buildOrThrow();
        }

        @Override
        public ImmutableSortedMap<K, V> buildOrThrow() {
            switch (this.size) {
                case 0: {
                    return ImmutableSortedMap.emptyMap(this.comparator);
                }
                case 1: {
                    Map.Entry entry = Objects.requireNonNull(this.entries[0]);
                    return ImmutableSortedMap.of(this.comparator, entry.getKey(), entry.getValue());
                }
            }
            return ImmutableSortedMap.fromEntries(this.comparator, false, this.entries, this.size);
        }

        @Override
        @Deprecated
        @DoNotCall
        public final ImmutableSortedMap<K, V> buildKeepingLast() {
            throw new UnsupportedOperationException("ImmutableSortedMap.Builder does not yet implement buildKeepingLast()");
        }
    }
}

