/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.DescendingImmutableSortedSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.EmptyContiguousSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.RegularContiguousSet;
import com.google.errorprone.annotations.DoNotCall;
import java.util.NoSuchElementException;
import java.util.Objects;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public abstract class ContiguousSet<C extends Comparable>
extends ImmutableSortedSet<C> {
    final DiscreteDomain<C> domain;

    public static <C extends Comparable> ContiguousSet<C> create(Range<C> range, DiscreteDomain<C> discreteDomain) {
        Comparable comparable;
        Comparable comparable2;
        Preconditions.checkNotNull(range);
        Preconditions.checkNotNull(discreteDomain);
        Range<C> range2 = range;
        try {
            if (!range.hasLowerBound()) {
                range2 = range2.intersection(Range.atLeast(discreteDomain.minValue()));
            }
            if (!range.hasUpperBound()) {
                range2 = range2.intersection(Range.atMost(discreteDomain.maxValue()));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException(noSuchElementException);
        }
        boolean bl = range2.isEmpty() ? true : Range.compareOrThrow(comparable2 = (Comparable)Objects.requireNonNull(range.lowerBound.leastValueAbove(discreteDomain)), comparable = (Comparable)Objects.requireNonNull(range.upperBound.greatestValueBelow(discreteDomain))) > 0;
        return bl ? new EmptyContiguousSet<C>(discreteDomain) : new RegularContiguousSet<C>(range2, discreteDomain);
    }

    public static ContiguousSet<Integer> closed(int n, int n2) {
        return ContiguousSet.create(Range.closed(n, n2), DiscreteDomain.integers());
    }

    public static ContiguousSet<Long> closed(long l, long l2) {
        return ContiguousSet.create(Range.closed(l, l2), DiscreteDomain.longs());
    }

    public static ContiguousSet<Integer> closedOpen(int n, int n2) {
        return ContiguousSet.create(Range.closedOpen(n, n2), DiscreteDomain.integers());
    }

    public static ContiguousSet<Long> closedOpen(long l, long l2) {
        return ContiguousSet.create(Range.closedOpen(l, l2), DiscreteDomain.longs());
    }

    ContiguousSet(DiscreteDomain<C> discreteDomain) {
        super(Ordering.natural());
        this.domain = discreteDomain;
    }

    @Override
    public ContiguousSet<C> headSet(C c) {
        return this.headSetImpl((C)((Comparable)Preconditions.checkNotNull(c)), false);
    }

    @Override
    @GwtIncompatible
    public ContiguousSet<C> headSet(C c, boolean bl) {
        return this.headSetImpl((C)((Comparable)Preconditions.checkNotNull(c)), bl);
    }

    @Override
    public ContiguousSet<C> subSet(C c, C c2) {
        Preconditions.checkNotNull(c);
        Preconditions.checkNotNull(c2);
        Preconditions.checkArgument(this.comparator().compare(c, c2) <= 0);
        return this.subSetImpl(c, true, c2, false);
    }

    @Override
    @GwtIncompatible
    public ContiguousSet<C> subSet(C c, boolean bl, C c2, boolean bl2) {
        Preconditions.checkNotNull(c);
        Preconditions.checkNotNull(c2);
        Preconditions.checkArgument(this.comparator().compare(c, c2) <= 0);
        return this.subSetImpl(c, bl, c2, bl2);
    }

    @Override
    public ContiguousSet<C> tailSet(C c) {
        return this.tailSetImpl((C)((Comparable)Preconditions.checkNotNull(c)), true);
    }

    @Override
    @GwtIncompatible
    public ContiguousSet<C> tailSet(C c, boolean bl) {
        return this.tailSetImpl((C)((Comparable)Preconditions.checkNotNull(c)), bl);
    }

    @Override
    abstract ContiguousSet<C> headSetImpl(C var1, boolean var2);

    @Override
    abstract ContiguousSet<C> subSetImpl(C var1, boolean var2, C var3, boolean var4);

    @Override
    abstract ContiguousSet<C> tailSetImpl(C var1, boolean var2);

    public abstract ContiguousSet<C> intersection(ContiguousSet<C> var1);

    public abstract Range<C> range();

    public abstract Range<C> range(BoundType var1, BoundType var2);

    @Override
    @GwtIncompatible
    ImmutableSortedSet<C> createDescendingSet() {
        return new DescendingImmutableSortedSet(this);
    }

    @Override
    public String toString() {
        return this.range().toString();
    }

    @Deprecated
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public static <E> ImmutableSortedSet.Builder<E> builder() {
        throw new UnsupportedOperationException();
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }
}

