/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.CompactHashSet;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.ParametricNullness;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
class CompactLinkedHashSet<E>
extends CompactHashSet<E> {
    private static final int ENDPOINT = -2;
    @CheckForNull
    private transient int[] predecessor;
    @CheckForNull
    private transient int[] successor;
    private transient int firstEntry;
    private transient int lastEntry;

    public static <E> CompactLinkedHashSet<E> create() {
        return new CompactLinkedHashSet<E>();
    }

    public static <E> CompactLinkedHashSet<E> create(Collection<? extends E> collection) {
        CompactLinkedHashSet<E> compactLinkedHashSet = CompactLinkedHashSet.createWithExpectedSize(collection.size());
        compactLinkedHashSet.addAll(collection);
        return compactLinkedHashSet;
    }

    @SafeVarargs
    public static <E> CompactLinkedHashSet<E> create(E ... EArray) {
        CompactLinkedHashSet<E> compactLinkedHashSet = CompactLinkedHashSet.createWithExpectedSize(EArray.length);
        Collections.addAll(compactLinkedHashSet, EArray);
        return compactLinkedHashSet;
    }

    public static <E> CompactLinkedHashSet<E> createWithExpectedSize(int n) {
        return new CompactLinkedHashSet<E>(n);
    }

    CompactLinkedHashSet() {
    }

    CompactLinkedHashSet(int n) {
        super(n);
    }

    @Override
    void init(int n) {
        super.init(n);
        this.firstEntry = -2;
        this.lastEntry = -2;
    }

    @Override
    int allocArrays() {
        int n = super.allocArrays();
        this.predecessor = new int[n];
        this.successor = new int[n];
        return n;
    }

    @Override
    @CanIgnoreReturnValue
    Set<E> convertToHashFloodingResistantImplementation() {
        Set set = super.convertToHashFloodingResistantImplementation();
        this.predecessor = null;
        this.successor = null;
        return set;
    }

    private int getPredecessor(int n) {
        return this.requirePredecessors()[n] - 1;
    }

    @Override
    int getSuccessor(int n) {
        return this.requireSuccessors()[n] - 1;
    }

    private void setSuccessor(int n, int n2) {
        this.requireSuccessors()[n] = n2 + 1;
    }

    private void setPredecessor(int n, int n2) {
        this.requirePredecessors()[n] = n2 + 1;
    }

    private void setSucceeds(int n, int n2) {
        if (n == -2) {
            this.firstEntry = n2;
        } else {
            this.setSuccessor(n, n2);
        }
        if (n2 == -2) {
            this.lastEntry = n;
        } else {
            this.setPredecessor(n2, n);
        }
    }

    @Override
    void insertEntry(int n, @ParametricNullness E e, int n2, int n3) {
        super.insertEntry(n, e, n2, n3);
        this.setSucceeds(this.lastEntry, n);
        this.setSucceeds(n, -2);
    }

    @Override
    void moveLastEntry(int n, int n2) {
        int n3 = this.size() - 1;
        super.moveLastEntry(n, n2);
        this.setSucceeds(this.getPredecessor(n), this.getSuccessor(n));
        if (n < n3) {
            this.setSucceeds(this.getPredecessor(n3), n);
            this.setSucceeds(n, this.getSuccessor(n3));
        }
        this.requirePredecessors()[n3] = 0;
        this.requireSuccessors()[n3] = 0;
    }

    @Override
    void resizeEntries(int n) {
        super.resizeEntries(n);
        this.predecessor = Arrays.copyOf(this.requirePredecessors(), n);
        this.successor = Arrays.copyOf(this.requireSuccessors(), n);
    }

    @Override
    int firstEntryIndex() {
        return this.firstEntry;
    }

    @Override
    int adjustAfterRemove(int n, int n2) {
        return n >= this.size() ? n2 : n;
    }

    @Override
    public @Nullable Object[] toArray() {
        return ObjectArrays.toArrayImpl(this);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return ObjectArrays.toArrayImpl(this, TArray);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this, 17);
    }

    @Override
    public void clear() {
        if (this.needsAllocArrays()) {
            return;
        }
        this.firstEntry = -2;
        this.lastEntry = -2;
        if (this.predecessor != null && this.successor != null) {
            Arrays.fill(this.predecessor, 0, this.size(), 0);
            Arrays.fill(this.successor, 0, this.size(), 0);
        }
        super.clear();
    }

    private int[] requirePredecessors() {
        return Objects.requireNonNull(this.predecessor);
    }

    private int[] requireSuccessors() {
        return Objects.requireNonNull(this.successor);
    }
}

