/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Strings;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Preconditions {
    private Preconditions() {
    }

    public static void checkArgument(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean bl, @CheckForNull Object object) {
        if (!bl) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
    }

    public static void checkArgument(boolean bl, String string, Object ... objectArray) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, objectArray));
        }
    }

    public static void checkArgument(boolean bl, String string, char c) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, Character.valueOf(c)));
        }
    }

    public static void checkArgument(boolean bl, String string, int n) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, n));
        }
    }

    public static void checkArgument(boolean bl, String string, long l) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, l));
        }
    }

    public static void checkArgument(boolean bl, String string, @CheckForNull Object object) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, object));
        }
    }

    public static void checkArgument(boolean bl, String string, char c, char c2) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, Character.valueOf(c), Character.valueOf(c2)));
        }
    }

    public static void checkArgument(boolean bl, String string, char c, int n) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, Character.valueOf(c), n));
        }
    }

    public static void checkArgument(boolean bl, String string, char c, long l) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, Character.valueOf(c), l));
        }
    }

    public static void checkArgument(boolean bl, String string, char c, @CheckForNull Object object) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, Character.valueOf(c), object));
        }
    }

    public static void checkArgument(boolean bl, String string, int n, char c) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, n, Character.valueOf(c)));
        }
    }

    public static void checkArgument(boolean bl, String string, int n, int n2) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, n, n2));
        }
    }

    public static void checkArgument(boolean bl, String string, int n, long l) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, n, l));
        }
    }

    public static void checkArgument(boolean bl, String string, int n, @CheckForNull Object object) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, n, object));
        }
    }

    public static void checkArgument(boolean bl, String string, long l, char c) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, l, Character.valueOf(c)));
        }
    }

    public static void checkArgument(boolean bl, String string, long l, int n) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, l, n));
        }
    }

    public static void checkArgument(boolean bl, String string, long l, long l2) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, l, l2));
        }
    }

    public static void checkArgument(boolean bl, String string, long l, @CheckForNull Object object) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, l, object));
        }
    }

    public static void checkArgument(boolean bl, String string, @CheckForNull Object object, char c) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, object, Character.valueOf(c)));
        }
    }

    public static void checkArgument(boolean bl, String string, @CheckForNull Object object, int n) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, object, n));
        }
    }

    public static void checkArgument(boolean bl, String string, @CheckForNull Object object, long l) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, object, l));
        }
    }

    public static void checkArgument(boolean bl, @CheckForNull String string, @CheckForNull Object object, @CheckForNull Object object2) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, object, object2));
        }
    }

    public static void checkArgument(boolean bl, String string, @CheckForNull Object object, @CheckForNull Object object2, @CheckForNull Object object3) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, object, object2, object3));
        }
    }

    public static void checkArgument(boolean bl, String string, @CheckForNull Object object, @CheckForNull Object object2, @CheckForNull Object object3, @CheckForNull Object object4) {
        if (!bl) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, object, object2, object3, object4));
        }
    }

    public static void checkState(boolean bl) {
        if (!bl) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean bl, @CheckForNull Object object) {
        if (!bl) {
            throw new IllegalStateException(String.valueOf(object));
        }
    }

    public static void checkState(boolean bl, @CheckForNull String string, Object ... objectArray) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, objectArray));
        }
    }

    public static void checkState(boolean bl, String string, char c) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, Character.valueOf(c)));
        }
    }

    public static void checkState(boolean bl, String string, int n) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, n));
        }
    }

    public static void checkState(boolean bl, String string, long l) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, l));
        }
    }

    public static void checkState(boolean bl, String string, @CheckForNull Object object) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, object));
        }
    }

    public static void checkState(boolean bl, String string, char c, char c2) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, Character.valueOf(c), Character.valueOf(c2)));
        }
    }

    public static void checkState(boolean bl, String string, char c, int n) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, Character.valueOf(c), n));
        }
    }

    public static void checkState(boolean bl, String string, char c, long l) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, Character.valueOf(c), l));
        }
    }

    public static void checkState(boolean bl, String string, char c, @CheckForNull Object object) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, Character.valueOf(c), object));
        }
    }

    public static void checkState(boolean bl, String string, int n, char c) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, n, Character.valueOf(c)));
        }
    }

    public static void checkState(boolean bl, String string, int n, int n2) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, n, n2));
        }
    }

    public static void checkState(boolean bl, String string, int n, long l) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, n, l));
        }
    }

    public static void checkState(boolean bl, String string, int n, @CheckForNull Object object) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, n, object));
        }
    }

    public static void checkState(boolean bl, String string, long l, char c) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, l, Character.valueOf(c)));
        }
    }

    public static void checkState(boolean bl, String string, long l, int n) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, l, n));
        }
    }

    public static void checkState(boolean bl, String string, long l, long l2) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, l, l2));
        }
    }

    public static void checkState(boolean bl, String string, long l, @CheckForNull Object object) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, l, object));
        }
    }

    public static void checkState(boolean bl, String string, @CheckForNull Object object, char c) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, object, Character.valueOf(c)));
        }
    }

    public static void checkState(boolean bl, String string, @CheckForNull Object object, int n) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, object, n));
        }
    }

    public static void checkState(boolean bl, String string, @CheckForNull Object object, long l) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, object, l));
        }
    }

    public static void checkState(boolean bl, String string, @CheckForNull Object object, @CheckForNull Object object2) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, object, object2));
        }
    }

    public static void checkState(boolean bl, String string, @CheckForNull Object object, @CheckForNull Object object2, @CheckForNull Object object3) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, object, object2, object3));
        }
    }

    public static void checkState(boolean bl, String string, @CheckForNull Object object, @CheckForNull Object object2, @CheckForNull Object object3, @CheckForNull Object object4) {
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, object, object2, object3, object4));
        }
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T t2) {
        if (t2 == null) {
            throw new NullPointerException();
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T t2, @CheckForNull Object object) {
        if (t2 == null) {
            throw new NullPointerException(String.valueOf(object));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T t2, String string, Object ... objectArray) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, objectArray));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T t2, String string, char c) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, Character.valueOf(c)));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T t2, String string, int n) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, n));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T t2, String string, long l) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, l));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T t2, String string, @CheckForNull Object object) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, object));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T t2, String string, char c, char c2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, Character.valueOf(c), Character.valueOf(c2)));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T t2, String string, char c, int n) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, Character.valueOf(c), n));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T t2, String string, char c, long l) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, Character.valueOf(c), l));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T t2, String string, char c, @CheckForNull Object object) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, Character.valueOf(c), object));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T t2, String string, int n, char c) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, n, Character.valueOf(c)));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T t2, String string, int n, int n2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, n, n2));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T t2, String string, int n, long l) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, n, l));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T t2, String string, int n, @CheckForNull Object object) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, n, object));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T t2, String string, long l, char c) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, l, Character.valueOf(c)));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T t2, String string, long l, int n) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, l, n));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T t2, String string, long l, long l2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, l, l2));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T t2, String string, long l, @CheckForNull Object object) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, l, object));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T t2, String string, @CheckForNull Object object, char c) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, object, Character.valueOf(c)));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T t2, String string, @CheckForNull Object object, int n) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, object, n));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T t2, String string, @CheckForNull Object object, long l) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, object, l));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T t2, String string, @CheckForNull Object object, @CheckForNull Object object2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, object, object2));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T t2, String string, @CheckForNull Object object, @CheckForNull Object object2, @CheckForNull Object object3) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, object, object2, object3));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@CheckForNull T t2, String string, @CheckForNull Object object, @CheckForNull Object object2, @CheckForNull Object object3, @CheckForNull Object object4) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, object, object2, object3, object4));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static int checkElementIndex(int n, int n2) {
        return Preconditions.checkElementIndex(n, n2, "index");
    }

    @CanIgnoreReturnValue
    public static int checkElementIndex(int n, int n2, String string) {
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException(Preconditions.badElementIndex(n, n2, string));
        }
        return n;
    }

    private static String badElementIndex(int n, int n2, String string) {
        if (n < 0) {
            return Strings.lenientFormat("%s (%s) must not be negative", string, n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("negative size: " + n2);
        }
        return Strings.lenientFormat("%s (%s) must be less than size (%s)", string, n, n2);
    }

    @CanIgnoreReturnValue
    public static int checkPositionIndex(int n, int n2) {
        return Preconditions.checkPositionIndex(n, n2, "index");
    }

    @CanIgnoreReturnValue
    public static int checkPositionIndex(int n, int n2, String string) {
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndex(n, n2, string));
        }
        return n;
    }

    private static String badPositionIndex(int n, int n2, String string) {
        if (n < 0) {
            return Strings.lenientFormat("%s (%s) must not be negative", string, n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("negative size: " + n2);
        }
        return Strings.lenientFormat("%s (%s) must not be greater than size (%s)", string, n, n2);
    }

    public static void checkPositionIndexes(int n, int n2, int n3) {
        if (n < 0 || n2 < n || n2 > n3) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndexes(n, n2, n3));
        }
    }

    private static String badPositionIndexes(int n, int n2, int n3) {
        if (n < 0 || n > n3) {
            return Preconditions.badPositionIndex(n, n3, "start index");
        }
        if (n2 < 0 || n2 > n3) {
            return Preconditions.badPositionIndex(n2, n3, "end index");
        }
        return Strings.lenientFormat("end index (%s) must not be less than start index (%s)", n2, n);
    }

    private static interface Impossible {
    }
}

