/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.cbor;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.json.DupDetector;

public final class CBORWriteContext
extends JsonStreamContext {
    protected final CBORWriteContext _parent;
    protected DupDetector _dups;
    protected CBORWriteContext _childToRecycle;
    protected String _currentName;
    protected Object _currentValue;
    protected long _currentFieldId;
    protected boolean _gotFieldId;

    protected CBORWriteContext(int n, CBORWriteContext cBORWriteContext, DupDetector dupDetector, Object object) {
        this._type = n;
        this._parent = cBORWriteContext;
        this._dups = dupDetector;
        this._index = -1;
        this._currentValue = object;
    }

    private CBORWriteContext reset(int n, Object object) {
        this._type = n;
        this._index = -1;
        this._gotFieldId = false;
        this._currentValue = object;
        if (this._dups != null) {
            this._dups.reset();
        }
        return this;
    }

    public CBORWriteContext withDupDetector(DupDetector dupDetector) {
        this._dups = dupDetector;
        return this;
    }

    @Override
    public Object getCurrentValue() {
        return this._currentValue;
    }

    @Override
    public void setCurrentValue(Object object) {
        this._currentValue = object;
    }

    public static CBORWriteContext createRootContext(DupDetector dupDetector) {
        return new CBORWriteContext(0, null, dupDetector, null);
    }

    public CBORWriteContext createChildArrayContext(Object object) {
        CBORWriteContext cBORWriteContext = this._childToRecycle;
        if (cBORWriteContext == null) {
            this._childToRecycle = cBORWriteContext = new CBORWriteContext(1, this, this._dups == null ? null : this._dups.child(), object);
            return cBORWriteContext;
        }
        return cBORWriteContext.reset(1, object);
    }

    public CBORWriteContext createChildObjectContext(Object object) {
        CBORWriteContext cBORWriteContext = this._childToRecycle;
        if (cBORWriteContext == null) {
            this._childToRecycle = cBORWriteContext = new CBORWriteContext(2, this, this._dups == null ? null : this._dups.child(), object);
            return cBORWriteContext;
        }
        return cBORWriteContext.reset(2, object);
    }

    @Override
    public final CBORWriteContext getParent() {
        return this._parent;
    }

    @Override
    public final String getCurrentName() {
        if (this._gotFieldId) {
            if (this._currentName != null) {
                return this._currentName;
            }
            return String.valueOf(this._currentFieldId);
        }
        return null;
    }

    @Override
    public boolean hasCurrentName() {
        return this._gotFieldId;
    }

    public CBORWriteContext clearAndGetParent() {
        this._currentValue = null;
        return this._parent;
    }

    public DupDetector getDupDetector() {
        return this._dups;
    }

    public boolean writeFieldName(String string) throws JsonProcessingException {
        if (this._type != 2 || this._gotFieldId) {
            return false;
        }
        this._gotFieldId = true;
        this._currentName = string;
        if (this._dups != null) {
            this._checkDup(this._dups, string);
        }
        return true;
    }

    public boolean writeFieldId(long l) throws JsonProcessingException {
        if (this._type != 2 || this._gotFieldId) {
            return false;
        }
        this._gotFieldId = true;
        this._currentFieldId = l;
        return true;
    }

    private final void _checkDup(DupDetector dupDetector, String string) throws JsonProcessingException {
        if (dupDetector.isDup(string)) {
            Object object = dupDetector.getSource();
            throw new JsonGenerationException("Duplicate field '" + string + "'", object instanceof JsonGenerator ? (JsonGenerator)object : null);
        }
    }

    public boolean writeValue() {
        if (this._type == 2) {
            if (!this._gotFieldId) {
                return false;
            }
            this._gotFieldId = false;
        }
        ++this._index;
        return true;
    }
}

