/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

public abstract class PrimitiveArrayBuilder<T> {
    static final int INITIAL_CHUNK_SIZE = 12;
    static final int SMALL_CHUNK_SIZE = 16384;
    static final int MAX_CHUNK_SIZE = 262144;
    protected T _freeBuffer;
    protected Node<T> _bufferHead;
    protected Node<T> _bufferTail;
    protected int _bufferedEntryCount;

    protected PrimitiveArrayBuilder() {
    }

    public int bufferedSize() {
        return this._bufferedEntryCount;
    }

    public T resetAndStart() {
        this._reset();
        return this._freeBuffer == null ? this._constructArray(12) : this._freeBuffer;
    }

    public final T appendCompletedChunk(T t2, int n) {
        Node<T> node = new Node<T>(t2, n);
        if (this._bufferHead == null) {
            this._bufferTail = node;
            this._bufferHead = this._bufferTail;
        } else {
            this._bufferTail.linkNext(node);
            this._bufferTail = node;
        }
        this._bufferedEntryCount += n;
        int n2 = n;
        n2 = n2 < 16384 ? (n2 += n2) : (n2 += n2 >> 2);
        return this._constructArray(n2);
    }

    public T completeAndClearBuffer(T t2, int n) {
        int n2 = n + this._bufferedEntryCount;
        T t3 = this._constructArray(n2);
        int n3 = 0;
        for (Node<T> node = this._bufferHead; node != null; node = node.next()) {
            n3 = node.copyData(t3, n3);
        }
        System.arraycopy(t2, 0, t3, n3, n);
        if ((n3 += n) != n2) {
            throw new IllegalStateException("Should have gotten " + n2 + " entries, got " + n3);
        }
        return t3;
    }

    protected abstract T _constructArray(int var1);

    protected void _reset() {
        if (this._bufferTail != null) {
            this._freeBuffer = this._bufferTail.getData();
        }
        this._bufferTail = null;
        this._bufferHead = null;
        this._bufferedEntryCount = 0;
    }

    static final class Node<T> {
        final T _data;
        final int _dataLength;
        Node<T> _next;

        public Node(T t2, int n) {
            this._data = t2;
            this._dataLength = n;
        }

        public T getData() {
            return this._data;
        }

        public int copyData(T t2, int n) {
            System.arraycopy(this._data, 0, t2, n, this._dataLength);
            return n += this._dataLength;
        }

        public Node<T> next() {
            return this._next;
        }

        public void linkNext(Node<T> node) {
            if (this._next != null) {
                throw new IllegalStateException();
            }
            this._next = node;
        }
    }
}

