/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.CompactStringObjectMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EnumResolver
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Class<Enum<?>> _enumClass;
    protected final Enum<?>[] _enums;
    protected final HashMap<String, Enum<?>> _enumsById;
    protected final Enum<?> _defaultValue;
    protected final boolean _isIgnoreCase;
    protected final boolean _isFromIntValue;

    protected EnumResolver(Class<Enum<?>> clazz, Enum<?>[] enumArray, HashMap<String, Enum<?>> hashMap, Enum<?> enum_, boolean bl, boolean bl2) {
        this._enumClass = clazz;
        this._enums = enumArray;
        this._enumsById = hashMap;
        this._defaultValue = enum_;
        this._isIgnoreCase = bl;
        this._isFromIntValue = bl2;
    }

    @Deprecated
    protected EnumResolver(Class<Enum<?>> clazz, Enum<?>[] enumArray, HashMap<String, Enum<?>> hashMap, Enum<?> enum_, boolean bl) {
        this(clazz, enumArray, hashMap, enum_, bl, false);
    }

    public static EnumResolver constructFor(DeserializationConfig deserializationConfig, Class<?> clazz) {
        return EnumResolver._constructFor(clazz, deserializationConfig.getAnnotationIntrospector(), deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS));
    }

    protected static EnumResolver _constructFor(Class<?> clazz, AnnotationIntrospector annotationIntrospector, boolean bl) {
        Class<Enum<?>> clazz2 = EnumResolver._enumClass(clazz);
        Enum<?>[] enumArray = EnumResolver._enumConstants(clazz);
        String[] stringArray = annotationIntrospector.findEnumValues(clazz2, enumArray, new String[enumArray.length]);
        String[][] stringArray2 = new String[stringArray.length][];
        annotationIntrospector.findEnumAliases(clazz2, enumArray, stringArray2);
        HashMap hashMap = new HashMap();
        int n = enumArray.length;
        for (int i = 0; i < n; ++i) {
            Enum<?> enum_ = enumArray[i];
            String string = stringArray[i];
            if (string == null) {
                string = enum_.name();
            }
            hashMap.put(string, enum_);
            String[] stringArray3 = stringArray2[i];
            if (stringArray3 == null) continue;
            for (String string2 : stringArray3) {
                if (hashMap.containsKey(string2)) continue;
                hashMap.put(string2, enum_);
            }
        }
        return new EnumResolver(clazz2, enumArray, hashMap, EnumResolver._enumDefault(annotationIntrospector, clazz2), bl, false);
    }

    public static EnumResolver constructUsingToString(DeserializationConfig deserializationConfig, Class<?> clazz) {
        return EnumResolver._constructUsingToString(clazz, deserializationConfig.getAnnotationIntrospector(), deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS));
    }

    protected static EnumResolver _constructUsingToString(Class<?> clazz, AnnotationIntrospector annotationIntrospector, boolean bl) {
        Class<Enum<?>> clazz2 = EnumResolver._enumClass(clazz);
        Enum<?>[] enumArray = EnumResolver._enumConstants(clazz);
        HashMap hashMap = new HashMap();
        String[][] stringArray = new String[enumArray.length][];
        if (annotationIntrospector != null) {
            annotationIntrospector.findEnumAliases(clazz2, enumArray, stringArray);
        }
        int n = enumArray.length;
        while (--n >= 0) {
            Enum<?> enum_ = enumArray[n];
            hashMap.put(enum_.toString(), enum_);
            String[] stringArray2 = stringArray[n];
            if (stringArray2 == null) continue;
            for (String string : stringArray2) {
                if (hashMap.containsKey(string)) continue;
                hashMap.put(string, enum_);
            }
        }
        return new EnumResolver(clazz2, enumArray, hashMap, EnumResolver._enumDefault(annotationIntrospector, clazz2), bl, false);
    }

    public static EnumResolver constructUsingMethod(DeserializationConfig deserializationConfig, Class<?> clazz, AnnotatedMember annotatedMember) {
        return EnumResolver._constructUsingMethod(clazz, annotatedMember, deserializationConfig.getAnnotationIntrospector(), deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS));
    }

    protected static EnumResolver _constructUsingMethod(Class<?> clazz, AnnotatedMember annotatedMember, AnnotationIntrospector annotationIntrospector, boolean bl) {
        Class<Enum<?>> clazz2 = EnumResolver._enumClass(clazz);
        Enum<?>[] enumArray = EnumResolver._enumConstants(clazz);
        HashMap hashMap = new HashMap();
        int n = enumArray.length;
        while (--n >= 0) {
            Enum<?> enum_ = enumArray[n];
            try {
                Object object = annotatedMember.getValue(enum_);
                if (object == null) continue;
                hashMap.put(object.toString(), enum_);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to access @JsonValue of Enum value " + enum_ + ": " + exception.getMessage());
            }
        }
        return new EnumResolver(clazz2, enumArray, hashMap, EnumResolver._enumDefault(annotationIntrospector, clazz2), bl, EnumResolver._isIntType(annotatedMember.getRawType()));
    }

    public CompactStringObjectMap constructLookup() {
        return CompactStringObjectMap.construct(this._enumsById);
    }

    protected static Class<Enum<?>> _enumClass(Class<?> clazz) {
        return clazz;
    }

    protected static Enum<?>[] _enumConstants(Class<?> clazz) {
        Enum<?>[] enumArray = EnumResolver._enumClass(clazz).getEnumConstants();
        if (enumArray == null) {
            throw new IllegalArgumentException("No enum constants for class " + clazz.getName());
        }
        return enumArray;
    }

    protected static Enum<?> _enumDefault(AnnotationIntrospector annotationIntrospector, Class<?> clazz) {
        return annotationIntrospector != null ? annotationIntrospector.findDefaultEnumValue(EnumResolver._enumClass(clazz)) : null;
    }

    protected static boolean _isIntType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            clazz = ClassUtil.wrapperType(clazz);
        }
        return clazz == Long.class || clazz == Integer.class || clazz == Short.class || clazz == Byte.class;
    }

    @Deprecated
    protected EnumResolver(Class<Enum<?>> clazz, Enum<?>[] enumArray, HashMap<String, Enum<?>> hashMap, Enum<?> enum_) {
        this(clazz, enumArray, hashMap, enum_, false, false);
    }

    @Deprecated
    public static EnumResolver constructFor(Class<Enum<?>> clazz, AnnotationIntrospector annotationIntrospector) {
        return EnumResolver._constructFor(clazz, annotationIntrospector, false);
    }

    @Deprecated
    public static EnumResolver constructUnsafe(Class<?> clazz, AnnotationIntrospector annotationIntrospector) {
        return EnumResolver._constructFor(clazz, annotationIntrospector, false);
    }

    @Deprecated
    public static EnumResolver constructUsingToString(Class<Enum<?>> clazz, AnnotationIntrospector annotationIntrospector) {
        return EnumResolver._constructUsingToString(clazz, annotationIntrospector, false);
    }

    @Deprecated
    public static EnumResolver constructUnsafeUsingToString(Class<?> clazz, AnnotationIntrospector annotationIntrospector) {
        return EnumResolver._constructUsingToString(clazz, annotationIntrospector, false);
    }

    @Deprecated
    public static EnumResolver constructUsingToString(Class<Enum<?>> clazz) {
        return EnumResolver._constructUsingToString(clazz, null, false);
    }

    @Deprecated
    public static EnumResolver constructUsingMethod(Class<Enum<?>> clazz, AnnotatedMember annotatedMember, AnnotationIntrospector annotationIntrospector) {
        return EnumResolver._constructUsingMethod(clazz, annotatedMember, annotationIntrospector, false);
    }

    @Deprecated
    public static EnumResolver constructUnsafeUsingMethod(Class<?> clazz, AnnotatedMember annotatedMember, AnnotationIntrospector annotationIntrospector) {
        return EnumResolver._constructUsingMethod(clazz, annotatedMember, annotationIntrospector, false);
    }

    public Enum<?> findEnum(String string) {
        Enum<?> enum_ = this._enumsById.get(string);
        if (enum_ == null && this._isIgnoreCase) {
            return this._findEnumCaseInsensitive(string);
        }
        return enum_;
    }

    protected Enum<?> _findEnumCaseInsensitive(String string) {
        for (Map.Entry<String, Enum<?>> entry : this._enumsById.entrySet()) {
            if (!string.equalsIgnoreCase(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public Enum<?> getEnum(int n) {
        if (n < 0 || n >= this._enums.length) {
            return null;
        }
        return this._enums[n];
    }

    public Enum<?> getDefaultValue() {
        return this._defaultValue;
    }

    public Enum<?>[] getRawEnums() {
        return this._enums;
    }

    public List<Enum<?>> getEnums() {
        ArrayList arrayList = new ArrayList(this._enums.length);
        for (Enum<?> enum_ : this._enums) {
            arrayList.add(enum_);
        }
        return arrayList;
    }

    public Collection<String> getEnumIds() {
        return this._enumsById.keySet();
    }

    public Class<Enum<?>> getEnumClass() {
        return this._enumClass;
    }

    public int lastValidIndex() {
        return this._enums.length - 1;
    }

    public boolean isFromIntValue() {
        return this._isFromIntValue;
    }
}

