/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.std.AsArraySerializerBase;
import java.io.IOException;
import java.util.Iterator;

@JacksonStdImpl
public class IteratorSerializer
extends AsArraySerializerBase<Iterator<?>> {
    public IteratorSerializer(JavaType javaType, boolean bl, TypeSerializer typeSerializer) {
        super(Iterator.class, javaType, bl, typeSerializer, null);
    }

    public IteratorSerializer(IteratorSerializer iteratorSerializer, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, Boolean bl) {
        super(iteratorSerializer, beanProperty, typeSerializer, jsonSerializer, bl);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, Iterator<?> iterator2) {
        return !iterator2.hasNext();
    }

    @Override
    public boolean hasSingleElement(Iterator<?> iterator2) {
        return false;
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
        return new IteratorSerializer(this, this._property, typeSerializer, this._elementSerializer, this._unwrapSingle);
    }

    public IteratorSerializer withResolved(BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, Boolean bl) {
        return new IteratorSerializer(this, beanProperty, typeSerializer, jsonSerializer, bl);
    }

    @Override
    public final void serialize(Iterator<?> iterator2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartArray(iterator2);
        this.serializeContents(iterator2, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndArray();
    }

    @Override
    public void serializeContents(Iterator<?> iterator2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (!iterator2.hasNext()) {
            return;
        }
        JsonSerializer jsonSerializer = this._elementSerializer;
        if (jsonSerializer == null) {
            this._serializeDynamicContents(iterator2, jsonGenerator, serializerProvider);
            return;
        }
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        do {
            Object obj;
            if ((obj = iterator2.next()) == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            if (typeSerializer == null) {
                jsonSerializer.serialize(obj, jsonGenerator, serializerProvider);
                continue;
            }
            jsonSerializer.serializeWithType(obj, jsonGenerator, serializerProvider, typeSerializer);
        } while (iterator2.hasNext());
    }

    protected void _serializeDynamicContents(Iterator<?> iterator2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        PropertySerializerMap propertySerializerMap = this._dynamicSerializers;
        do {
            Object obj;
            if ((obj = iterator2.next()) == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            Class<?> clazz = obj.getClass();
            JsonSerializer<Object> jsonSerializer = propertySerializerMap.serializerFor(clazz);
            if (jsonSerializer == null) {
                jsonSerializer = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(propertySerializerMap, serializerProvider.constructSpecializedType(this._elementType, clazz), serializerProvider) : this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
                propertySerializerMap = this._dynamicSerializers;
            }
            if (typeSerializer == null) {
                jsonSerializer.serialize(obj, jsonGenerator, serializerProvider);
                continue;
            }
            jsonSerializer.serializeWithType(obj, jsonGenerator, serializerProvider, typeSerializer);
        } while (iterator2.hasNext());
    }
}

