/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;

@JacksonStdImpl
public final class StringCollectionDeserializer
extends ContainerDeserializerBase<Collection<String>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JsonDeserializer<String> _valueDeserializer;
    protected final ValueInstantiator _valueInstantiator;
    protected final JsonDeserializer<Object> _delegateDeserializer;

    public StringCollectionDeserializer(JavaType javaType, JsonDeserializer<?> jsonDeserializer, ValueInstantiator valueInstantiator) {
        this(javaType, valueInstantiator, null, jsonDeserializer, jsonDeserializer, null);
    }

    protected StringCollectionDeserializer(JavaType javaType, ValueInstantiator valueInstantiator, JsonDeserializer<?> jsonDeserializer, JsonDeserializer<?> jsonDeserializer2, NullValueProvider nullValueProvider, Boolean bl) {
        super(javaType, nullValueProvider, bl);
        this._valueDeserializer = jsonDeserializer2;
        this._valueInstantiator = valueInstantiator;
        this._delegateDeserializer = jsonDeserializer;
    }

    protected StringCollectionDeserializer withResolved(JsonDeserializer<?> jsonDeserializer, JsonDeserializer<?> jsonDeserializer2, NullValueProvider nullValueProvider, Boolean bl) {
        if (Objects.equals(this._unwrapSingle, bl) && this._nullProvider == nullValueProvider && this._valueDeserializer == jsonDeserializer2 && this._delegateDeserializer == jsonDeserializer) {
            return this;
        }
        return new StringCollectionDeserializer(this._containerType, this._valueInstantiator, jsonDeserializer, jsonDeserializer2, nullValueProvider, bl);
    }

    @Override
    public boolean isCachable() {
        return this._valueDeserializer == null && this._delegateDeserializer == null;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Collection;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        JavaType javaType;
        Object object;
        JsonDeserializer<Object> jsonDeserializer = null;
        if (this._valueInstantiator != null) {
            object = this._valueInstantiator.getArrayDelegateCreator();
            if (object != null) {
                javaType = this._valueInstantiator.getArrayDelegateType(deserializationContext.getConfig());
                jsonDeserializer = this.findDeserializer(deserializationContext, javaType, beanProperty);
            } else {
                object = this._valueInstantiator.getDelegateCreator();
                if (object != null) {
                    javaType = this._valueInstantiator.getDelegateType(deserializationContext.getConfig());
                    jsonDeserializer = this.findDeserializer(deserializationContext, javaType, beanProperty);
                }
            }
        }
        object = this._valueDeserializer;
        javaType = this._containerType.getContentType();
        if (object == null) {
            if ((object = this.findConvertingContentDeserializer(deserializationContext, beanProperty, (JsonDeserializer<?>)object)) == null) {
                object = deserializationContext.findContextualValueDeserializer(javaType, beanProperty);
            }
        } else {
            object = deserializationContext.handleSecondaryContextualization((JsonDeserializer<?>)object, beanProperty, javaType);
        }
        Boolean bl = this.findFormatFeature(deserializationContext, beanProperty, Collection.class, JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        NullValueProvider nullValueProvider = this.findContentNullProvider(deserializationContext, beanProperty, (JsonDeserializer<?>)object);
        if (this.isDefaultDeserializer((JsonDeserializer<?>)object)) {
            object = null;
        }
        return this.withResolved(jsonDeserializer, (JsonDeserializer<?>)object, nullValueProvider, bl);
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        return jsonDeserializer;
    }

    @Override
    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    @Override
    public Collection<String> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (this._delegateDeserializer != null) {
            return (Collection)this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        Collection collection = (Collection)this._valueInstantiator.createUsingDefault(deserializationContext);
        return this.deserialize(jsonParser, deserializationContext, collection);
    }

    @Override
    public Collection<String> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<String> collection) throws IOException {
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext, collection);
        }
        if (this._valueDeserializer != null) {
            return this.deserializeUsingCustom(jsonParser, deserializationContext, collection, this._valueDeserializer);
        }
        try {
            while (true) {
                String string;
                if ((string = jsonParser.nextTextValue()) != null) {
                    collection.add(string);
                    continue;
                }
                JsonToken jsonToken = jsonParser.currentToken();
                if (jsonToken != JsonToken.END_ARRAY) {
                    if (jsonToken == JsonToken.VALUE_NULL) {
                        if (this._skipNullValues) continue;
                        string = (String)this._nullProvider.getNullValue(deserializationContext);
                    } else {
                        string = this._parseString(jsonParser, deserializationContext);
                    }
                    collection.add(string);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            throw JsonMappingException.wrapWithPath((Throwable)exception, collection, collection.size());
        }
        return collection;
    }

    private Collection<String> deserializeUsingCustom(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<String> collection, JsonDeserializer<String> jsonDeserializer) throws IOException {
        try {
            while (true) {
                String string;
                if (jsonParser.nextTextValue() == null) {
                    JsonToken jsonToken = jsonParser.currentToken();
                    if (jsonToken == JsonToken.END_ARRAY) break;
                    if (jsonToken == JsonToken.VALUE_NULL) {
                        if (this._skipNullValues) continue;
                        string = (String)this._nullProvider.getNullValue(deserializationContext);
                    } else {
                        string = jsonDeserializer.deserialize(jsonParser, deserializationContext);
                    }
                } else {
                    string = jsonDeserializer.deserialize(jsonParser, deserializationContext);
                }
                collection.add(string);
            }
        }
        catch (Exception exception) {
            throw JsonMappingException.wrapWithPath((Throwable)exception, collection, collection.size());
        }
        return collection;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    private final Collection<String> handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<String> collection) throws IOException {
        String string;
        boolean bl;
        boolean bl2 = bl = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (!bl) {
            if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
                return (Collection)this._deserializeFromString(jsonParser, deserializationContext);
            }
            return (Collection)deserializationContext.handleUnexpectedToken(this._containerType, jsonParser);
        }
        JsonDeserializer<String> jsonDeserializer = this._valueDeserializer;
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken == JsonToken.VALUE_NULL) {
            if (this._skipNullValues) {
                return collection;
            }
            string = (String)this._nullProvider.getNullValue(deserializationContext);
        } else {
            try {
                string = jsonDeserializer == null ? this._parseString(jsonParser, deserializationContext) : jsonDeserializer.deserialize(jsonParser, deserializationContext);
            }
            catch (Exception exception) {
                throw JsonMappingException.wrapWithPath((Throwable)exception, collection, collection.size());
            }
        }
        collection.add(string);
        return collection;
    }
}

