/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.AbstractTypeResolver;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.ConfigOverride;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.cfg.DeserializerFactoryConfig;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.AbstractDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.deser.KeyDeserializers;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.ValueInstantiators;
import com.fasterxml.jackson.databind.deser.impl.CreatorCandidate;
import com.fasterxml.jackson.databind.deser.impl.CreatorCollector;
import com.fasterxml.jackson.databind.deser.impl.JDKValueInstantiators;
import com.fasterxml.jackson.databind.deser.impl.JavaUtilCollectionsDeserializers;
import com.fasterxml.jackson.databind.deser.std.ArrayBlockingQueueDeserializer;
import com.fasterxml.jackson.databind.deser.std.AtomicReferenceDeserializer;
import com.fasterxml.jackson.databind.deser.std.CollectionDeserializer;
import com.fasterxml.jackson.databind.deser.std.DateDeserializers;
import com.fasterxml.jackson.databind.deser.std.EnumDeserializer;
import com.fasterxml.jackson.databind.deser.std.EnumMapDeserializer;
import com.fasterxml.jackson.databind.deser.std.EnumSetDeserializer;
import com.fasterxml.jackson.databind.deser.std.JdkDeserializers;
import com.fasterxml.jackson.databind.deser.std.JsonNodeDeserializer;
import com.fasterxml.jackson.databind.deser.std.MapDeserializer;
import com.fasterxml.jackson.databind.deser.std.MapEntryDeserializer;
import com.fasterxml.jackson.databind.deser.std.NumberDeserializers;
import com.fasterxml.jackson.databind.deser.std.ObjectArrayDeserializer;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializers;
import com.fasterxml.jackson.databind.deser.std.StringArrayDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringCollectionDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.fasterxml.jackson.databind.deser.std.TokenBufferDeserializer;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.fasterxml.jackson.databind.ext.OptionalHandlerFactory;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jdk14.JDK14Util;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.ReferenceType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.EnumResolver;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicReference;

public abstract class BasicDeserializerFactory
extends DeserializerFactory
implements Serializable {
    private static final Class<?> CLASS_OBJECT = Object.class;
    private static final Class<?> CLASS_STRING = String.class;
    private static final Class<?> CLASS_CHAR_SEQUENCE = CharSequence.class;
    private static final Class<?> CLASS_ITERABLE = Iterable.class;
    private static final Class<?> CLASS_MAP_ENTRY = Map.Entry.class;
    private static final Class<?> CLASS_SERIALIZABLE = Serializable.class;
    protected static final PropertyName UNWRAPPED_CREATOR_PARAM_NAME = new PropertyName("@JsonUnwrapped");
    protected final DeserializerFactoryConfig _factoryConfig;

    protected BasicDeserializerFactory(DeserializerFactoryConfig deserializerFactoryConfig) {
        this._factoryConfig = deserializerFactoryConfig;
    }

    public DeserializerFactoryConfig getFactoryConfig() {
        return this._factoryConfig;
    }

    protected abstract DeserializerFactory withConfig(DeserializerFactoryConfig var1);

    @Override
    public final DeserializerFactory withAdditionalDeserializers(Deserializers deserializers) {
        return this.withConfig(this._factoryConfig.withAdditionalDeserializers(deserializers));
    }

    @Override
    public final DeserializerFactory withAdditionalKeyDeserializers(KeyDeserializers keyDeserializers) {
        return this.withConfig(this._factoryConfig.withAdditionalKeyDeserializers(keyDeserializers));
    }

    @Override
    public final DeserializerFactory withDeserializerModifier(BeanDeserializerModifier beanDeserializerModifier) {
        return this.withConfig(this._factoryConfig.withDeserializerModifier(beanDeserializerModifier));
    }

    @Override
    public final DeserializerFactory withAbstractTypeResolver(AbstractTypeResolver abstractTypeResolver) {
        return this.withConfig(this._factoryConfig.withAbstractTypeResolver(abstractTypeResolver));
    }

    @Override
    public final DeserializerFactory withValueInstantiators(ValueInstantiators valueInstantiators) {
        return this.withConfig(this._factoryConfig.withValueInstantiators(valueInstantiators));
    }

    @Override
    public JavaType mapAbstractType(DeserializationConfig deserializationConfig, JavaType javaType) throws JsonMappingException {
        JavaType javaType2;
        while ((javaType2 = this._mapAbstractType2(deserializationConfig, javaType)) != null) {
            Class<?> clazz;
            Class<?> clazz2 = javaType.getRawClass();
            if (clazz2 == (clazz = javaType2.getRawClass()) || !clazz2.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Invalid abstract type resolution from " + javaType + " to " + javaType2 + ": latter is not a subtype of former");
            }
            javaType = javaType2;
        }
        return javaType;
    }

    private JavaType _mapAbstractType2(DeserializationConfig deserializationConfig, JavaType javaType) throws JsonMappingException {
        Class<?> clazz = javaType.getRawClass();
        if (this._factoryConfig.hasAbstractTypeResolvers()) {
            for (AbstractTypeResolver abstractTypeResolver : this._factoryConfig.abstractTypeResolvers()) {
                JavaType javaType2 = abstractTypeResolver.findTypeMapping(deserializationConfig, javaType);
                if (javaType2 == null || javaType2.hasRawClass(clazz)) continue;
                return javaType2;
            }
        }
        return null;
    }

    @Override
    public ValueInstantiator findValueInstantiator(DeserializationContext deserializationContext, BeanDescription beanDescription) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        ValueInstantiator valueInstantiator = null;
        AnnotatedClass annotatedClass = beanDescription.getClassInfo();
        Object object = deserializationContext.getAnnotationIntrospector().findValueInstantiator(annotatedClass);
        if (object != null) {
            valueInstantiator = this._valueInstantiatorInstance(deserializationConfig, annotatedClass, object);
        }
        if (valueInstantiator == null && (valueInstantiator = JDKValueInstantiators.findStdValueInstantiator(deserializationConfig, beanDescription.getBeanClass())) == null) {
            valueInstantiator = this._constructDefaultValueInstantiator(deserializationContext, beanDescription);
        }
        if (this._factoryConfig.hasValueInstantiators()) {
            for (ValueInstantiators valueInstantiators : this._factoryConfig.valueInstantiators()) {
                valueInstantiator = valueInstantiators.findValueInstantiator(deserializationConfig, beanDescription, valueInstantiator);
                if (valueInstantiator != null) continue;
                deserializationContext.reportBadTypeDefinition(beanDescription, "Broken registered ValueInstantiators (of type %s): returned null ValueInstantiator", valueInstantiators.getClass().getName());
            }
        }
        if (valueInstantiator != null) {
            valueInstantiator = valueInstantiator.createContextual(deserializationContext, beanDescription);
        }
        return valueInstantiator;
    }

    protected ValueInstantiator _constructDefaultValueInstantiator(DeserializationContext deserializationContext, BeanDescription beanDescription) throws JsonMappingException {
        Serializable serializable = deserializationContext.getConfig();
        Object object = serializable.getDefaultVisibilityChecker(beanDescription.getBeanClass(), beanDescription.getClassInfo());
        ConstructorDetector constructorDetector = serializable.getConstructorDetector();
        CreatorCollector creatorCollector = new CreatorCollector(beanDescription, (MapperConfig<?>)serializable);
        Map<AnnotatedWithParams, BeanPropertyDefinition[]> map = this._findCreatorsFromProperties(deserializationContext, beanDescription);
        CreatorCollectionState creatorCollectionState = new CreatorCollectionState(deserializationContext, beanDescription, (VisibilityChecker<?>)object, creatorCollector, map);
        this._addExplicitFactoryCreators(deserializationContext, creatorCollectionState, !constructorDetector.requireCtorAnnotation());
        if (beanDescription.getType().isConcrete()) {
            if (beanDescription.getType().isRecordType() && (object = JDK14Util.findRecordConstructor(deserializationContext, beanDescription, (List<String>)((Object)(serializable = new ArrayList())))) != null) {
                this._addRecordConstructor(deserializationContext, creatorCollectionState, (AnnotatedConstructor)object, (List<String>)((Object)serializable));
                return creatorCollectionState.creators.constructValueInstantiator(deserializationContext);
            }
            boolean bl = beanDescription.isNonStaticInnerClass();
            if (!bl) {
                boolean bl2 = constructorDetector.shouldIntrospectorImplicitConstructors(beanDescription.getBeanClass());
                this._addExplicitConstructorCreators(deserializationContext, creatorCollectionState, bl2);
                if (creatorCollectionState.hasImplicitConstructorCandidates() && !creatorCollectionState.hasExplicitConstructors()) {
                    this._addImplicitConstructorCreators(deserializationContext, creatorCollectionState, creatorCollectionState.implicitConstructorCandidates());
                }
            }
        }
        if (creatorCollectionState.hasImplicitFactoryCandidates() && !creatorCollectionState.hasExplicitFactories() && !creatorCollectionState.hasExplicitConstructors()) {
            this._addImplicitFactoryCreators(deserializationContext, creatorCollectionState, creatorCollectionState.implicitFactoryCandidates());
        }
        return creatorCollectionState.creators.constructValueInstantiator(deserializationContext);
    }

    protected Map<AnnotatedWithParams, BeanPropertyDefinition[]> _findCreatorsFromProperties(DeserializationContext deserializationContext, BeanDescription beanDescription) throws JsonMappingException {
        Map<AnnotatedWithParams, BeanPropertyDefinition[]> map = Collections.emptyMap();
        for (BeanPropertyDefinition beanPropertyDefinition : beanDescription.findProperties()) {
            Iterator<AnnotatedParameter> iterator2 = beanPropertyDefinition.getConstructorParameters();
            while (iterator2.hasNext()) {
                AnnotatedParameter annotatedParameter = iterator2.next();
                AnnotatedWithParams annotatedWithParams = annotatedParameter.getOwner();
                BeanPropertyDefinition[] beanPropertyDefinitionArray = map.get(annotatedWithParams);
                int n = annotatedParameter.getIndex();
                if (beanPropertyDefinitionArray == null) {
                    if (map.isEmpty()) {
                        map = new LinkedHashMap<AnnotatedWithParams, BeanPropertyDefinition[]>();
                    }
                    beanPropertyDefinitionArray = new BeanPropertyDefinition[annotatedWithParams.getParameterCount()];
                    map.put(annotatedWithParams, beanPropertyDefinitionArray);
                } else if (beanPropertyDefinitionArray[n] != null) {
                    deserializationContext.reportBadTypeDefinition(beanDescription, "Conflict: parameter #%d of %s bound to more than one property; %s vs %s", n, annotatedWithParams, beanPropertyDefinitionArray[n], beanPropertyDefinition);
                }
                beanPropertyDefinitionArray[n] = beanPropertyDefinition;
            }
        }
        return map;
    }

    public ValueInstantiator _valueInstantiatorInstance(DeserializationConfig deserializationConfig, Annotated annotated, Object object) throws JsonMappingException {
        ValueInstantiator valueInstantiator;
        if (object == null) {
            return null;
        }
        if (object instanceof ValueInstantiator) {
            return (ValueInstantiator)object;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned key deserializer definition of type " + object.getClass().getName() + "; expected type KeyDeserializer or Class<KeyDeserializer> instead");
        }
        Class clazz = (Class)object;
        if (ClassUtil.isBogusClass(clazz)) {
            return null;
        }
        if (!ValueInstantiator.class.isAssignableFrom(clazz)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<ValueInstantiator>");
        }
        HandlerInstantiator handlerInstantiator = deserializationConfig.getHandlerInstantiator();
        if (handlerInstantiator != null && (valueInstantiator = handlerInstantiator.valueInstantiatorInstance(deserializationConfig, annotated, clazz)) != null) {
            return valueInstantiator;
        }
        return (ValueInstantiator)ClassUtil.createInstance(clazz, deserializationConfig.canOverrideAccessModifiers());
    }

    protected void _addRecordConstructor(DeserializationContext deserializationContext, CreatorCollectionState creatorCollectionState, AnnotatedConstructor annotatedConstructor, List<String> list) throws JsonMappingException {
        int n = annotatedConstructor.getParameterCount();
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n];
        for (int i = 0; i < n; ++i) {
            AnnotatedParameter annotatedParameter = annotatedConstructor.getParameter(i);
            JacksonInject.Value value = annotationIntrospector.findInjectableValue(annotatedParameter);
            PropertyName propertyName = annotationIntrospector.findNameForDeserialization(annotatedParameter);
            if (propertyName == null || propertyName.isEmpty()) {
                propertyName = PropertyName.construct(list.get(i));
            }
            settableBeanPropertyArray[i] = this.constructCreatorProperty(deserializationContext, creatorCollectionState.beanDesc, propertyName, i, annotatedParameter, value);
        }
        creatorCollectionState.creators.addPropertyCreator(annotatedConstructor, false, settableBeanPropertyArray);
    }

    protected void _addExplicitConstructorCreators(DeserializationContext deserializationContext, CreatorCollectionState creatorCollectionState, boolean bl) throws JsonMappingException {
        BeanDescription beanDescription = creatorCollectionState.beanDesc;
        CreatorCollector creatorCollector = creatorCollectionState.creators;
        AnnotationIntrospector annotationIntrospector = creatorCollectionState.annotationIntrospector();
        VisibilityChecker<?> visibilityChecker = creatorCollectionState.vchecker;
        Map<AnnotatedWithParams, BeanPropertyDefinition[]> map = creatorCollectionState.creatorParams;
        AnnotatedConstructor annotatedConstructor = beanDescription.findDefaultConstructor();
        if (annotatedConstructor != null && (!creatorCollector.hasDefaultCreator() || this._hasCreatorAnnotation(deserializationContext, annotatedConstructor))) {
            creatorCollector.setDefaultCreator(annotatedConstructor);
        }
        for (AnnotatedConstructor annotatedConstructor2 : beanDescription.getConstructors()) {
            JsonCreator.Mode mode = annotationIntrospector.findCreatorAnnotation(deserializationContext.getConfig(), annotatedConstructor2);
            if (JsonCreator.Mode.DISABLED == mode) continue;
            if (mode == null) {
                if (!bl || !visibilityChecker.isCreatorVisible(annotatedConstructor2)) continue;
                creatorCollectionState.addImplicitConstructorCandidate(CreatorCandidate.construct(annotationIntrospector, annotatedConstructor2, map.get(annotatedConstructor2)));
                continue;
            }
            switch (mode) {
                case DELEGATING: {
                    this._addExplicitDelegatingCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, annotatedConstructor2, null));
                    break;
                }
                case PROPERTIES: {
                    this._addExplicitPropertyCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, annotatedConstructor2, map.get(annotatedConstructor2)));
                    break;
                }
                default: {
                    this._addExplicitAnyCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, annotatedConstructor2, map.get(annotatedConstructor2)), deserializationContext.getConfig().getConstructorDetector());
                }
            }
            creatorCollectionState.increaseExplicitConstructorCount();
        }
    }

    protected void _addImplicitConstructorCreators(DeserializationContext deserializationContext, CreatorCollectionState creatorCollectionState, List<CreatorCandidate> list) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        BeanDescription beanDescription = creatorCollectionState.beanDesc;
        CreatorCollector creatorCollector = creatorCollectionState.creators;
        AnnotationIntrospector annotationIntrospector = creatorCollectionState.annotationIntrospector();
        VisibilityChecker<?> visibilityChecker = creatorCollectionState.vchecker;
        LinkedList<AnnotatedWithParams> linkedList = null;
        boolean bl = deserializationConfig.getConstructorDetector().singleArgCreatorDefaultsToProperties();
        for (CreatorCandidate creatorCandidate : list) {
            Serializable serializable;
            int n;
            int n2 = creatorCandidate.paramCount();
            AnnotatedWithParams annotatedWithParams = creatorCandidate.creator();
            if (n2 == 1) {
                boolean bl2;
                BeanPropertyDefinition beanPropertyDefinition = creatorCandidate.propertyDef(0);
                boolean bl3 = bl2 = bl || this._checkIfCreatorPropertyBased(annotationIntrospector, annotatedWithParams, beanPropertyDefinition);
                if (bl2) {
                    SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[1];
                    JacksonInject.Value value = creatorCandidate.injection(0);
                    PropertyName propertyName = creatorCandidate.paramName(0);
                    if (propertyName == null && (propertyName = creatorCandidate.findImplicitParamName(0)) == null && value == null) continue;
                    settableBeanPropertyArray[0] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, 0, creatorCandidate.parameter(0), value);
                    creatorCollector.addPropertyCreator(annotatedWithParams, false, settableBeanPropertyArray);
                    continue;
                }
                this._handleSingleArgumentCreator(creatorCollector, annotatedWithParams, false, visibilityChecker.isCreatorVisible(annotatedWithParams));
                if (beanPropertyDefinition == null) continue;
                ((POJOPropertyBuilder)beanPropertyDefinition).removeConstructors();
                continue;
            }
            int n3 = -1;
            SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n2];
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            for (n = 0; n < n2; ++n) {
                PropertyName propertyName;
                serializable = annotatedWithParams.getParameter(n);
                BeanPropertyDefinition beanPropertyDefinition = creatorCandidate.propertyDef(n);
                JacksonInject.Value value = annotationIntrospector.findInjectableValue((AnnotatedMember)serializable);
                PropertyName propertyName2 = propertyName = beanPropertyDefinition == null ? null : beanPropertyDefinition.getFullName();
                if (beanPropertyDefinition != null && beanPropertyDefinition.isExplicitlyNamed()) {
                    ++n4;
                    settableBeanPropertyArray[n] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, n, (AnnotatedParameter)serializable, value);
                    continue;
                }
                if (value != null) {
                    ++n6;
                    settableBeanPropertyArray[n] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, n, (AnnotatedParameter)serializable, value);
                    continue;
                }
                NameTransformer nameTransformer = annotationIntrospector.findUnwrappingNameTransformer((AnnotatedMember)serializable);
                if (nameTransformer != null) {
                    this._reportUnwrappedCreatorProperty(deserializationContext, beanDescription, (AnnotatedParameter)serializable);
                    continue;
                }
                if (n3 >= 0) continue;
                n3 = n;
            }
            n = n4 + n5;
            if (n4 > 0 || n6 > 0) {
                if (n + n6 == n2) {
                    creatorCollector.addPropertyCreator(annotatedWithParams, false, settableBeanPropertyArray);
                    continue;
                }
                if (n4 == 0 && n6 + 1 == n2) {
                    creatorCollector.addDelegatingCreator(annotatedWithParams, false, settableBeanPropertyArray, 0);
                    continue;
                }
                serializable = creatorCandidate.findImplicitParamName(n3);
                if (serializable == null || ((PropertyName)serializable).isEmpty()) {
                    deserializationContext.reportBadTypeDefinition(beanDescription, "Argument #%d of constructor %s has no property name annotation; must have name when multiple-parameter constructor annotated as Creator", n3, annotatedWithParams);
                }
            }
            if (creatorCollector.hasDefaultCreator()) continue;
            if (linkedList == null) {
                linkedList = new LinkedList<AnnotatedWithParams>();
            }
            linkedList.add(annotatedWithParams);
        }
        if (linkedList != null && !creatorCollector.hasDelegatingCreator() && !creatorCollector.hasPropertyBasedCreator()) {
            this._checkImplicitlyNamedConstructors(deserializationContext, beanDescription, visibilityChecker, annotationIntrospector, creatorCollector, linkedList);
        }
    }

    protected void _addExplicitFactoryCreators(DeserializationContext deserializationContext, CreatorCollectionState creatorCollectionState, boolean bl) throws JsonMappingException {
        BeanDescription beanDescription = creatorCollectionState.beanDesc;
        CreatorCollector creatorCollector = creatorCollectionState.creators;
        AnnotationIntrospector annotationIntrospector = creatorCollectionState.annotationIntrospector();
        VisibilityChecker<?> visibilityChecker = creatorCollectionState.vchecker;
        Map<AnnotatedWithParams, BeanPropertyDefinition[]> map = creatorCollectionState.creatorParams;
        for (AnnotatedMethod annotatedMethod : beanDescription.getFactoryMethods()) {
            JsonCreator.Mode mode = annotationIntrospector.findCreatorAnnotation(deserializationContext.getConfig(), annotatedMethod);
            int n = annotatedMethod.getParameterCount();
            if (mode == null) {
                if (!bl || n != 1 || !visibilityChecker.isCreatorVisible(annotatedMethod)) continue;
                creatorCollectionState.addImplicitFactoryCandidate(CreatorCandidate.construct(annotationIntrospector, annotatedMethod, null));
                continue;
            }
            if (mode == JsonCreator.Mode.DISABLED) continue;
            if (n == 0) {
                creatorCollector.setDefaultCreator(annotatedMethod);
                continue;
            }
            switch (mode) {
                case DELEGATING: {
                    this._addExplicitDelegatingCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, annotatedMethod, null));
                    break;
                }
                case PROPERTIES: {
                    this._addExplicitPropertyCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, annotatedMethod, map.get(annotatedMethod)));
                    break;
                }
                default: {
                    this._addExplicitAnyCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, annotatedMethod, map.get(annotatedMethod)), ConstructorDetector.DEFAULT);
                }
            }
            creatorCollectionState.increaseExplicitFactoryCount();
        }
    }

    protected void _addImplicitFactoryCreators(DeserializationContext deserializationContext, CreatorCollectionState creatorCollectionState, List<CreatorCandidate> list) throws JsonMappingException {
        BeanDescription beanDescription = creatorCollectionState.beanDesc;
        CreatorCollector creatorCollector = creatorCollectionState.creators;
        AnnotationIntrospector annotationIntrospector = creatorCollectionState.annotationIntrospector();
        VisibilityChecker<?> visibilityChecker = creatorCollectionState.vchecker;
        Map<AnnotatedWithParams, BeanPropertyDefinition[]> map = creatorCollectionState.creatorParams;
        for (CreatorCandidate creatorCandidate : list) {
            int n;
            int n2 = creatorCandidate.paramCount();
            AnnotatedWithParams annotatedWithParams = creatorCandidate.creator();
            BeanPropertyDefinition[] beanPropertyDefinitionArray = map.get(annotatedWithParams);
            if (n2 != 1) continue;
            BeanPropertyDefinition beanPropertyDefinition = creatorCandidate.propertyDef(0);
            boolean bl = this._checkIfCreatorPropertyBased(annotationIntrospector, annotatedWithParams, beanPropertyDefinition);
            if (!bl) {
                this._handleSingleArgumentCreator(creatorCollector, annotatedWithParams, false, visibilityChecker.isCreatorVisible(annotatedWithParams));
                if (beanPropertyDefinition == null) continue;
                ((POJOPropertyBuilder)beanPropertyDefinition).removeConstructors();
                continue;
            }
            AnnotatedParameter annotatedParameter = null;
            SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n2];
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (n = 0; n < n2; ++n) {
                PropertyName propertyName;
                AnnotatedParameter annotatedParameter2 = annotatedWithParams.getParameter(n);
                BeanPropertyDefinition beanPropertyDefinition2 = beanPropertyDefinitionArray == null ? null : beanPropertyDefinitionArray[n];
                JacksonInject.Value value = annotationIntrospector.findInjectableValue(annotatedParameter2);
                PropertyName propertyName2 = propertyName = beanPropertyDefinition2 == null ? null : beanPropertyDefinition2.getFullName();
                if (beanPropertyDefinition2 != null && beanPropertyDefinition2.isExplicitlyNamed()) {
                    ++n4;
                    settableBeanPropertyArray[n] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, n, annotatedParameter2, value);
                    continue;
                }
                if (value != null) {
                    ++n5;
                    settableBeanPropertyArray[n] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, n, annotatedParameter2, value);
                    continue;
                }
                NameTransformer nameTransformer = annotationIntrospector.findUnwrappingNameTransformer(annotatedParameter2);
                if (nameTransformer != null) {
                    this._reportUnwrappedCreatorProperty(deserializationContext, beanDescription, annotatedParameter2);
                    continue;
                }
                if (annotatedParameter != null) continue;
                annotatedParameter = annotatedParameter2;
            }
            n = n4 + n3;
            if (n4 <= 0 && n5 <= 0) continue;
            if (n + n5 == n2) {
                creatorCollector.addPropertyCreator(annotatedWithParams, false, settableBeanPropertyArray);
                continue;
            }
            if (n4 == 0 && n5 + 1 == n2) {
                creatorCollector.addDelegatingCreator(annotatedWithParams, false, settableBeanPropertyArray, 0);
                continue;
            }
            deserializationContext.reportBadTypeDefinition(beanDescription, "Argument #%d of factory method %s has no property name annotation; must have name when multiple-parameter constructor annotated as Creator", annotatedParameter == null ? -1 : annotatedParameter.getIndex(), annotatedWithParams);
        }
    }

    protected void _addExplicitDelegatingCreator(DeserializationContext deserializationContext, BeanDescription beanDescription, CreatorCollector creatorCollector, CreatorCandidate creatorCandidate) throws JsonMappingException {
        int n = -1;
        int n2 = creatorCandidate.paramCount();
        SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n2];
        for (int i = 0; i < n2; ++i) {
            AnnotatedParameter annotatedParameter = creatorCandidate.parameter(i);
            JacksonInject.Value value = creatorCandidate.injection(i);
            if (value != null) {
                settableBeanPropertyArray[i] = this.constructCreatorProperty(deserializationContext, beanDescription, null, i, annotatedParameter, value);
                continue;
            }
            if (n < 0) {
                n = i;
                continue;
            }
            deserializationContext.reportBadTypeDefinition(beanDescription, "More than one argument (#%d and #%d) left as delegating for Creator %s: only one allowed", n, i, creatorCandidate);
        }
        if (n < 0) {
            deserializationContext.reportBadTypeDefinition(beanDescription, "No argument left as delegating for Creator %s: exactly one required", creatorCandidate);
        }
        if (n2 == 1) {
            this._handleSingleArgumentCreator(creatorCollector, creatorCandidate.creator(), true, true);
            BeanPropertyDefinition beanPropertyDefinition = creatorCandidate.propertyDef(0);
            if (beanPropertyDefinition != null) {
                ((POJOPropertyBuilder)beanPropertyDefinition).removeConstructors();
            }
            return;
        }
        creatorCollector.addDelegatingCreator(creatorCandidate.creator(), true, settableBeanPropertyArray, n);
    }

    protected void _addExplicitPropertyCreator(DeserializationContext deserializationContext, BeanDescription beanDescription, CreatorCollector creatorCollector, CreatorCandidate creatorCandidate) throws JsonMappingException {
        int n = creatorCandidate.paramCount();
        SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n];
        for (int i = 0; i < n; ++i) {
            JacksonInject.Value value = creatorCandidate.injection(i);
            AnnotatedParameter annotatedParameter = creatorCandidate.parameter(i);
            PropertyName propertyName = creatorCandidate.paramName(i);
            if (propertyName == null) {
                NameTransformer nameTransformer = deserializationContext.getAnnotationIntrospector().findUnwrappingNameTransformer(annotatedParameter);
                if (nameTransformer != null) {
                    this._reportUnwrappedCreatorProperty(deserializationContext, beanDescription, annotatedParameter);
                }
                propertyName = creatorCandidate.findImplicitParamName(i);
                this._validateNamedPropertyParameter(deserializationContext, beanDescription, creatorCandidate, i, propertyName, value);
            }
            settableBeanPropertyArray[i] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, i, annotatedParameter, value);
        }
        creatorCollector.addPropertyCreator(creatorCandidate.creator(), true, settableBeanPropertyArray);
    }

    @Deprecated
    protected void _addExplicitAnyCreator(DeserializationContext deserializationContext, BeanDescription beanDescription, CreatorCollector creatorCollector, CreatorCandidate creatorCandidate) throws JsonMappingException {
        this._addExplicitAnyCreator(deserializationContext, beanDescription, creatorCollector, creatorCandidate, deserializationContext.getConfig().getConstructorDetector());
    }

    protected void _addExplicitAnyCreator(DeserializationContext deserializationContext, BeanDescription beanDescription, CreatorCollector creatorCollector, CreatorCandidate creatorCandidate, ConstructorDetector constructorDetector) throws JsonMappingException {
        SettableBeanProperty[] settableBeanPropertyArray;
        boolean bl;
        if (1 != creatorCandidate.paramCount()) {
            int n;
            if (!constructorDetector.singleArgCreatorDefaultsToProperties() && (n = creatorCandidate.findOnlyParamWithoutInjection()) >= 0 && (constructorDetector.singleArgCreatorDefaultsToDelegating() || creatorCandidate.paramName(n) == null)) {
                this._addExplicitDelegatingCreator(deserializationContext, beanDescription, creatorCollector, creatorCandidate);
                return;
            }
            this._addExplicitPropertyCreator(deserializationContext, beanDescription, creatorCollector, creatorCandidate);
            return;
        }
        AnnotatedParameter annotatedParameter = creatorCandidate.parameter(0);
        JacksonInject.Value value = creatorCandidate.injection(0);
        PropertyName propertyName = null;
        switch (constructorDetector.singleArgMode()) {
            case DELEGATING: {
                bl = false;
                break;
            }
            case PROPERTIES: {
                bl = true;
                propertyName = creatorCandidate.paramName(0);
                if (propertyName != null) break;
                this._validateNamedPropertyParameter(deserializationContext, beanDescription, creatorCandidate, 0, propertyName, value);
                break;
            }
            case REQUIRE_MODE: {
                deserializationContext.reportBadTypeDefinition(beanDescription, "Single-argument constructor (%s) is annotated but no 'mode' defined; `CreatorDetector`configured with `SingleArgConstructor.REQUIRE_MODE`", creatorCandidate.creator());
                return;
            }
            default: {
                settableBeanPropertyArray = creatorCandidate.propertyDef(0);
                propertyName = creatorCandidate.explicitParamName(0);
                boolean bl2 = bl = propertyName != null || value != null;
                if (bl || settableBeanPropertyArray == null) break;
                propertyName = creatorCandidate.paramName(0);
                boolean bl3 = bl = propertyName != null && settableBeanPropertyArray.couldSerialize();
            }
        }
        if (bl) {
            settableBeanPropertyArray = new SettableBeanProperty[]{this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, 0, annotatedParameter, value)};
            creatorCollector.addPropertyCreator(creatorCandidate.creator(), true, settableBeanPropertyArray);
            return;
        }
        this._handleSingleArgumentCreator(creatorCollector, creatorCandidate.creator(), true, true);
        settableBeanPropertyArray = creatorCandidate.propertyDef(0);
        if (settableBeanPropertyArray != null) {
            ((POJOPropertyBuilder)settableBeanPropertyArray).removeConstructors();
        }
    }

    private boolean _checkIfCreatorPropertyBased(AnnotationIntrospector annotationIntrospector, AnnotatedWithParams annotatedWithParams, BeanPropertyDefinition beanPropertyDefinition) {
        String string;
        if (beanPropertyDefinition != null && beanPropertyDefinition.isExplicitlyNamed() || annotationIntrospector.findInjectableValue(annotatedWithParams.getParameter(0)) != null) {
            return true;
        }
        return beanPropertyDefinition != null && (string = beanPropertyDefinition.getName()) != null && !string.isEmpty() && beanPropertyDefinition.couldSerialize();
    }

    private void _checkImplicitlyNamedConstructors(DeserializationContext deserializationContext, BeanDescription beanDescription, VisibilityChecker<?> visibilityChecker, AnnotationIntrospector annotationIntrospector, CreatorCollector creatorCollector, List<AnnotatedWithParams> list) throws JsonMappingException {
        Object object;
        Serializable serializable;
        AnnotatedWithParams annotatedWithParams = null;
        SettableBeanProperty[] settableBeanPropertyArray = null;
        block0: for (AnnotatedWithParams annotatedWithParams2 : list) {
            if (!visibilityChecker.isCreatorVisible(annotatedWithParams2)) continue;
            int n = annotatedWithParams2.getParameterCount();
            SettableBeanProperty[] settableBeanPropertyArray2 = new SettableBeanProperty[n];
            for (int i = 0; i < n; ++i) {
                serializable = annotatedWithParams2.getParameter(i);
                object = this._findParamName((AnnotatedParameter)serializable, annotationIntrospector);
                if (object == null || ((PropertyName)object).isEmpty()) continue block0;
                settableBeanPropertyArray2[i] = this.constructCreatorProperty(deserializationContext, beanDescription, (PropertyName)object, ((AnnotatedParameter)serializable).getIndex(), (AnnotatedParameter)serializable, null);
            }
            if (annotatedWithParams != null) {
                annotatedWithParams = null;
                break;
            }
            annotatedWithParams = annotatedWithParams2;
            settableBeanPropertyArray = settableBeanPropertyArray2;
        }
        if (annotatedWithParams != null) {
            creatorCollector.addPropertyCreator(annotatedWithParams, false, settableBeanPropertyArray);
            BasicBeanDescription basicBeanDescription = (BasicBeanDescription)beanDescription;
            for (AnnotatedWithParams annotatedWithParams3 : settableBeanPropertyArray) {
                serializable = ((SettableBeanProperty)((Object)annotatedWithParams3)).getFullName();
                if (basicBeanDescription.hasProperty((PropertyName)serializable)) continue;
                object = SimpleBeanPropertyDefinition.construct(deserializationContext.getConfig(), ((SettableBeanProperty)((Object)annotatedWithParams3)).getMember(), (PropertyName)serializable);
                basicBeanDescription.addProperty((BeanPropertyDefinition)object);
            }
        }
    }

    protected boolean _handleSingleArgumentCreator(CreatorCollector creatorCollector, AnnotatedWithParams annotatedWithParams, boolean bl, boolean bl2) {
        Class<?> clazz = annotatedWithParams.getRawParameterType(0);
        if (clazz == String.class || clazz == CLASS_CHAR_SEQUENCE) {
            if (bl || bl2) {
                creatorCollector.addStringCreator(annotatedWithParams, bl);
            }
            return true;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            if (bl || bl2) {
                creatorCollector.addIntCreator(annotatedWithParams, bl);
            }
            return true;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            if (bl || bl2) {
                creatorCollector.addLongCreator(annotatedWithParams, bl);
            }
            return true;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            if (bl || bl2) {
                creatorCollector.addDoubleCreator(annotatedWithParams, bl);
            }
            return true;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            if (bl || bl2) {
                creatorCollector.addBooleanCreator(annotatedWithParams, bl);
            }
            return true;
        }
        if (clazz == BigInteger.class && (bl || bl2)) {
            creatorCollector.addBigIntegerCreator(annotatedWithParams, bl);
        }
        if (clazz == BigDecimal.class && (bl || bl2)) {
            creatorCollector.addBigDecimalCreator(annotatedWithParams, bl);
        }
        if (bl) {
            creatorCollector.addDelegatingCreator(annotatedWithParams, bl, null, 0);
            return true;
        }
        return false;
    }

    protected void _validateNamedPropertyParameter(DeserializationContext deserializationContext, BeanDescription beanDescription, CreatorCandidate creatorCandidate, int n, PropertyName propertyName, JacksonInject.Value value) throws JsonMappingException {
        if (propertyName == null && value == null) {
            deserializationContext.reportBadTypeDefinition(beanDescription, "Argument #%d of constructor %s has no property name (and is not Injectable): can not use as property-based Creator", n, creatorCandidate);
        }
    }

    protected void _reportUnwrappedCreatorProperty(DeserializationContext deserializationContext, BeanDescription beanDescription, AnnotatedParameter annotatedParameter) throws JsonMappingException {
        deserializationContext.reportBadTypeDefinition(beanDescription, "Cannot define Creator parameter %d as `@JsonUnwrapped`: combination not yet supported", annotatedParameter.getIndex());
    }

    protected SettableBeanProperty constructCreatorProperty(DeserializationContext deserializationContext, BeanDescription beanDescription, PropertyName propertyName, int n, AnnotatedParameter annotatedParameter, JacksonInject.Value value) throws JsonMappingException {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        PropertyName propertyName2;
        PropertyMetadata propertyMetadata;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (annotationIntrospector == null) {
            propertyMetadata = PropertyMetadata.STD_REQUIRED_OR_OPTIONAL;
            propertyName2 = null;
        } else {
            serializable = annotationIntrospector.hasRequiredMarker(annotatedParameter);
            object3 = annotationIntrospector.findPropertyDescription(annotatedParameter);
            object2 = annotationIntrospector.findPropertyIndex(annotatedParameter);
            object = annotationIntrospector.findPropertyDefaultValue(annotatedParameter);
            propertyMetadata = PropertyMetadata.construct((Boolean)serializable, (String)object3, (Integer)object2, (String)object);
            propertyName2 = annotationIntrospector.findWrapperName(annotatedParameter);
        }
        serializable = this.resolveMemberAndTypeAnnotations(deserializationContext, annotatedParameter, annotatedParameter.getType());
        object3 = new BeanProperty.Std(propertyName, (JavaType)serializable, propertyName2, annotatedParameter, propertyMetadata);
        object2 = (TypeDeserializer)((JavaType)serializable).getTypeHandler();
        if (object2 == null) {
            object2 = this.findTypeDeserializer(deserializationConfig, (JavaType)serializable);
        }
        propertyMetadata = this._getSetterInfo(deserializationContext, (BeanProperty)object3, propertyMetadata);
        object = CreatorProperty.construct(propertyName, (JavaType)serializable, ((BeanProperty.Std)object3).getWrapperName(), (TypeDeserializer)object2, beanDescription.getClassAnnotations(), annotatedParameter, n, value, propertyMetadata);
        JsonDeserializer<?> jsonDeserializer = this.findDeserializerFromAnnotation(deserializationContext, annotatedParameter);
        if (jsonDeserializer == null) {
            jsonDeserializer = (JsonDeserializer<?>)((JavaType)serializable).getValueHandler();
        }
        if (jsonDeserializer != null) {
            jsonDeserializer = deserializationContext.handlePrimaryContextualization(jsonDeserializer, (BeanProperty)object, (JavaType)serializable);
            object = ((SettableBeanProperty)object).withValueDeserializer(jsonDeserializer);
        }
        return object;
    }

    private PropertyName _findParamName(AnnotatedParameter annotatedParameter, AnnotationIntrospector annotationIntrospector) {
        if (annotationIntrospector != null) {
            PropertyName propertyName = annotationIntrospector.findNameForDeserialization(annotatedParameter);
            if (propertyName != null && !propertyName.isEmpty()) {
                return propertyName;
            }
            String string = annotationIntrospector.findImplicitPropertyName(annotatedParameter);
            if (string != null && !string.isEmpty()) {
                return PropertyName.construct(string);
            }
        }
        return null;
    }

    protected PropertyMetadata _getSetterInfo(DeserializationContext deserializationContext, BeanProperty beanProperty, PropertyMetadata propertyMetadata) {
        Object object;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        boolean bl = true;
        Nulls nulls = null;
        Nulls nulls2 = null;
        AnnotatedMember annotatedMember = beanProperty.getMember();
        if (annotatedMember != null) {
            JsonSetter.Value value;
            if (annotationIntrospector != null && (object = annotationIntrospector.findSetterInfo(annotatedMember)) != null) {
                nulls = ((JsonSetter.Value)object).nonDefaultValueNulls();
                nulls2 = ((JsonSetter.Value)object).nonDefaultContentNulls();
            }
            if ((bl || nulls == null || nulls2 == null) && (value = ((ConfigOverride)(object = deserializationConfig.getConfigOverride(beanProperty.getType().getRawClass()))).getSetterInfo()) != null) {
                if (nulls == null) {
                    nulls = value.nonDefaultValueNulls();
                }
                if (nulls2 == null) {
                    nulls2 = value.nonDefaultContentNulls();
                }
            }
        }
        if (bl || nulls == null || nulls2 == null) {
            object = deserializationConfig.getDefaultSetterInfo();
            if (nulls == null) {
                nulls = ((JsonSetter.Value)object).nonDefaultValueNulls();
            }
            if (nulls2 == null) {
                nulls2 = ((JsonSetter.Value)object).nonDefaultContentNulls();
            }
        }
        if (nulls != null || nulls2 != null) {
            propertyMetadata = propertyMetadata.withNulls(nulls, nulls2);
        }
        return propertyMetadata;
    }

    @Override
    public JsonDeserializer<?> createArrayDeserializer(DeserializationContext deserializationContext, ArrayType arrayType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer jsonDeserializer;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        JavaType javaType = arrayType.getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType.getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = this.findTypeDeserializer(deserializationConfig, javaType);
        }
        if ((jsonDeserializer = this._findCustomArrayDeserializer(arrayType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer2)) == null) {
            if (jsonDeserializer2 == null) {
                Class<?> clazz = javaType.getRawClass();
                if (javaType.isPrimitive()) {
                    return PrimitiveArrayDeserializers.forType(clazz);
                }
                if (clazz == String.class) {
                    return StringArrayDeserializer.instance;
                }
            }
            jsonDeserializer = new ObjectArrayDeserializer((JavaType)arrayType, jsonDeserializer2, typeDeserializer);
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyArrayDeserializer(deserializationConfig, arrayType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createCollectionDeserializer(DeserializationContext deserializationContext, CollectionType object, BeanDescription beanDescription) throws JsonMappingException {
        Object object2;
        JsonDeserializer jsonDeserializer;
        JavaType javaType = ((CollectionLikeType)object).getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType.getValueHandler();
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = this.findTypeDeserializer(deserializationConfig, javaType);
        }
        if ((jsonDeserializer = this._findCustomCollectionDeserializer((CollectionType)object, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer2)) == null) {
            object2 = ((JavaType)object).getRawClass();
            if (jsonDeserializer2 == null && EnumSet.class.isAssignableFrom((Class<?>)object2)) {
                jsonDeserializer = new EnumSetDeserializer(javaType, null);
            }
        }
        if (jsonDeserializer == null) {
            if (((JavaType)object).isInterface() || ((JavaType)object).isAbstract()) {
                object2 = this._mapAbstractCollectionType((JavaType)object, deserializationConfig);
                if (object2 == null) {
                    if (((JavaType)object).getTypeHandler() == null) {
                        throw new IllegalArgumentException("Cannot find a deserializer for non-concrete Collection type " + object);
                    }
                    jsonDeserializer = AbstractDeserializer.constructForNonPOJO(beanDescription);
                } else {
                    object = object2;
                    beanDescription = deserializationConfig.introspectForCreation((JavaType)object);
                }
            }
            if (jsonDeserializer == null) {
                object2 = this.findValueInstantiator(deserializationContext, beanDescription);
                if (!((ValueInstantiator)object2).canCreateUsingDefault()) {
                    if (((JavaType)object).hasRawClass(ArrayBlockingQueue.class)) {
                        return new ArrayBlockingQueueDeserializer((JavaType)object, jsonDeserializer2, typeDeserializer, (ValueInstantiator)object2);
                    }
                    jsonDeserializer = JavaUtilCollectionsDeserializers.findForCollection(deserializationContext, (JavaType)object);
                    if (jsonDeserializer != null) {
                        return jsonDeserializer;
                    }
                }
                jsonDeserializer = javaType.hasRawClass(String.class) ? new StringCollectionDeserializer((JavaType)object, jsonDeserializer2, (ValueInstantiator)object2) : new CollectionDeserializer((JavaType)object, jsonDeserializer2, typeDeserializer, (ValueInstantiator)object2);
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyCollectionDeserializer(deserializationConfig, (CollectionType)object, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    protected CollectionType _mapAbstractCollectionType(JavaType javaType, DeserializationConfig deserializationConfig) {
        Class<?> clazz = ContainerDefaultMappings.findCollectionFallback(javaType);
        if (clazz != null) {
            return (CollectionType)deserializationConfig.getTypeFactory().constructSpecializedType(javaType, clazz, true);
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> createCollectionLikeDeserializer(DeserializationContext deserializationContext, CollectionLikeType collectionLikeType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer<?> jsonDeserializer;
        JavaType javaType = collectionLikeType.getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType.getValueHandler();
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = this.findTypeDeserializer(deserializationConfig, javaType);
        }
        if ((jsonDeserializer = this._findCustomCollectionLikeDeserializer(collectionLikeType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer2)) != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyCollectionLikeDeserializer(deserializationConfig, collectionLikeType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JsonDeserializer<?> createMapDeserializer(DeserializationContext deserializationContext, MapType object, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer jsonDeserializer;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        JavaType javaType = ((MapLikeType)object).getKeyType();
        JavaType javaType2 = ((MapLikeType)object).getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType2.getValueHandler();
        KeyDeserializer keyDeserializer = (KeyDeserializer)javaType.getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType2.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = this.findTypeDeserializer(deserializationConfig, javaType2);
        }
        if ((jsonDeserializer = this._findCustomMapDeserializer((MapType)object, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer2)) == null) {
            Class<?> clazz = ((JavaType)object).getRawClass();
            if (EnumMap.class.isAssignableFrom(clazz)) {
                void var12_14;
                if (clazz == EnumMap.class) {
                    Object object2 = null;
                } else {
                    ValueInstantiator valueInstantiator = this.findValueInstantiator(deserializationContext, beanDescription);
                }
                if (!javaType.isEnumImplType()) {
                    throw new IllegalArgumentException("Cannot construct EnumMap; generic (key) type not available");
                }
                jsonDeserializer = new EnumMapDeserializer((JavaType)object, (ValueInstantiator)var12_14, null, jsonDeserializer2, typeDeserializer, null);
            }
            if (jsonDeserializer == null) {
                if (((JavaType)object).isInterface() || ((JavaType)object).isAbstract()) {
                    MapType mapType = this._mapAbstractMapType((JavaType)object, deserializationConfig);
                    if (mapType != null) {
                        object = mapType;
                        clazz = ((JavaType)object).getRawClass();
                        beanDescription = deserializationConfig.introspectForCreation((JavaType)object);
                    } else {
                        if (((JavaType)object).getTypeHandler() == null) {
                            throw new IllegalArgumentException("Cannot find a deserializer for non-concrete Map type " + object);
                        }
                        jsonDeserializer = AbstractDeserializer.constructForNonPOJO(beanDescription);
                    }
                } else {
                    jsonDeserializer = JavaUtilCollectionsDeserializers.findForMap(deserializationContext, (JavaType)object);
                    if (jsonDeserializer != null) {
                        return jsonDeserializer;
                    }
                }
                if (jsonDeserializer == null) {
                    ValueInstantiator valueInstantiator = this.findValueInstantiator(deserializationContext, beanDescription);
                    MapDeserializer mapDeserializer = new MapDeserializer((JavaType)object, valueInstantiator, keyDeserializer, jsonDeserializer2, typeDeserializer);
                    JsonIgnoreProperties.Value value = deserializationConfig.getDefaultPropertyIgnorals(Map.class, beanDescription.getClassInfo());
                    Set<String> set = value == null ? null : value.findIgnoredForDeserialization();
                    mapDeserializer.setIgnorableProperties(set);
                    JsonIncludeProperties.Value value2 = deserializationConfig.getDefaultPropertyInclusions(Map.class, beanDescription.getClassInfo());
                    Set<String> set2 = value2 == null ? null : value2.getIncluded();
                    mapDeserializer.setIncludableProperties(set2);
                    jsonDeserializer = mapDeserializer;
                }
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyMapDeserializer(deserializationConfig, (MapType)object, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    protected MapType _mapAbstractMapType(JavaType javaType, DeserializationConfig deserializationConfig) {
        Class<?> clazz = ContainerDefaultMappings.findMapFallback(javaType);
        if (clazz != null) {
            return (MapType)deserializationConfig.getTypeFactory().constructSpecializedType(javaType, clazz, true);
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> createMapLikeDeserializer(DeserializationContext deserializationContext, MapLikeType mapLikeType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer<?> jsonDeserializer;
        JavaType javaType = mapLikeType.getKeyType();
        JavaType javaType2 = mapLikeType.getContentType();
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType2.getValueHandler();
        KeyDeserializer keyDeserializer = (KeyDeserializer)javaType.getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType2.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = this.findTypeDeserializer(deserializationConfig, javaType2);
        }
        if ((jsonDeserializer = this._findCustomMapLikeDeserializer(mapLikeType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer2)) != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyMapLikeDeserializer(deserializationConfig, mapLikeType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createEnumDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        Class<?> clazz = javaType.getRawClass();
        JsonDeserializer jsonDeserializer = this._findCustomEnumDeserializer(clazz, deserializationConfig, beanDescription);
        if (jsonDeserializer == null) {
            if (clazz == Enum.class) {
                return AbstractDeserializer.constructForNonPOJO(beanDescription);
            }
            ValueInstantiator valueInstantiator = this._constructDefaultValueInstantiator(deserializationContext, beanDescription);
            SettableBeanProperty[] object = valueInstantiator == null ? null : valueInstantiator.getFromObjectArguments(deserializationContext.getConfig());
            for (AnnotatedMethod annotatedMethod : beanDescription.getFactoryMethods()) {
                if (!this._hasCreatorAnnotation(deserializationContext, annotatedMethod)) continue;
                if (annotatedMethod.getParameterCount() == 0) {
                    jsonDeserializer = EnumDeserializer.deserializerForNoArgsCreator(deserializationConfig, clazz, annotatedMethod);
                    break;
                }
                Class<?> clazz2 = annotatedMethod.getRawReturnType();
                if (!clazz2.isAssignableFrom(clazz)) {
                    deserializationContext.reportBadDefinition(javaType, String.format("Invalid `@JsonCreator` annotated Enum factory method [%s]: needs to return compatible type", annotatedMethod.toString()));
                }
                jsonDeserializer = EnumDeserializer.deserializerForCreator(deserializationConfig, clazz, annotatedMethod, valueInstantiator, object);
                break;
            }
            if (jsonDeserializer == null) {
                jsonDeserializer = new EnumDeserializer(this.constructEnumResolver(clazz, deserializationConfig, beanDescription.findJsonValueAccessor()), (Boolean)deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS));
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyEnumDeserializer(deserializationConfig, javaType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createTreeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        Class<?> clazz = javaType.getRawClass();
        JsonDeserializer<?> jsonDeserializer = this._findCustomTreeNodeDeserializer(clazz, deserializationConfig, beanDescription);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        return JsonNodeDeserializer.getDeserializer(clazz);
    }

    @Override
    public JsonDeserializer<?> createReferenceDeserializer(DeserializationContext deserializationContext, ReferenceType referenceType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer<?> jsonDeserializer;
        JavaType javaType = referenceType.getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType.getValueHandler();
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = this.findTypeDeserializer(deserializationConfig, javaType);
        }
        if ((jsonDeserializer = this._findCustomReferenceDeserializer(referenceType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer2)) == null && referenceType.isTypeOrSubTypeOf(AtomicReference.class)) {
            Class<?> clazz = referenceType.getRawClass();
            ValueInstantiator valueInstantiator = clazz == AtomicReference.class ? null : this.findValueInstantiator(deserializationContext, beanDescription);
            return new AtomicReferenceDeserializer(referenceType, valueInstantiator, typeDeserializer, jsonDeserializer2);
        }
        if (jsonDeserializer != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyReferenceDeserializer(deserializationConfig, referenceType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    @Override
    public TypeDeserializer findTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType) throws JsonMappingException {
        JavaType javaType2;
        BeanDescription beanDescription = deserializationConfig.introspectClassAnnotations(javaType.getRawClass());
        AnnotatedClass annotatedClass = beanDescription.getClassInfo();
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        TypeResolverBuilder<?> typeResolverBuilder = annotationIntrospector.findTypeResolver(deserializationConfig, annotatedClass, javaType);
        Collection<NamedType> collection = null;
        if (typeResolverBuilder == null) {
            typeResolverBuilder = deserializationConfig.getDefaultTyper(javaType);
            if (typeResolverBuilder == null) {
                return null;
            }
        } else {
            collection = deserializationConfig.getSubtypeResolver().collectAndResolveSubtypesByTypeId(deserializationConfig, annotatedClass);
        }
        if (typeResolverBuilder.getDefaultImpl() == null && javaType.isAbstract() && (javaType2 = this.mapAbstractType(deserializationConfig, javaType)) != null && !javaType2.hasRawClass(javaType.getRawClass())) {
            typeResolverBuilder = typeResolverBuilder.withDefaultImpl(javaType2.getRawClass());
        }
        try {
            return typeResolverBuilder.buildTypeDeserializer(deserializationConfig, javaType, collection);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            throw InvalidDefinitionException.from((JsonParser)null, ClassUtil.exceptionMessage(runtimeException), javaType).withCause(runtimeException);
        }
    }

    protected JsonDeserializer<?> findOptionalStdDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        return OptionalHandlerFactory.instance.findDeserializer(javaType, deserializationContext.getConfig(), beanDescription);
    }

    @Override
    public KeyDeserializer createKeyDeserializer(DeserializationContext deserializationContext, JavaType javaType) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        BeanDescription beanDescription = null;
        KeyDeserializer keyDeserializer = null;
        if (this._factoryConfig.hasKeyDeserializers()) {
            KeyDeserializers object;
            beanDescription = deserializationConfig.introspectClassAnnotations(javaType);
            Iterator<Object> iterator2 = this._factoryConfig.keyDeserializers().iterator();
            while (iterator2.hasNext() && (keyDeserializer = (object = iterator2.next()).findKeyDeserializer(javaType, deserializationConfig, beanDescription)) == null) {
            }
        }
        if (keyDeserializer == null) {
            if (beanDescription == null) {
                beanDescription = deserializationConfig.introspectClassAnnotations(javaType.getRawClass());
            }
            if ((keyDeserializer = this.findKeyDeserializerFromAnnotation(deserializationContext, beanDescription.getClassInfo())) == null) {
                keyDeserializer = javaType.isEnumType() ? this._createEnumKeyDeserializer(deserializationContext, javaType) : StdKeyDeserializers.findStringBasedKeyDeserializer(deserializationConfig, javaType);
            }
        }
        if (keyDeserializer != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                keyDeserializer = beanDeserializerModifier.modifyKeyDeserializer(deserializationConfig, javaType, keyDeserializer);
            }
        }
        return keyDeserializer;
    }

    private KeyDeserializer _createEnumKeyDeserializer(DeserializationContext deserializationContext, JavaType javaType) throws JsonMappingException {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        Class<?> clazz = javaType.getRawClass();
        BeanDescription beanDescription = deserializationConfig.introspect(javaType);
        KeyDeserializer keyDeserializer = this.findKeyDeserializerFromAnnotation(deserializationContext, beanDescription.getClassInfo());
        if (keyDeserializer != null) {
            return keyDeserializer;
        }
        JsonDeserializer<?> jsonDeserializer = this._findCustomEnumDeserializer(clazz, deserializationConfig, beanDescription);
        if (jsonDeserializer != null) {
            return StdKeyDeserializers.constructDelegatingKeyDeserializer(deserializationConfig, javaType, jsonDeserializer);
        }
        JsonDeserializer<Object> jsonDeserializer2 = this.findDeserializerFromAnnotation(deserializationContext, beanDescription.getClassInfo());
        if (jsonDeserializer2 != null) {
            return StdKeyDeserializers.constructDelegatingKeyDeserializer(deserializationConfig, javaType, jsonDeserializer2);
        }
        jsonDeserializer = this.constructEnumResolver(clazz, deserializationConfig, beanDescription.findJsonValueAccessor());
        for (AnnotatedMethod annotatedMethod : beanDescription.getFactoryMethods()) {
            Class<?> clazz2;
            if (!this._hasCreatorAnnotation(deserializationContext, annotatedMethod)) continue;
            int n = annotatedMethod.getParameterCount();
            if (n == 1 && (clazz2 = annotatedMethod.getRawReturnType()).isAssignableFrom(clazz)) {
                if (annotatedMethod.getRawParameterType(0) != String.class) continue;
                if (deserializationConfig.canOverrideAccessModifiers()) {
                    ClassUtil.checkAndFixAccess(annotatedMethod.getMember(), deserializationContext.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
                }
                return StdKeyDeserializers.constructEnumKeyDeserializer((EnumResolver)((Object)jsonDeserializer), annotatedMethod);
            }
            throw new IllegalArgumentException("Unsuitable method (" + annotatedMethod + ") decorated with @JsonCreator (for Enum type " + clazz.getName() + ")");
        }
        return StdKeyDeserializers.constructEnumKeyDeserializer((EnumResolver)((Object)jsonDeserializer));
    }

    @Override
    public boolean hasExplicitDeserializerFor(DeserializationConfig deserializationConfig, Class<?> clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return true;
        }
        String string = clazz.getName();
        if (string.startsWith("java.")) {
            if (Collection.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return NumberDeserializers.find(clazz, string) != null;
            }
            if (JdkDeserializers.hasDeserializerFor(clazz) || clazz == CLASS_STRING || clazz == Boolean.class || clazz == EnumMap.class || clazz == AtomicReference.class) {
                return true;
            }
            return DateDeserializers.hasDeserializerFor(clazz);
        }
        if (string.startsWith("com.fasterxml.")) {
            return JsonNode.class.isAssignableFrom(clazz) || clazz == TokenBuffer.class;
        }
        return OptionalHandlerFactory.instance.hasDeserializerFor(clazz);
    }

    public TypeDeserializer findPropertyTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, AnnotatedMember annotatedMember) throws JsonMappingException {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        TypeResolverBuilder<?> typeResolverBuilder = annotationIntrospector.findPropertyTypeResolver(deserializationConfig, annotatedMember, javaType);
        if (typeResolverBuilder == null) {
            return this.findTypeDeserializer(deserializationConfig, javaType);
        }
        Collection<NamedType> collection = deserializationConfig.getSubtypeResolver().collectAndResolveSubtypesByTypeId(deserializationConfig, annotatedMember, javaType);
        try {
            return typeResolverBuilder.buildTypeDeserializer(deserializationConfig, javaType, collection);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            throw InvalidDefinitionException.from((JsonParser)null, ClassUtil.exceptionMessage(runtimeException), javaType).withCause(runtimeException);
        }
    }

    public TypeDeserializer findPropertyContentTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, AnnotatedMember annotatedMember) throws JsonMappingException {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        TypeResolverBuilder<?> typeResolverBuilder = annotationIntrospector.findPropertyContentTypeResolver(deserializationConfig, annotatedMember, javaType);
        JavaType javaType2 = javaType.getContentType();
        if (typeResolverBuilder == null) {
            return this.findTypeDeserializer(deserializationConfig, javaType2);
        }
        Collection<NamedType> collection = deserializationConfig.getSubtypeResolver().collectAndResolveSubtypesByTypeId(deserializationConfig, annotatedMember, javaType2);
        return typeResolverBuilder.buildTypeDeserializer(deserializationConfig, javaType2, collection);
    }

    public JsonDeserializer<?> findDefaultDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        JsonDeserializer<?> jsonDeserializer;
        Class<?> clazz = javaType.getRawClass();
        if (clazz == CLASS_OBJECT || clazz == CLASS_SERIALIZABLE) {
            JavaType javaType2;
            JavaType javaType3;
            DeserializationConfig deserializationConfig = deserializationContext.getConfig();
            if (this._factoryConfig.hasAbstractTypeResolvers()) {
                javaType3 = this._findRemappedType(deserializationConfig, List.class);
                javaType2 = this._findRemappedType(deserializationConfig, Map.class);
            } else {
                javaType2 = null;
                javaType3 = null;
            }
            return new UntypedObjectDeserializer(javaType3, javaType2);
        }
        if (clazz == CLASS_STRING || clazz == CLASS_CHAR_SEQUENCE) {
            return StringDeserializer.instance;
        }
        if (clazz == CLASS_ITERABLE) {
            TypeFactory typeFactory = deserializationContext.getTypeFactory();
            JavaType[] javaTypeArray = typeFactory.findTypeParameters(javaType, CLASS_ITERABLE);
            JavaType javaType4 = javaTypeArray == null || javaTypeArray.length != 1 ? TypeFactory.unknownType() : javaTypeArray[0];
            CollectionType collectionType = typeFactory.constructCollectionType(Collection.class, javaType4);
            return this.createCollectionDeserializer(deserializationContext, collectionType, beanDescription);
        }
        if (clazz == CLASS_MAP_ENTRY) {
            JavaType javaType5 = javaType.containedTypeOrUnknown(0);
            JavaType javaType6 = javaType.containedTypeOrUnknown(1);
            TypeDeserializer typeDeserializer = (TypeDeserializer)javaType6.getTypeHandler();
            if (typeDeserializer == null) {
                typeDeserializer = this.findTypeDeserializer(deserializationContext.getConfig(), javaType6);
            }
            JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType6.getValueHandler();
            KeyDeserializer keyDeserializer = (KeyDeserializer)javaType5.getValueHandler();
            return new MapEntryDeserializer(javaType, keyDeserializer, (JsonDeserializer<Object>)jsonDeserializer2, typeDeserializer);
        }
        String string = clazz.getName();
        if (clazz.isPrimitive() || string.startsWith("java.")) {
            jsonDeserializer = NumberDeserializers.find(clazz, string);
            if (jsonDeserializer == null) {
                jsonDeserializer = DateDeserializers.find(clazz, string);
            }
            if (jsonDeserializer != null) {
                return jsonDeserializer;
            }
        }
        if (clazz == TokenBuffer.class) {
            return new TokenBufferDeserializer();
        }
        jsonDeserializer = this.findOptionalStdDeserializer(deserializationContext, javaType, beanDescription);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        return JdkDeserializers.find(clazz, string);
    }

    protected JavaType _findRemappedType(DeserializationConfig deserializationConfig, Class<?> clazz) throws JsonMappingException {
        JavaType javaType = this.mapAbstractType(deserializationConfig, deserializationConfig.constructType(clazz));
        return javaType == null || javaType.hasRawClass(clazz) ? null : javaType;
    }

    protected JsonDeserializer<?> _findCustomTreeNodeDeserializer(Class<? extends JsonNode> clazz, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> jsonDeserializer = deserializers.findTreeNodeDeserializer(clazz, deserializationConfig, beanDescription);
            if (jsonDeserializer == null) continue;
            return jsonDeserializer;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomReferenceDeserializer(ReferenceType referenceType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> jsonDeserializer2 = deserializers.findReferenceDeserializer(referenceType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    protected JsonDeserializer<Object> _findCustomBeanDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<Object> jsonDeserializer = deserializers.findBeanDeserializer(javaType, deserializationConfig, beanDescription);
            if (jsonDeserializer == null) continue;
            return jsonDeserializer;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomArrayDeserializer(ArrayType arrayType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> jsonDeserializer2 = deserializers.findArrayDeserializer(arrayType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomCollectionDeserializer(CollectionType collectionType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> jsonDeserializer2 = deserializers.findCollectionDeserializer(collectionType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomCollectionLikeDeserializer(CollectionLikeType collectionLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> jsonDeserializer2 = deserializers.findCollectionLikeDeserializer(collectionLikeType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomEnumDeserializer(Class<?> clazz, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> jsonDeserializer = deserializers.findEnumDeserializer(clazz, deserializationConfig, beanDescription);
            if (jsonDeserializer == null) continue;
            return jsonDeserializer;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomMapDeserializer(MapType mapType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> jsonDeserializer2 = deserializers.findMapDeserializer(mapType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomMapLikeDeserializer(MapLikeType mapLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> jsonDeserializer2 = deserializers.findMapLikeDeserializer(mapLikeType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer);
            if (jsonDeserializer2 == null) continue;
            return jsonDeserializer2;
        }
        return null;
    }

    protected JsonDeserializer<Object> findDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) throws JsonMappingException {
        Object object;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (annotationIntrospector != null && (object = annotationIntrospector.findDeserializer(annotated)) != null) {
            return deserializationContext.deserializerInstance(annotated, object);
        }
        return null;
    }

    protected KeyDeserializer findKeyDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) throws JsonMappingException {
        Object object;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (annotationIntrospector != null && (object = annotationIntrospector.findKeyDeserializer(annotated)) != null) {
            return deserializationContext.keyDeserializerInstance(annotated, object);
        }
        return null;
    }

    protected JsonDeserializer<Object> findContentDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) throws JsonMappingException {
        Object object;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (annotationIntrospector != null && (object = annotationIntrospector.findContentDeserializer(annotated)) != null) {
            return deserializationContext.deserializerInstance(annotated, object);
        }
        return null;
    }

    protected JavaType resolveMemberAndTypeAnnotations(DeserializationContext deserializationContext, AnnotatedMember annotatedMember, JavaType javaType) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer;
        Object object;
        Object object2;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (annotationIntrospector == null) {
            return javaType;
        }
        if (javaType.isMapLikeType() && (object2 = javaType.getKeyType()) != null && (object = deserializationContext.keyDeserializerInstance(annotatedMember, jsonDeserializer = annotationIntrospector.findKeyDeserializer(annotatedMember))) != null) {
            javaType = ((MapLikeType)javaType).withKeyValueHandler(object);
            object2 = javaType.getKeyType();
        }
        if (javaType.hasContentType()) {
            object2 = annotationIntrospector.findContentDeserializer(annotatedMember);
            jsonDeserializer = deserializationContext.deserializerInstance(annotatedMember, object2);
            if (jsonDeserializer != null) {
                javaType = javaType.withContentValueHandler(jsonDeserializer);
            }
            if ((object = this.findPropertyContentTypeDeserializer(deserializationContext.getConfig(), javaType, annotatedMember)) != null) {
                javaType = javaType.withContentTypeHandler(object);
            }
        }
        if ((object2 = this.findPropertyTypeDeserializer(deserializationContext.getConfig(), javaType, annotatedMember)) != null) {
            javaType = javaType.withTypeHandler(object2);
        }
        javaType = annotationIntrospector.refineDeserializationType(deserializationContext.getConfig(), annotatedMember, javaType);
        return javaType;
    }

    protected EnumResolver constructEnumResolver(Class<?> clazz, DeserializationConfig deserializationConfig, AnnotatedMember annotatedMember) {
        if (annotatedMember != null) {
            if (deserializationConfig.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(annotatedMember.getMember(), deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            return EnumResolver.constructUsingMethod(deserializationConfig, clazz, annotatedMember);
        }
        return EnumResolver.constructFor(deserializationConfig, clazz);
    }

    protected boolean _hasCreatorAnnotation(DeserializationContext deserializationContext, Annotated annotated) {
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (annotationIntrospector != null) {
            JsonCreator.Mode mode = annotationIntrospector.findCreatorAnnotation(deserializationContext.getConfig(), annotated);
            return mode != null && mode != JsonCreator.Mode.DISABLED;
        }
        return false;
    }

    @Deprecated
    protected JavaType modifyTypeByAnnotation(DeserializationContext deserializationContext, Annotated annotated, JavaType javaType) throws JsonMappingException {
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (annotationIntrospector == null) {
            return javaType;
        }
        return annotationIntrospector.refineDeserializationType(deserializationContext.getConfig(), annotated, javaType);
    }

    @Deprecated
    protected JavaType resolveType(DeserializationContext deserializationContext, BeanDescription beanDescription, JavaType javaType, AnnotatedMember annotatedMember) throws JsonMappingException {
        return this.resolveMemberAndTypeAnnotations(deserializationContext, annotatedMember, javaType);
    }

    @Deprecated
    protected AnnotatedMethod _findJsonValueFor(DeserializationConfig deserializationConfig, JavaType javaType) {
        if (javaType == null) {
            return null;
        }
        BeanDescription beanDescription = deserializationConfig.introspect(javaType);
        return beanDescription.findJsonValueMethod();
    }

    protected static class CreatorCollectionState {
        public final DeserializationContext context;
        public final BeanDescription beanDesc;
        public final VisibilityChecker<?> vchecker;
        public final CreatorCollector creators;
        public final Map<AnnotatedWithParams, BeanPropertyDefinition[]> creatorParams;
        private List<CreatorCandidate> _implicitFactoryCandidates;
        private int _explicitFactoryCount;
        private List<CreatorCandidate> _implicitConstructorCandidates;
        private int _explicitConstructorCount;

        public CreatorCollectionState(DeserializationContext deserializationContext, BeanDescription beanDescription, VisibilityChecker<?> visibilityChecker, CreatorCollector creatorCollector, Map<AnnotatedWithParams, BeanPropertyDefinition[]> map) {
            this.context = deserializationContext;
            this.beanDesc = beanDescription;
            this.vchecker = visibilityChecker;
            this.creators = creatorCollector;
            this.creatorParams = map;
        }

        public AnnotationIntrospector annotationIntrospector() {
            return this.context.getAnnotationIntrospector();
        }

        public void addImplicitFactoryCandidate(CreatorCandidate creatorCandidate) {
            if (this._implicitFactoryCandidates == null) {
                this._implicitFactoryCandidates = new LinkedList<CreatorCandidate>();
            }
            this._implicitFactoryCandidates.add(creatorCandidate);
        }

        public void increaseExplicitFactoryCount() {
            ++this._explicitFactoryCount;
        }

        public boolean hasExplicitFactories() {
            return this._explicitFactoryCount > 0;
        }

        public boolean hasImplicitFactoryCandidates() {
            return this._implicitFactoryCandidates != null;
        }

        public List<CreatorCandidate> implicitFactoryCandidates() {
            return this._implicitFactoryCandidates;
        }

        public void addImplicitConstructorCandidate(CreatorCandidate creatorCandidate) {
            if (this._implicitConstructorCandidates == null) {
                this._implicitConstructorCandidates = new LinkedList<CreatorCandidate>();
            }
            this._implicitConstructorCandidates.add(creatorCandidate);
        }

        public void increaseExplicitConstructorCount() {
            ++this._explicitConstructorCount;
        }

        public boolean hasExplicitConstructors() {
            return this._explicitConstructorCount > 0;
        }

        public boolean hasImplicitConstructorCandidates() {
            return this._implicitConstructorCandidates != null;
        }

        public List<CreatorCandidate> implicitConstructorCandidates() {
            return this._implicitConstructorCandidates;
        }
    }

    protected static class ContainerDefaultMappings {
        static final HashMap<String, Class<? extends Collection>> _collectionFallbacks;
        static final HashMap<String, Class<? extends Map>> _mapFallbacks;

        protected ContainerDefaultMappings() {
        }

        public static Class<?> findCollectionFallback(JavaType javaType) {
            return _collectionFallbacks.get(javaType.getRawClass().getName());
        }

        public static Class<?> findMapFallback(JavaType javaType) {
            return _mapFallbacks.get(javaType.getRawClass().getName());
        }

        static {
            HashMap<String, Class> hashMap = new HashMap<String, Class>();
            Class clazz = ArrayList.class;
            Class<HashSet> clazz2 = HashSet.class;
            hashMap.put(Collection.class.getName(), clazz);
            hashMap.put(List.class.getName(), clazz);
            hashMap.put(Set.class.getName(), clazz2);
            hashMap.put(SortedSet.class.getName(), TreeSet.class);
            hashMap.put(Queue.class.getName(), LinkedList.class);
            hashMap.put(AbstractList.class.getName(), clazz);
            hashMap.put(AbstractSet.class.getName(), clazz2);
            hashMap.put(Deque.class.getName(), LinkedList.class);
            hashMap.put(NavigableSet.class.getName(), TreeSet.class);
            _collectionFallbacks = hashMap;
            hashMap = new HashMap();
            clazz = LinkedHashMap.class;
            hashMap.put(Map.class.getName(), clazz);
            hashMap.put(AbstractMap.class.getName(), clazz);
            hashMap.put(ConcurrentMap.class.getName(), ConcurrentHashMap.class);
            hashMap.put(SortedMap.class.getName(), TreeMap.class);
            hashMap.put(NavigableMap.class.getName(), TreeMap.class);
            hashMap.put(ConcurrentNavigableMap.class.getName(), ConcurrentSkipListMap.class);
            _mapFallbacks = hashMap;
        }
    }
}

