/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import com.fasterxml.jackson.core.util.JacksonFeature;

public final class JacksonFeatureSet<F extends JacksonFeature> {
    protected int _enabled;

    protected JacksonFeatureSet(int n) {
        this._enabled = n;
    }

    public static <F extends JacksonFeature> JacksonFeatureSet<F> fromDefaults(F[] FArray) {
        if (FArray.length > 31) {
            String string = FArray[0].getClass().getName();
            throw new IllegalArgumentException(String.format("Can not use type `%s` with JacksonFeatureSet: too many entries (%d > 31)", string, FArray.length));
        }
        int n = 0;
        for (F f : FArray) {
            if (!f.enabledByDefault()) continue;
            n |= f.getMask();
        }
        return new JacksonFeatureSet<F>(n);
    }

    public static <F extends JacksonFeature> JacksonFeatureSet<F> fromBitmask(int n) {
        return new JacksonFeatureSet<F>(n);
    }

    public JacksonFeatureSet<F> with(F f) {
        int n = this._enabled | f.getMask();
        return n == this._enabled ? this : new JacksonFeatureSet<F>(n);
    }

    public JacksonFeatureSet<F> without(F f) {
        int n = this._enabled & ~f.getMask();
        return n == this._enabled ? this : new JacksonFeatureSet<F>(n);
    }

    public boolean isEnabled(F f) {
        return (f.getMask() & this._enabled) != 0;
    }

    public int asBitmask() {
        return this._enabled;
    }
}

