/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.base.ParserBase;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.sym.CharsToNameCanonicalizer;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.core.util.TextBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class ReaderBasedJsonParser
extends ParserBase {
    private static final int FEAT_MASK_TRAILING_COMMA = JsonParser.Feature.ALLOW_TRAILING_COMMA.getMask();
    private static final int FEAT_MASK_LEADING_ZEROS = JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS.getMask();
    private static final int FEAT_MASK_NON_NUM_NUMBERS = JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS.getMask();
    private static final int FEAT_MASK_ALLOW_MISSING = JsonParser.Feature.ALLOW_MISSING_VALUES.getMask();
    private static final int FEAT_MASK_ALLOW_SINGLE_QUOTES = JsonParser.Feature.ALLOW_SINGLE_QUOTES.getMask();
    private static final int FEAT_MASK_ALLOW_UNQUOTED_NAMES = JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES.getMask();
    private static final int FEAT_MASK_ALLOW_JAVA_COMMENTS = JsonParser.Feature.ALLOW_COMMENTS.getMask();
    private static final int FEAT_MASK_ALLOW_YAML_COMMENTS = JsonParser.Feature.ALLOW_YAML_COMMENTS.getMask();
    protected static final int[] _icLatin1 = CharTypes.getInputCodeLatin1();
    protected Reader _reader;
    protected char[] _inputBuffer;
    protected boolean _bufferRecyclable;
    protected ObjectCodec _objectCodec;
    protected final CharsToNameCanonicalizer _symbols;
    protected final int _hashSeed;
    protected boolean _tokenIncomplete;
    protected long _nameStartOffset;
    protected int _nameStartRow;
    protected int _nameStartCol;

    public ReaderBasedJsonParser(IOContext iOContext, int n, Reader reader, ObjectCodec objectCodec, CharsToNameCanonicalizer charsToNameCanonicalizer, char[] cArray, int n2, int n3, boolean bl) {
        super(iOContext, n);
        this._reader = reader;
        this._objectCodec = objectCodec;
        this._inputBuffer = cArray;
        this._inputPtr = n2;
        this._inputEnd = n3;
        this._currInputRowStart = n2;
        this._currInputProcessed = -n2;
        this._symbols = charsToNameCanonicalizer;
        this._hashSeed = charsToNameCanonicalizer.hashSeed();
        this._bufferRecyclable = bl;
    }

    public ReaderBasedJsonParser(IOContext iOContext, int n, Reader reader, ObjectCodec objectCodec, CharsToNameCanonicalizer charsToNameCanonicalizer) {
        super(iOContext, n);
        this._reader = reader;
        this._inputBuffer = iOContext.allocTokenBuffer();
        this._inputPtr = 0;
        this._inputEnd = 0;
        this._objectCodec = objectCodec;
        this._symbols = charsToNameCanonicalizer;
        this._hashSeed = charsToNameCanonicalizer.hashSeed();
        this._bufferRecyclable = true;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    @Override
    public JacksonFeatureSet<StreamReadCapability> getReadCapabilities() {
        return JSON_READ_CAPABILITIES;
    }

    @Override
    public int releaseBuffered(Writer writer) throws IOException {
        int n = this._inputEnd - this._inputPtr;
        if (n < 1) {
            return 0;
        }
        int n2 = this._inputPtr;
        this._inputPtr += n;
        writer.write(this._inputBuffer, n2, n);
        return n;
    }

    @Override
    public Object getInputSource() {
        return this._reader;
    }

    @Deprecated
    protected char getNextChar(String string) throws IOException {
        return this.getNextChar(string, null);
    }

    protected char getNextChar(String string, JsonToken jsonToken) throws IOException {
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(string, jsonToken);
        }
        return this._inputBuffer[this._inputPtr++];
    }

    @Override
    protected void _closeInput() throws IOException {
        if (this._reader != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                this._reader.close();
            }
            this._reader = null;
        }
    }

    @Override
    protected void _releaseBuffers() throws IOException {
        char[] cArray;
        super._releaseBuffers();
        this._symbols.release();
        if (this._bufferRecyclable && (cArray = this._inputBuffer) != null) {
            this._inputBuffer = null;
            this._ioContext.releaseTokenBuffer(cArray);
        }
    }

    protected void _loadMoreGuaranteed() throws IOException {
        if (!this._loadMore()) {
            this._reportInvalidEOF();
        }
    }

    protected boolean _loadMore() throws IOException {
        if (this._reader != null) {
            int n = this._reader.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (n > 0) {
                int n2 = this._inputEnd;
                this._currInputProcessed += (long)n2;
                this._currInputRowStart -= n2;
                this._nameStartOffset -= (long)n2;
                this._inputPtr = 0;
                this._inputEnd = n;
                return true;
            }
            this._closeInput();
            if (n == 0) {
                throw new IOException("Reader returned 0 characters when trying to read " + this._inputEnd);
            }
        }
        return false;
    }

    @Override
    public final String getText() throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        return this._getText2(this._currToken);
    }

    @Override
    public int getText(Writer writer) throws IOException {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsToWriter(writer);
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            String string = this._parsingContext.getCurrentName();
            writer.write(string);
            return string.length();
        }
        if (jsonToken != null) {
            if (jsonToken.isNumeric()) {
                return this._textBuffer.contentsToWriter(writer);
            }
            char[] cArray = jsonToken.asCharArray();
            writer.write(cArray);
            return cArray.length;
        }
        return 0;
    }

    @Override
    public final String getValueAsString() throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        return super.getValueAsString(null);
    }

    @Override
    public final String getValueAsString(String string) throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        return super.getValueAsString(string);
    }

    protected final String _getText2(JsonToken jsonToken) {
        if (jsonToken == null) {
            return null;
        }
        switch (jsonToken.id()) {
            case 5: {
                return this._parsingContext.getCurrentName();
            }
            case 6: 
            case 7: 
            case 8: {
                return this._textBuffer.contentsAsString();
            }
        }
        return jsonToken.asString();
    }

    @Override
    public final char[] getTextCharacters() throws IOException {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    if (!this._nameCopied) {
                        String string = this._parsingContext.getCurrentName();
                        int n = string.length();
                        if (this._nameCopyBuffer == null) {
                            this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(n);
                        } else if (this._nameCopyBuffer.length < n) {
                            this._nameCopyBuffer = new char[n];
                        }
                        string.getChars(0, n, this._nameCopyBuffer, 0);
                        this._nameCopied = true;
                    }
                    return this._nameCopyBuffer;
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextBuffer();
                }
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    @Override
    public final int getTextLength() throws IOException {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    return this._parsingContext.getCurrentName().length();
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.size();
                }
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    @Override
    public final int getTextOffset() throws IOException {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    return 0;
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextOffset();
                }
            }
        }
        return 0;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException {
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT && this._binaryValue != null) {
            return this._binaryValue;
        }
        if (this._currToken != JsonToken.VALUE_STRING) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING or VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (this._tokenIncomplete) {
            try {
                this._binaryValue = this._decodeBase64(base64Variant);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this._constructError("Failed to decode VALUE_STRING as base64 (" + base64Variant + "): " + illegalArgumentException.getMessage());
            }
            this._tokenIncomplete = false;
        } else if (this._binaryValue == null) {
            ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
            this._decodeBase64(this.getText(), byteArrayBuilder, base64Variant);
            this._binaryValue = byteArrayBuilder.toByteArray();
        }
        return this._binaryValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream2) throws IOException {
        if (!this._tokenIncomplete || this._currToken != JsonToken.VALUE_STRING) {
            byte[] byArray = this.getBinaryValue(base64Variant);
            outputStream2.write(byArray);
            return byArray.length;
        }
        byte[] byArray = this._ioContext.allocBase64Buffer();
        try {
            int n = this._readBinary(base64Variant, outputStream2, byArray);
            return n;
        }
        finally {
            this._ioContext.releaseBase64Buffer(byArray);
        }
    }

    protected int _readBinary(Base64Variant base64Variant, OutputStream outputStream2, byte[] byArray) throws IOException {
        int n = 0;
        int n2 = byArray.length - 3;
        int n3 = 0;
        while (true) {
            char c;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) <= ' ') continue;
            int n4 = base64Variant.decodeBase64Char(c);
            if (n4 < 0) {
                if (c == '\"') break;
                n4 = this._decodeBase64Escape(base64Variant, c, 0);
                if (n4 < 0) continue;
            }
            if (n > n2) {
                n3 += n;
                outputStream2.write(byArray, 0, n);
                n = 0;
            }
            int n5 = n4;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n4 = base64Variant.decodeBase64Char(c = this._inputBuffer[this._inputPtr++])) < 0) {
                n4 = this._decodeBase64Escape(base64Variant, c, 1);
            }
            n5 = n5 << 6 | n4;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n4 = base64Variant.decodeBase64Char(c = this._inputBuffer[this._inputPtr++])) < 0) {
                if (n4 != -2) {
                    if (c == '\"') {
                        byArray[n++] = (byte)(n5 >>= 4);
                        if (!base64Variant.usesPadding()) break;
                        --this._inputPtr;
                        this._handleBase64MissingPadding(base64Variant);
                        break;
                    }
                    n4 = this._decodeBase64Escape(base64Variant, c, 2);
                }
                if (n4 == -2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._loadMoreGuaranteed();
                    }
                    if (!base64Variant.usesPaddingChar(c = this._inputBuffer[this._inputPtr++]) && this._decodeBase64Escape(base64Variant, c, 3) != -2) {
                        throw this.reportInvalidBase64Char(base64Variant, c, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byArray[n++] = (byte)(n5 >>= 4);
                    continue;
                }
            }
            n5 = n5 << 6 | n4;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n4 = base64Variant.decodeBase64Char(c = this._inputBuffer[this._inputPtr++])) < 0) {
                if (n4 != -2) {
                    if (c == '\"') {
                        byArray[n++] = (byte)((n5 >>= 2) >> 8);
                        byArray[n++] = (byte)n5;
                        if (!base64Variant.usesPadding()) break;
                        --this._inputPtr;
                        this._handleBase64MissingPadding(base64Variant);
                        break;
                    }
                    n4 = this._decodeBase64Escape(base64Variant, c, 3);
                }
                if (n4 == -2) {
                    byArray[n++] = (byte)((n5 >>= 2) >> 8);
                    byArray[n++] = (byte)n5;
                    continue;
                }
            }
            n5 = n5 << 6 | n4;
            byArray[n++] = (byte)(n5 >> 16);
            byArray[n++] = (byte)(n5 >> 8);
            byArray[n++] = (byte)n5;
        }
        this._tokenIncomplete = false;
        if (n > 0) {
            n3 += n;
            outputStream2.write(byArray, 0, n);
        }
        return n3;
    }

    @Override
    public final JsonToken nextToken() throws IOException {
        Object object;
        boolean bl;
        int n;
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nextAfterName();
        }
        this._numTypesValid = 0;
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return null;
        }
        this._binaryValue = null;
        if (n == 93 || n == 125) {
            this._closeScope(n);
            return this._currToken;
        }
        if (this._parsingContext.expectComma()) {
            n = this._skipComma(n);
            if ((this._features & FEAT_MASK_TRAILING_COMMA) != 0 && (n == 93 || n == 125)) {
                this._closeScope(n);
                return this._currToken;
            }
        }
        if (bl = this._parsingContext.inObject()) {
            this._updateNameLocation();
            object = n == 34 ? this._parseName() : this._handleOddName(n);
            this._parsingContext.setCurrentName((String)object);
            this._currToken = JsonToken.FIELD_NAME;
            n = this._skipColon();
        }
        this._updateLocation();
        switch (n) {
            case 34: {
                this._tokenIncomplete = true;
                object = JsonToken.VALUE_STRING;
                break;
            }
            case 91: {
                if (!bl) {
                    this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                }
                object = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                if (!bl) {
                    this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
                }
                object = JsonToken.START_OBJECT;
                break;
            }
            case 125: {
                this._reportUnexpectedChar(n, "expected a value");
            }
            case 116: {
                this._matchTrue();
                object = JsonToken.VALUE_TRUE;
                break;
            }
            case 102: {
                this._matchFalse();
                object = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchNull();
                object = JsonToken.VALUE_NULL;
                break;
            }
            case 45: {
                object = this._parseNegNumber();
                break;
            }
            case 46: {
                object = this._parseFloatThatStartsWithPeriod();
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                object = this._parsePosNumber(n);
                break;
            }
            default: {
                object = this._handleOddValue(n);
            }
        }
        if (bl) {
            this._nextToken = object;
            return this._currToken;
        }
        this._currToken = object;
        return object;
    }

    private final JsonToken _nextAfterName() {
        this._nameCopied = false;
        JsonToken jsonToken = this._nextToken;
        this._nextToken = null;
        if (jsonToken == JsonToken.START_ARRAY) {
            this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
        } else if (jsonToken == JsonToken.START_OBJECT) {
            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
        }
        this._currToken = jsonToken;
        return this._currToken;
    }

    @Override
    public void finishToken() throws IOException {
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            this._finishString();
        }
    }

    @Override
    public boolean nextFieldName(SerializableString serializableString) throws IOException {
        int n;
        char[] cArray;
        int n2;
        int n3;
        this._numTypesValid = 0;
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nextAfterName();
            return false;
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n3 = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return false;
        }
        this._binaryValue = null;
        if (n3 == 93 || n3 == 125) {
            this._closeScope(n3);
            return false;
        }
        if (this._parsingContext.expectComma()) {
            n3 = this._skipComma(n3);
            if ((this._features & FEAT_MASK_TRAILING_COMMA) != 0 && (n3 == 93 || n3 == 125)) {
                this._closeScope(n3);
                return false;
            }
        }
        if (!this._parsingContext.inObject()) {
            this._updateLocation();
            this._nextTokenNotInObject(n3);
            return false;
        }
        this._updateNameLocation();
        if (n3 == 34 && this._inputPtr + (n2 = (cArray = serializableString.asQuotedChars()).length) + 4 < this._inputEnd && this._inputBuffer[n = this._inputPtr + n2] == '\"') {
            int n4 = 0;
            int n5 = this._inputPtr;
            while (true) {
                if (n5 == n) {
                    this._parsingContext.setCurrentName(serializableString.getValue());
                    this._isNextTokenNameYes(this._skipColonFast(n5 + 1));
                    return true;
                }
                if (cArray[n4] != this._inputBuffer[n5]) break;
                ++n4;
                ++n5;
            }
        }
        return this._isNextTokenNameMaybe(n3, serializableString.getValue());
    }

    @Override
    public String nextFieldName() throws IOException {
        JsonToken jsonToken;
        int n;
        this._numTypesValid = 0;
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nextAfterName();
            return null;
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return null;
        }
        this._binaryValue = null;
        if (n == 93 || n == 125) {
            this._closeScope(n);
            return null;
        }
        if (this._parsingContext.expectComma()) {
            n = this._skipComma(n);
            if ((this._features & FEAT_MASK_TRAILING_COMMA) != 0 && (n == 93 || n == 125)) {
                this._closeScope(n);
                return null;
            }
        }
        if (!this._parsingContext.inObject()) {
            this._updateLocation();
            this._nextTokenNotInObject(n);
            return null;
        }
        this._updateNameLocation();
        String string = n == 34 ? this._parseName() : this._handleOddName(n);
        this._parsingContext.setCurrentName(string);
        this._currToken = JsonToken.FIELD_NAME;
        n = this._skipColon();
        this._updateLocation();
        if (n == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return string;
        }
        switch (n) {
            case 45: {
                jsonToken = this._parseNegNumber();
                break;
            }
            case 46: {
                jsonToken = this._parseFloatThatStartsWithPeriod();
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this._parsePosNumber(n);
                break;
            }
            case 102: {
                this._matchFalse();
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchNull();
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 116: {
                this._matchTrue();
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            default: {
                jsonToken = this._handleOddValue(n);
            }
        }
        this._nextToken = jsonToken;
        return string;
    }

    private final void _isNextTokenNameYes(int n) throws IOException {
        this._currToken = JsonToken.FIELD_NAME;
        this._updateLocation();
        switch (n) {
            case 34: {
                this._tokenIncomplete = true;
                this._nextToken = JsonToken.VALUE_STRING;
                return;
            }
            case 91: {
                this._nextToken = JsonToken.START_ARRAY;
                return;
            }
            case 123: {
                this._nextToken = JsonToken.START_OBJECT;
                return;
            }
            case 116: {
                this._matchToken("true", 1);
                this._nextToken = JsonToken.VALUE_TRUE;
                return;
            }
            case 102: {
                this._matchToken("false", 1);
                this._nextToken = JsonToken.VALUE_FALSE;
                return;
            }
            case 110: {
                this._matchToken("null", 1);
                this._nextToken = JsonToken.VALUE_NULL;
                return;
            }
            case 45: {
                this._nextToken = this._parseNegNumber();
                return;
            }
            case 46: {
                this._nextToken = this._parseFloatThatStartsWithPeriod();
                return;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this._nextToken = this._parsePosNumber(n);
                return;
            }
        }
        this._nextToken = this._handleOddValue(n);
    }

    protected boolean _isNextTokenNameMaybe(int n, String string) throws IOException {
        JsonToken jsonToken;
        String string2 = n == 34 ? this._parseName() : this._handleOddName(n);
        this._parsingContext.setCurrentName(string2);
        this._currToken = JsonToken.FIELD_NAME;
        n = this._skipColon();
        this._updateLocation();
        if (n == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return string.equals(string2);
        }
        switch (n) {
            case 45: {
                jsonToken = this._parseNegNumber();
                break;
            }
            case 46: {
                jsonToken = this._parseFloatThatStartsWithPeriod();
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this._parsePosNumber(n);
                break;
            }
            case 102: {
                this._matchFalse();
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchNull();
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 116: {
                this._matchTrue();
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            default: {
                jsonToken = this._handleOddValue(n);
            }
        }
        this._nextToken = jsonToken;
        return string.equals(string2);
    }

    private final JsonToken _nextTokenNotInObject(int n) throws IOException {
        if (n == 34) {
            this._tokenIncomplete = true;
            this._currToken = JsonToken.VALUE_STRING;
            return this._currToken;
        }
        switch (n) {
            case 91: {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_ARRAY;
                return this._currToken;
            }
            case 123: {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_OBJECT;
                return this._currToken;
            }
            case 116: {
                this._matchToken("true", 1);
                this._currToken = JsonToken.VALUE_TRUE;
                return this._currToken;
            }
            case 102: {
                this._matchToken("false", 1);
                this._currToken = JsonToken.VALUE_FALSE;
                return this._currToken;
            }
            case 110: {
                this._matchToken("null", 1);
                this._currToken = JsonToken.VALUE_NULL;
                return this._currToken;
            }
            case 45: {
                this._currToken = this._parseNegNumber();
                return this._currToken;
            }
            case 46: {
                this._currToken = this._parseFloatThatStartsWithPeriod();
                return this._currToken;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this._currToken = this._parsePosNumber(n);
                return this._currToken;
            }
            case 44: {
                if (this._parsingContext.inRoot() || (this._features & FEAT_MASK_ALLOW_MISSING) == 0) break;
                --this._inputPtr;
                this._currToken = JsonToken.VALUE_NULL;
                return this._currToken;
            }
        }
        this._currToken = this._handleOddValue(n);
        return this._currToken;
    }

    @Override
    public final String nextTextValue() throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_STRING) {
                if (this._tokenIncomplete) {
                    this._tokenIncomplete = false;
                    this._finishString();
                }
                return this._textBuffer.contentsAsString();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        return this.nextToken() == JsonToken.VALUE_STRING ? this.getText() : null;
    }

    @Override
    public final int nextIntValue(int n) throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getIntValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return n;
        }
        return this.nextToken() == JsonToken.VALUE_NUMBER_INT ? this.getIntValue() : n;
    }

    @Override
    public final long nextLongValue(long l) throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getLongValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return l;
        }
        return this.nextToken() == JsonToken.VALUE_NUMBER_INT ? this.getLongValue() : l;
    }

    @Override
    public final Boolean nextBooleanValue() throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (jsonToken == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        JsonToken jsonToken = this.nextToken();
        if (jsonToken != null) {
            int n = jsonToken.id();
            if (n == 9) {
                return Boolean.TRUE;
            }
            if (n == 10) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected final JsonToken _parseFloatThatStartsWithPeriod() throws IOException {
        if (!this.isEnabled(JsonReadFeature.ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature())) {
            return this._handleOddValue(46);
        }
        return this._parseFloat(46, this._inputPtr - 1, this._inputPtr, false, 0);
    }

    protected final JsonToken _parsePosNumber(int n) throws IOException {
        int n2 = this._inputPtr;
        int n3 = n2 - 1;
        int n4 = this._inputEnd;
        if (n == 48) {
            return this._parseNumber2(false, n3);
        }
        int n5 = 1;
        while (true) {
            if (n2 >= n4) {
                this._inputPtr = n3;
                return this._parseNumber2(false, n3);
            }
            if ((n = this._inputBuffer[n2++]) < 48 || n > 57) break;
            ++n5;
        }
        if (n == 46 || n == 101 || n == 69) {
            this._inputPtr = n2;
            return this._parseFloat(n, n3, n2, false, n5);
        }
        this._inputPtr = --n2;
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace(n);
        }
        int n6 = n2 - n3;
        this._textBuffer.resetWithShared(this._inputBuffer, n3, n6);
        return this.resetInt(false, n5);
    }

    private final JsonToken _parseFloat(int n, int n2, int n3, boolean bl, int n4) throws IOException {
        int n5 = this._inputEnd;
        int n6 = 0;
        if (n == 46) {
            while (true) {
                if (n3 >= n5) {
                    return this._parseNumber2(bl, n2);
                }
                if ((n = this._inputBuffer[n3++]) < 48 || n > 57) break;
                ++n6;
            }
            if (n6 == 0) {
                this.reportUnexpectedNumberChar(n, "Decimal point not followed by a digit");
            }
        }
        int n7 = 0;
        if (n == 101 || n == 69) {
            if (n3 >= n5) {
                this._inputPtr = n2;
                return this._parseNumber2(bl, n2);
            }
            if ((n = this._inputBuffer[n3++]) == 45 || n == 43) {
                if (n3 >= n5) {
                    this._inputPtr = n2;
                    return this._parseNumber2(bl, n2);
                }
                n = this._inputBuffer[n3++];
            }
            while (n <= 57 && n >= 48) {
                ++n7;
                if (n3 >= n5) {
                    this._inputPtr = n2;
                    return this._parseNumber2(bl, n2);
                }
                n = this._inputBuffer[n3++];
            }
            if (n7 == 0) {
                this.reportUnexpectedNumberChar(n, "Exponent indicator not followed by a digit");
            }
        }
        this._inputPtr = --n3;
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace(n);
        }
        int n8 = n3 - n2;
        this._textBuffer.resetWithShared(this._inputBuffer, n2, n8);
        return this.resetFloat(bl, n4, n6, n7);
    }

    protected final JsonToken _parseNegNumber() throws IOException {
        char c;
        int n = this._inputPtr;
        int n2 = n - 1;
        int n3 = this._inputEnd;
        if (n >= n3) {
            return this._parseNumber2(true, n2);
        }
        if ((c = this._inputBuffer[n++]) > '9' || c < '0') {
            this._inputPtr = n;
            return this._handleInvalidNumberStart(c, true);
        }
        if (c == '0') {
            return this._parseNumber2(true, n2);
        }
        int n4 = 1;
        while (true) {
            if (n >= n3) {
                return this._parseNumber2(true, n2);
            }
            if ((c = this._inputBuffer[n++]) < '0' || c > '9') break;
            ++n4;
        }
        if (c == '.' || c == 'e' || c == 'E') {
            this._inputPtr = n;
            return this._parseFloat(c, n2, n, true, n4);
        }
        this._inputPtr = --n;
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace(c);
        }
        int n5 = n - n2;
        this._textBuffer.resetWithShared(this._inputBuffer, n2, n5);
        return this.resetInt(true, n4);
    }

    private final JsonToken _parseNumber2(boolean bl, int n) throws IOException {
        char c;
        this._inputPtr = bl ? n + 1 : n;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n2 = 0;
        if (bl) {
            cArray[n2++] = 45;
        }
        int n3 = 0;
        char c2 = c = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.getNextChar("No digit following minus sign", JsonToken.VALUE_NUMBER_INT);
        if (c == '0') {
            c = this._verifyNoLeadingZeroes();
        }
        boolean bl2 = false;
        while (c >= '0' && c <= '9') {
            ++n3;
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = c;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                c = '\u0000';
                bl2 = true;
                break;
            }
            c = this._inputBuffer[this._inputPtr++];
        }
        if (n3 == 0) {
            return this._handleInvalidNumberStart(c, bl);
        }
        int n4 = 0;
        if (c == '.') {
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = c;
            while (true) {
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                    bl2 = true;
                    break;
                }
                if ((c = this._inputBuffer[this._inputPtr++]) < '0' || c > '9') break;
                ++n4;
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = c;
            }
            if (n4 == 0) {
                this.reportUnexpectedNumberChar(c, "Decimal point not followed by a digit");
            }
        }
        int n5 = 0;
        if (c == 'e' || c == 'E') {
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = c;
            char c3 = c = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.getNextChar("expected a digit for number exponent");
            if (c == '-' || c == '+') {
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = c;
                char c4 = c = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.getNextChar("expected a digit for number exponent");
            }
            while (c <= '9' && c >= '0') {
                ++n5;
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = c;
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                    bl2 = true;
                    break;
                }
                c = this._inputBuffer[this._inputPtr++];
            }
            if (n5 == 0) {
                this.reportUnexpectedNumberChar(c, "Exponent indicator not followed by a digit");
            }
        }
        if (!bl2) {
            --this._inputPtr;
            if (this._parsingContext.inRoot()) {
                this._verifyRootSpace(c);
            }
        }
        this._textBuffer.setCurrentLength(n2);
        return this.reset(bl, n3, n4, n5);
    }

    private final char _verifyNoLeadingZeroes() throws IOException {
        char c;
        if (this._inputPtr < this._inputEnd && ((c = this._inputBuffer[this._inputPtr]) < '0' || c > '9')) {
            return '0';
        }
        return this._verifyNLZ2();
    }

    private char _verifyNLZ2() throws IOException {
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            return '0';
        }
        char c = this._inputBuffer[this._inputPtr];
        if (c < '0' || c > '9') {
            return '0';
        }
        if ((this._features & FEAT_MASK_LEADING_ZEROS) == 0) {
            this.reportInvalidNumber("Leading zeroes not allowed");
        }
        ++this._inputPtr;
        if (c == '0') {
            while (this._inputPtr < this._inputEnd || this._loadMore()) {
                c = this._inputBuffer[this._inputPtr];
                if (c < '0' || c > '9') {
                    return '0';
                }
                ++this._inputPtr;
                if (c == '0') continue;
                break;
            }
        }
        return c;
    }

    protected JsonToken _handleInvalidNumberStart(int n, boolean bl) throws IOException {
        if (n == 73) {
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOFInValue(JsonToken.VALUE_NUMBER_INT);
            }
            if ((n = this._inputBuffer[this._inputPtr++]) == 78) {
                String string = bl ? "-INF" : "+INF";
                this._matchToken(string, 3);
                if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                    return this.resetAsNaN(string, bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token '" + string + "': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
            } else if (n == 110) {
                String string = bl ? "-Infinity" : "+Infinity";
                this._matchToken(string, 3);
                if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                    return this.resetAsNaN(string, bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token '" + string + "': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
            }
        }
        this.reportUnexpectedNumberChar(n, "expected digit (0-9) to follow minus sign, for valid numeric value");
        return null;
    }

    private final void _verifyRootSpace(int n) throws IOException {
        ++this._inputPtr;
        switch (n) {
            case 9: 
            case 32: {
                return;
            }
            case 13: {
                this._skipCR();
                return;
            }
            case 10: {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                return;
            }
        }
        this._reportMissingRootWS(n);
    }

    protected final String _parseName() throws IOException {
        int n;
        int n2;
        int n3 = this._hashSeed;
        int[] nArray = _icLatin1;
        for (n2 = this._inputPtr; n2 < this._inputEnd; ++n2) {
            n = this._inputBuffer[n2];
            if (n < nArray.length && nArray[n] != 0) {
                if (n != 34) break;
                int n4 = this._inputPtr;
                this._inputPtr = n2 + 1;
                return this._symbols.findSymbol(this._inputBuffer, n4, n2 - n4, n3);
            }
            n3 = n3 * 33 + n;
        }
        n = this._inputPtr;
        this._inputPtr = n2;
        return this._parseName2(n, n3, 34);
    }

    private String _parseName2(int n, int n2, int n3) throws IOException {
        this._textBuffer.resetWithShared(this._inputBuffer, n, this._inputPtr - n);
        char[] cArray = this._textBuffer.getCurrentSegment();
        int n4 = this._textBuffer.getCurrentSegmentSize();
        while (true) {
            char c;
            char c2;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(" in field name", JsonToken.FIELD_NAME);
            }
            if ((c2 = (c = this._inputBuffer[this._inputPtr++])) <= '\\') {
                if (c2 == '\\') {
                    c = this._decodeEscaped();
                } else if (c2 <= n3) {
                    if (c2 == n3) break;
                    if (c2 < ' ') {
                        this._throwUnquotedSpace(c2, "name");
                    }
                }
            }
            n2 = n2 * 33 + c;
            cArray[n4++] = c;
            if (n4 < cArray.length) continue;
            cArray = this._textBuffer.finishCurrentSegment();
            n4 = 0;
        }
        this._textBuffer.setCurrentLength(n4);
        TextBuffer textBuffer = this._textBuffer;
        char[] cArray2 = textBuffer.getTextBuffer();
        int n5 = textBuffer.getTextOffset();
        int n6 = textBuffer.size();
        return this._symbols.findSymbol(cArray2, n5, n6, n2);
    }

    protected String _handleOddName(int n) throws IOException {
        int n2;
        int[] nArray;
        int n3;
        boolean bl;
        if (n == 39 && (this._features & FEAT_MASK_ALLOW_SINGLE_QUOTES) != 0) {
            return this._parseAposName();
        }
        if ((this._features & FEAT_MASK_ALLOW_UNQUOTED_NAMES) == 0) {
            this._reportUnexpectedChar(n, "was expecting double-quote to start field name");
        }
        if (!(bl = n < (n3 = (nArray = CharTypes.getInputCodeLatin1JsNames()).length) ? nArray[n] == 0 : Character.isJavaIdentifierPart((char)n))) {
            this._reportUnexpectedChar(n, "was expecting either valid name character (for unquoted name) or double-quote (for quoted) to start field name");
        }
        int n4 = this._inputPtr;
        int n5 = this._hashSeed;
        int n6 = this._inputEnd;
        if (n4 < n6) {
            do {
                if ((n2 = this._inputBuffer[n4]) < n3) {
                    if (nArray[n2] != 0) {
                        int n7 = this._inputPtr - 1;
                        this._inputPtr = n4;
                        return this._symbols.findSymbol(this._inputBuffer, n7, n4 - n7, n5);
                    }
                } else if (!Character.isJavaIdentifierPart((char)n2)) {
                    int n8 = this._inputPtr - 1;
                    this._inputPtr = n4;
                    return this._symbols.findSymbol(this._inputBuffer, n8, n4 - n8, n5);
                }
                n5 = n5 * 33 + n2;
            } while (++n4 < n6);
        }
        n2 = this._inputPtr - 1;
        this._inputPtr = n4;
        return this._handleOddName2(n2, n5, nArray);
    }

    protected String _parseAposName() throws IOException {
        int n = this._inputPtr;
        int n2 = this._hashSeed;
        int n3 = this._inputEnd;
        if (n < n3) {
            int[] nArray = _icLatin1;
            int n4 = nArray.length;
            do {
                char c;
                if ((c = this._inputBuffer[n]) == '\'') {
                    int n5 = this._inputPtr;
                    this._inputPtr = n + 1;
                    return this._symbols.findSymbol(this._inputBuffer, n5, n - n5, n2);
                }
                if (c < n4 && nArray[c] != 0) break;
                n2 = n2 * 33 + c;
            } while (++n < n3);
        }
        int n6 = this._inputPtr;
        this._inputPtr = n;
        return this._parseName2(n6, n2, 39);
    }

    protected JsonToken _handleOddValue(int n) throws IOException {
        switch (n) {
            case 39: {
                if ((this._features & FEAT_MASK_ALLOW_SINGLE_QUOTES) == 0) break;
                return this._handleApos();
            }
            case 93: {
                if (!this._parsingContext.inArray()) break;
            }
            case 44: {
                if (this._parsingContext.inRoot() || (this._features & FEAT_MASK_ALLOW_MISSING) == 0) break;
                --this._inputPtr;
                return JsonToken.VALUE_NULL;
            }
            case 78: {
                this._matchToken("NaN", 1);
                if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                    return this.resetAsNaN("NaN", Double.NaN);
                }
                this._reportError("Non-standard token 'NaN': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
                break;
            }
            case 73: {
                this._matchToken("Infinity", 1);
                if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                    return this.resetAsNaN("Infinity", Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token 'Infinity': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
                break;
            }
            case 43: {
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                    this._reportInvalidEOFInValue(JsonToken.VALUE_NUMBER_INT);
                }
                return this._handleInvalidNumberStart(this._inputBuffer[this._inputPtr++], false);
            }
        }
        if (Character.isJavaIdentifierStart(n)) {
            this._reportInvalidToken("" + (char)n, this._validJsonTokenList());
        }
        this._reportUnexpectedChar(n, "expected a valid value " + this._validJsonValueList());
        return null;
    }

    protected JsonToken _handleApos() throws IOException {
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n = this._textBuffer.getCurrentSegmentSize();
        while (true) {
            char c;
            char c2;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(": was expecting closing quote for a string value", JsonToken.VALUE_STRING);
            }
            if ((c2 = (c = this._inputBuffer[this._inputPtr++])) <= '\\') {
                if (c2 == '\\') {
                    c = this._decodeEscaped();
                } else if (c2 <= '\'') {
                    if (c2 == '\'') break;
                    if (c2 < ' ') {
                        this._throwUnquotedSpace(c2, "string value");
                    }
                }
            }
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            cArray[n++] = c;
        }
        this._textBuffer.setCurrentLength(n);
        return JsonToken.VALUE_STRING;
    }

    private String _handleOddName2(int n, int n2, int[] nArray) throws IOException {
        char c;
        char c2;
        this._textBuffer.resetWithShared(this._inputBuffer, n, this._inputPtr - n);
        char[] cArray = this._textBuffer.getCurrentSegment();
        int n3 = this._textBuffer.getCurrentSegmentSize();
        int n4 = nArray.length;
        while ((this._inputPtr < this._inputEnd || this._loadMore()) && !((c2 = (c = this._inputBuffer[this._inputPtr])) < n4 ? nArray[c2] != 0 : !Character.isJavaIdentifierPart(c))) {
            ++this._inputPtr;
            n2 = n2 * 33 + c2;
            cArray[n3++] = c;
            if (n3 < cArray.length) continue;
            cArray = this._textBuffer.finishCurrentSegment();
            n3 = 0;
        }
        this._textBuffer.setCurrentLength(n3);
        TextBuffer textBuffer = this._textBuffer;
        char[] cArray2 = textBuffer.getTextBuffer();
        int n5 = textBuffer.getTextOffset();
        int n6 = textBuffer.size();
        return this._symbols.findSymbol(cArray2, n5, n6, n2);
    }

    @Override
    protected final void _finishString() throws IOException {
        int n = this._inputPtr;
        int n2 = this._inputEnd;
        if (n < n2) {
            int[] nArray = _icLatin1;
            int n3 = nArray.length;
            do {
                char c;
                if ((c = this._inputBuffer[n]) >= n3 || nArray[c] == 0) continue;
                if (c != '\"') break;
                this._textBuffer.resetWithShared(this._inputBuffer, this._inputPtr, n - this._inputPtr);
                this._inputPtr = n + 1;
                return;
            } while (++n < n2);
        }
        this._textBuffer.resetWithCopy(this._inputBuffer, this._inputPtr, n - this._inputPtr);
        this._inputPtr = n;
        this._finishString2();
    }

    protected void _finishString2() throws IOException {
        char[] cArray = this._textBuffer.getCurrentSegment();
        int n = this._textBuffer.getCurrentSegmentSize();
        int[] nArray = _icLatin1;
        int n2 = nArray.length;
        while (true) {
            char c;
            char c2;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(": was expecting closing quote for a string value", JsonToken.VALUE_STRING);
            }
            if ((c2 = (c = this._inputBuffer[this._inputPtr++])) < n2 && nArray[c2] != 0) {
                if (c2 == '\"') break;
                if (c2 == '\\') {
                    c = this._decodeEscaped();
                } else if (c2 < ' ') {
                    this._throwUnquotedSpace(c2, "string value");
                }
            }
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            cArray[n++] = c;
        }
        this._textBuffer.setCurrentLength(n);
    }

    protected final void _skipString() throws IOException {
        this._tokenIncomplete = false;
        int n = this._inputPtr;
        int n2 = this._inputEnd;
        char[] cArray = this._inputBuffer;
        while (true) {
            char c;
            char c2;
            if (n >= n2) {
                this._inputPtr = n;
                if (!this._loadMore()) {
                    this._reportInvalidEOF(": was expecting closing quote for a string value", JsonToken.VALUE_STRING);
                }
                n = this._inputPtr;
                n2 = this._inputEnd;
            }
            if ((c2 = (c = cArray[n++])) > '\\') continue;
            if (c2 == '\\') {
                this._inputPtr = n;
                this._decodeEscaped();
                n = this._inputPtr;
                n2 = this._inputEnd;
                continue;
            }
            if (c2 > '\"') continue;
            if (c2 == '\"') break;
            if (c2 >= ' ') continue;
            this._inputPtr = n;
            this._throwUnquotedSpace(c2, "string value");
        }
        this._inputPtr = n;
    }

    protected final void _skipCR() throws IOException {
        if ((this._inputPtr < this._inputEnd || this._loadMore()) && this._inputBuffer[this._inputPtr] == '\n') {
            ++this._inputPtr;
        }
        ++this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    private final int _skipColon() throws IOException {
        if (this._inputPtr + 4 >= this._inputEnd) {
            return this._skipColon2(false);
        }
        char c = this._inputBuffer[this._inputPtr];
        if (c == ':') {
            char c2;
            if ((c2 = this._inputBuffer[++this._inputPtr]) > ' ') {
                if (c2 == '/' || c2 == '#') {
                    return this._skipColon2(true);
                }
                ++this._inputPtr;
                return c2;
            }
            if ((c2 == ' ' || c2 == '\t') && (c2 = this._inputBuffer[++this._inputPtr]) > ' ') {
                if (c2 == '/' || c2 == '#') {
                    return this._skipColon2(true);
                }
                ++this._inputPtr;
                return c2;
            }
            return this._skipColon2(true);
        }
        if (c == ' ' || c == '\t') {
            c = this._inputBuffer[++this._inputPtr];
        }
        if (c == ':') {
            char c3;
            if ((c3 = this._inputBuffer[++this._inputPtr]) > ' ') {
                if (c3 == '/' || c3 == '#') {
                    return this._skipColon2(true);
                }
                ++this._inputPtr;
                return c3;
            }
            if ((c3 == ' ' || c3 == '\t') && (c3 = this._inputBuffer[++this._inputPtr]) > ' ') {
                if (c3 == '/' || c3 == '#') {
                    return this._skipColon2(true);
                }
                ++this._inputPtr;
                return c3;
            }
            return this._skipColon2(true);
        }
        return this._skipColon2(false);
    }

    private final int _skipColon2(boolean bl) throws IOException {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            char c;
            if ((c = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (c == '/') {
                    this._skipComment();
                    continue;
                }
                if (c == '#' && this._skipYAMLComment()) continue;
                if (bl) {
                    return c;
                }
                if (c != ':') {
                    this._reportUnexpectedChar(c, "was expecting a colon to separate field name and value");
                }
                bl = true;
                continue;
            }
            if (c >= ' ') continue;
            if (c == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (c == '\r') {
                this._skipCR();
                continue;
            }
            if (c == '\t') continue;
            this._throwInvalidSpace(c);
        }
        this._reportInvalidEOF(" within/between " + this._parsingContext.typeDesc() + " entries", null);
        return -1;
    }

    private final int _skipColonFast(int n) throws IOException {
        boolean bl;
        char c;
        if ((c = this._inputBuffer[n++]) == ':') {
            if ((c = this._inputBuffer[n++]) > ' ') {
                if (c != '/' && c != '#') {
                    this._inputPtr = n;
                    return c;
                }
            } else if ((c == ' ' || c == '\t') && (c = this._inputBuffer[n++]) > ' ' && c != '/' && c != '#') {
                this._inputPtr = n;
                return c;
            }
            this._inputPtr = n - 1;
            return this._skipColon2(true);
        }
        if (c == ' ' || c == '\t') {
            c = this._inputBuffer[n++];
        }
        boolean bl2 = bl = c == ':';
        if (bl) {
            if ((c = this._inputBuffer[n++]) > ' ') {
                if (c != '/' && c != '#') {
                    this._inputPtr = n;
                    return c;
                }
            } else if ((c == ' ' || c == '\t') && (c = this._inputBuffer[n++]) > ' ' && c != '/' && c != '#') {
                this._inputPtr = n;
                return c;
            }
        }
        this._inputPtr = n - 1;
        return this._skipColon2(bl);
    }

    private final int _skipComma(int n) throws IOException {
        if (n != 44) {
            this._reportUnexpectedChar(n, "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries");
        }
        while (this._inputPtr < this._inputEnd) {
            if ((n = this._inputBuffer[this._inputPtr++]) > 32) {
                if (n == 47 || n == 35) {
                    --this._inputPtr;
                    return this._skipAfterComma2();
                }
                return n;
            }
            if (n >= 32) continue;
            if (n == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (n == 13) {
                this._skipCR();
                continue;
            }
            if (n == 9) continue;
            this._throwInvalidSpace(n);
        }
        return this._skipAfterComma2();
    }

    private final int _skipAfterComma2() throws IOException {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            char c;
            if ((c = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (c == '/') {
                    this._skipComment();
                    continue;
                }
                if (c == '#' && this._skipYAMLComment()) continue;
                return c;
            }
            if (c >= ' ') continue;
            if (c == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (c == '\r') {
                this._skipCR();
                continue;
            }
            if (c == '\t') continue;
            this._throwInvalidSpace(c);
        }
        throw this._constructError("Unexpected end-of-input within/between " + this._parsingContext.typeDesc() + " entries");
    }

    private final int _skipWSOrEnd() throws IOException {
        char c;
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            return this._eofAsNextChar();
        }
        if ((c = this._inputBuffer[this._inputPtr++]) > ' ') {
            if (c == '/' || c == '#') {
                --this._inputPtr;
                return this._skipWSOrEnd2();
            }
            return c;
        }
        if (c != ' ') {
            if (c == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
            } else if (c == '\r') {
                this._skipCR();
            } else if (c != '\t') {
                this._throwInvalidSpace(c);
            }
        }
        while (this._inputPtr < this._inputEnd) {
            if ((c = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (c == '/' || c == '#') {
                    --this._inputPtr;
                    return this._skipWSOrEnd2();
                }
                return c;
            }
            if (c == ' ') continue;
            if (c == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (c == '\r') {
                this._skipCR();
                continue;
            }
            if (c == '\t') continue;
            this._throwInvalidSpace(c);
        }
        return this._skipWSOrEnd2();
    }

    private int _skipWSOrEnd2() throws IOException {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            char c;
            if ((c = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (c == '/') {
                    this._skipComment();
                    continue;
                }
                if (c == '#' && this._skipYAMLComment()) continue;
                return c;
            }
            if (c == ' ') continue;
            if (c == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (c == '\r') {
                this._skipCR();
                continue;
            }
            if (c == '\t') continue;
            this._throwInvalidSpace(c);
        }
        return this._eofAsNextChar();
    }

    private void _skipComment() throws IOException {
        char c;
        if ((this._features & FEAT_MASK_ALLOW_JAVA_COMMENTS) == 0) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(" in a comment", null);
        }
        if ((c = this._inputBuffer[this._inputPtr++]) == '/') {
            this._skipLine();
        } else if (c == '*') {
            this._skipCComment();
        } else {
            this._reportUnexpectedChar(c, "was expecting either '*' or '/' for a comment");
        }
    }

    private void _skipCComment() throws IOException {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            char c;
            if ((c = this._inputBuffer[this._inputPtr++]) > '*') continue;
            if (c == '*') {
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) break;
                if (this._inputBuffer[this._inputPtr] != '/') continue;
                ++this._inputPtr;
                return;
            }
            if (c >= ' ') continue;
            if (c == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (c == '\r') {
                this._skipCR();
                continue;
            }
            if (c == '\t') continue;
            this._throwInvalidSpace(c);
        }
        this._reportInvalidEOF(" in a comment", null);
    }

    private boolean _skipYAMLComment() throws IOException {
        if ((this._features & FEAT_MASK_ALLOW_YAML_COMMENTS) == 0) {
            return false;
        }
        this._skipLine();
        return true;
    }

    private void _skipLine() throws IOException {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            char c;
            if ((c = this._inputBuffer[this._inputPtr++]) >= ' ') continue;
            if (c == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                break;
            }
            if (c == '\r') {
                this._skipCR();
                break;
            }
            if (c == '\t') continue;
            this._throwInvalidSpace(c);
        }
    }

    @Override
    protected char _decodeEscaped() throws IOException {
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(" in character escape sequence", JsonToken.VALUE_STRING);
        }
        char c = this._inputBuffer[this._inputPtr++];
        switch (c) {
            case 'b': {
                return '\b';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 'r': {
                return '\r';
            }
            case '\"': 
            case '/': 
            case '\\': {
                return c;
            }
            case 'u': {
                break;
            }
            default: {
                return this._handleUnrecognizedCharacterEscape(c);
            }
        }
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            char c2;
            int n2;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(" in character escape sequence", JsonToken.VALUE_STRING);
            }
            if ((n2 = CharTypes.charToHex(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                this._reportUnexpectedChar(c2, "expected a hex-digit for character escape sequence");
            }
            n = n << 4 | n2;
        }
        return (char)n;
    }

    private final void _matchTrue() throws IOException {
        char c;
        char[] cArray;
        int n = this._inputPtr;
        if (n + 3 < this._inputEnd && (cArray = this._inputBuffer)[n] == 'r' && cArray[++n] == 'u' && cArray[++n] == 'e' && ((c = cArray[++n]) < '0' || c == ']' || c == '}')) {
            this._inputPtr = n;
            return;
        }
        this._matchToken("true", 1);
    }

    private final void _matchFalse() throws IOException {
        char c;
        char[] cArray;
        int n = this._inputPtr;
        if (n + 4 < this._inputEnd && (cArray = this._inputBuffer)[n] == 'a' && cArray[++n] == 'l' && cArray[++n] == 's' && cArray[++n] == 'e' && ((c = cArray[++n]) < '0' || c == ']' || c == '}')) {
            this._inputPtr = n;
            return;
        }
        this._matchToken("false", 1);
    }

    private final void _matchNull() throws IOException {
        char c;
        char[] cArray;
        int n = this._inputPtr;
        if (n + 3 < this._inputEnd && (cArray = this._inputBuffer)[n] == 'u' && cArray[++n] == 'l' && cArray[++n] == 'l' && ((c = cArray[++n]) < '0' || c == ']' || c == '}')) {
            this._inputPtr = n;
            return;
        }
        this._matchToken("null", 1);
    }

    protected final void _matchToken(String string, int n) throws IOException {
        int n2 = string.length();
        if (this._inputPtr + n2 >= this._inputEnd) {
            this._matchToken2(string, n);
            return;
        }
        do {
            if (this._inputBuffer[this._inputPtr] != string.charAt(n)) {
                this._reportInvalidToken(string.substring(0, n));
            }
            ++this._inputPtr;
        } while (++n < n2);
        char c = this._inputBuffer[this._inputPtr];
        if (c >= '0' && c != ']' && c != '}') {
            this._checkMatchEnd(string, n, c);
        }
    }

    private final void _matchToken2(String string, int n) throws IOException {
        int n2 = string.length();
        do {
            if (this._inputPtr >= this._inputEnd && !this._loadMore() || this._inputBuffer[this._inputPtr] != string.charAt(n)) {
                this._reportInvalidToken(string.substring(0, n));
            }
            ++this._inputPtr;
        } while (++n < n2);
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            return;
        }
        char c = this._inputBuffer[this._inputPtr];
        if (c >= '0' && c != ']' && c != '}') {
            this._checkMatchEnd(string, n, c);
        }
    }

    private final void _checkMatchEnd(String string, int n, int n2) throws IOException {
        char c = (char)n2;
        if (Character.isJavaIdentifierPart(c)) {
            this._reportInvalidToken(string.substring(0, n));
        }
    }

    protected byte[] _decodeBase64(Base64Variant base64Variant) throws IOException {
        ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
        while (true) {
            char c;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) <= ' ') continue;
            int n = base64Variant.decodeBase64Char(c);
            if (n < 0) {
                if (c == '\"') {
                    return byteArrayBuilder.toByteArray();
                }
                n = this._decodeBase64Escape(base64Variant, c, 0);
                if (n < 0) continue;
            }
            int n2 = n;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n = base64Variant.decodeBase64Char(c = this._inputBuffer[this._inputPtr++])) < 0) {
                n = this._decodeBase64Escape(base64Variant, c, 1);
            }
            n2 = n2 << 6 | n;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n = base64Variant.decodeBase64Char(c = this._inputBuffer[this._inputPtr++])) < 0) {
                if (n != -2) {
                    if (c == '\"') {
                        byteArrayBuilder.append(n2 >>= 4);
                        if (base64Variant.usesPadding()) {
                            --this._inputPtr;
                            this._handleBase64MissingPadding(base64Variant);
                        }
                        return byteArrayBuilder.toByteArray();
                    }
                    n = this._decodeBase64Escape(base64Variant, c, 2);
                }
                if (n == -2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._loadMoreGuaranteed();
                    }
                    if (!base64Variant.usesPaddingChar(c = this._inputBuffer[this._inputPtr++]) && this._decodeBase64Escape(base64Variant, c, 3) != -2) {
                        throw this.reportInvalidBase64Char(base64Variant, c, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byteArrayBuilder.append(n2 >>= 4);
                    continue;
                }
            }
            n2 = n2 << 6 | n;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n = base64Variant.decodeBase64Char(c = this._inputBuffer[this._inputPtr++])) < 0) {
                if (n != -2) {
                    if (c == '\"') {
                        byteArrayBuilder.appendTwoBytes(n2 >>= 2);
                        if (base64Variant.usesPadding()) {
                            --this._inputPtr;
                            this._handleBase64MissingPadding(base64Variant);
                        }
                        return byteArrayBuilder.toByteArray();
                    }
                    n = this._decodeBase64Escape(base64Variant, c, 3);
                }
                if (n == -2) {
                    byteArrayBuilder.appendTwoBytes(n2 >>= 2);
                    continue;
                }
            }
            n2 = n2 << 6 | n;
            byteArrayBuilder.appendThreeBytes(n2);
        }
    }

    @Override
    public JsonLocation getTokenLocation() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            long l = this._currInputProcessed + (this._nameStartOffset - 1L);
            return new JsonLocation(this._contentReference(), -1L, l, this._nameStartRow, this._nameStartCol);
        }
        return new JsonLocation(this._contentReference(), -1L, this._tokenInputTotal - 1L, this._tokenInputRow, this._tokenInputCol);
    }

    @Override
    public JsonLocation getCurrentLocation() {
        int n = this._inputPtr - this._currInputRowStart + 1;
        return new JsonLocation(this._contentReference(), -1L, this._currInputProcessed + (long)this._inputPtr, this._currInputRow, n);
    }

    private final void _updateLocation() {
        int n = this._inputPtr;
        this._tokenInputTotal = this._currInputProcessed + (long)n;
        this._tokenInputRow = this._currInputRow;
        this._tokenInputCol = n - this._currInputRowStart;
    }

    private final void _updateNameLocation() {
        int n = this._inputPtr;
        this._nameStartOffset = n;
        this._nameStartRow = this._currInputRow;
        this._nameStartCol = n - this._currInputRowStart;
    }

    protected void _reportInvalidToken(String string) throws IOException {
        this._reportInvalidToken(string, this._validJsonTokenList());
    }

    protected void _reportInvalidToken(String string, String string2) throws IOException {
        char c;
        StringBuilder stringBuilder = new StringBuilder(string);
        while ((this._inputPtr < this._inputEnd || this._loadMore()) && Character.isJavaIdentifierPart(c = this._inputBuffer[this._inputPtr])) {
            ++this._inputPtr;
            stringBuilder.append(c);
            if (stringBuilder.length() < 256) continue;
            stringBuilder.append("...");
            break;
        }
        this._reportError("Unrecognized token '%s': was expecting %s", stringBuilder, string2);
    }

    private void _closeScope(int n) throws JsonParseException {
        if (n == 93) {
            this._updateLocation();
            if (!this._parsingContext.inArray()) {
                this._reportMismatchedEndMarker(n, '}');
            }
            this._parsingContext = this._parsingContext.clearAndGetParent();
            this._currToken = JsonToken.END_ARRAY;
        }
        if (n == 125) {
            this._updateLocation();
            if (!this._parsingContext.inObject()) {
                this._reportMismatchedEndMarker(n, ']');
            }
            this._parsingContext = this._parsingContext.clearAndGetParent();
            this._currToken = JsonToken.END_OBJECT;
        }
    }
}

