/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.SdkClientException;
import com.amazonaws.util.Base64;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.StringUtils;
import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Stack;

public class XMLWriter {
    private static final String PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private final Writer writer;
    private final String xmlns;
    private Stack<String> elementStack = new Stack();
    private boolean rootElement = true;

    public XMLWriter(Writer writer) {
        this(writer, null);
    }

    public XMLWriter(Writer writer, String string) {
        this.writer = writer;
        this.xmlns = string;
        this.append(PROLOG);
    }

    public XMLWriter startElement(String string) {
        this.append("<" + string);
        if (this.rootElement && this.xmlns != null) {
            this.append(" xmlns=\"" + this.xmlns + "\"");
            this.rootElement = false;
        }
        this.append(">");
        this.elementStack.push(string);
        return this;
    }

    public XMLWriter endElement() {
        String string = this.elementStack.pop();
        this.append("</" + string + ">");
        return this;
    }

    public XMLWriter value(String string) {
        this.append(this.escapeXMLEntities(string));
        return this;
    }

    public XMLWriter value(ByteBuffer byteBuffer) {
        this.append(this.escapeXMLEntities(Base64.encodeAsString(BinaryUtils.copyBytesFrom(byteBuffer))));
        return this;
    }

    public XMLWriter value(Date date) {
        this.append(this.escapeXMLEntities(StringUtils.fromDate(date)));
        return this;
    }

    public XMLWriter value(Object object) {
        this.append(this.escapeXMLEntities(object.toString()));
        return this;
    }

    private void append(String string) {
        try {
            this.writer.append(string);
        }
        catch (IOException iOException) {
            throw new SdkClientException("Unable to write XML document", iOException);
        }
    }

    private String escapeXMLEntities(String string) {
        if (string.contains("&")) {
            string = string.replace("&quot;", "\"");
            string = string.replace("&apos;", "'");
            string = string.replace("&lt;", "<");
            string = string.replace("&gt;", ">");
            string = string.replace("&amp;", "&");
        }
        string = string.replace("&", "&amp;");
        string = string.replace("\"", "&quot;");
        string = string.replace("'", "&apos;");
        string = string.replace("<", "&lt;");
        string = string.replace(">", "&gt;");
        return string;
    }
}

