/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.internal.config.InternalConfig;
import com.amazonaws.util.ClassLoaderHelper;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.StringUtils;
import java.io.InputStream;
import java.util.Properties;
import java.util.jar.JarInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class VersionInfoUtils {
    static final String VERSION_INFO_FILE = "/com/amazonaws/sdk/versionInfo.properties";
    private static volatile String version;
    private static volatile String platform;
    private static volatile String userAgent;
    private static final Log log;
    private static final String UNKNOWN = "unknown";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getVersion() {
        if (version != null) return version;
        Class<VersionInfoUtils> clazz = VersionInfoUtils.class;
        synchronized (VersionInfoUtils.class) {
            if (version != null) return version;
            VersionInfoUtils.initializeVersion();
            // ** MonitorExit[var0] (shouldn't be in output)
            return version;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getPlatform() {
        if (platform != null) return platform;
        Class<VersionInfoUtils> clazz = VersionInfoUtils.class;
        synchronized (VersionInfoUtils.class) {
            if (platform != null) return platform;
            VersionInfoUtils.initializeVersion();
            // ** MonitorExit[var0] (shouldn't be in output)
            return platform;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getUserAgent() {
        if (userAgent != null) return userAgent;
        Class<VersionInfoUtils> clazz = VersionInfoUtils.class;
        synchronized (VersionInfoUtils.class) {
            if (userAgent != null) return userAgent;
            VersionInfoUtils.initializeUserAgent();
            // ** MonitorExit[var0] (shouldn't be in output)
            return userAgent;
        }
    }

    private static void initializeVersion() {
        InputStream inputStream2 = ClassLoaderHelper.getResourceAsStream(VERSION_INFO_FILE, true, VersionInfoUtils.class);
        Properties properties = new Properties();
        try {
            if (inputStream2 == null) {
                throw new Exception("/com/amazonaws/sdk/versionInfo.properties not found on classpath");
            }
            properties.load(inputStream2);
            version = properties.getProperty("version");
            platform = properties.getProperty("platform");
        }
        catch (Exception exception) {
            log.info("Unable to load version information for the running SDK: " + exception.getMessage());
            version = "unknown-version";
            platform = "java";
        }
        finally {
            IOUtils.closeQuietly(inputStream2, log);
        }
    }

    private static void initializeUserAgent() {
        userAgent = VersionInfoUtils.userAgent();
    }

    static String userAgent() {
        String string = InternalConfig.Factory.getInternalConfig().getUserAgentTemplate();
        if (string == null) {
            return "aws-sdk-java";
        }
        if ((string = string.replace("{platform}", StringUtils.lowerCase(VersionInfoUtils.getPlatform())).replace("{version}", VersionInfoUtils.getVersion()).replace("{os.name}", VersionInfoUtils.replaceSpaces(System.getProperty("os.name"))).replace("{os.version}", VersionInfoUtils.replaceSpaces(System.getProperty("os.version"))).replace("{java.vm.name}", VersionInfoUtils.replaceSpaces(System.getProperty("java.vm.name"))).replace("{java.vm.version}", VersionInfoUtils.replaceSpaces(System.getProperty("java.vm.version"))).replace("{java.version}", VersionInfoUtils.replaceSpaces(System.getProperty("java.version"))).replace("{java.vendor}", VersionInfoUtils.replaceSpaces(System.getProperty("java.vendor")))).contains("{additional.languages}")) {
            string = string.replace("{additional.languages}", VersionInfoUtils.getAdditionalJvmLanguages());
        }
        String string2 = System.getProperty("user.language");
        String string3 = System.getProperty("user.region");
        String string4 = "";
        if (string2 != null && string3 != null) {
            string4 = " " + VersionInfoUtils.replaceSpaces(string2) + "_" + VersionInfoUtils.replaceSpaces(string3);
        }
        string = string.replace("{language.and.region}", string4);
        return string;
    }

    private static String replaceSpaces(String string) {
        return string == null ? UNKNOWN : string.replace(' ', '_');
    }

    private static String getAdditionalJvmLanguages() {
        StringBuilder stringBuilder = new StringBuilder();
        VersionInfoUtils.concat(stringBuilder, VersionInfoUtils.scalaVersion(), " ");
        VersionInfoUtils.concat(stringBuilder, VersionInfoUtils.clojureVersion(), " ");
        VersionInfoUtils.concat(stringBuilder, VersionInfoUtils.groovyVersion(), " ");
        VersionInfoUtils.concat(stringBuilder, VersionInfoUtils.jythonVersion(), " ");
        VersionInfoUtils.concat(stringBuilder, VersionInfoUtils.jrubyVersion(), " ");
        VersionInfoUtils.concat(stringBuilder, VersionInfoUtils.kotlinVersion(), " ");
        return stringBuilder.toString();
    }

    private static String scalaVersion() {
        return VersionInfoUtils.languageVersion("scala", "scala.util.Properties", "versionNumberString", true);
    }

    private static String clojureVersion() {
        return VersionInfoUtils.languageVersion("clojure", "clojure.core$clojure_version", "invokeStatic", true);
    }

    private static String groovyVersion() {
        return VersionInfoUtils.languageVersion("groovy", "groovy.lang.GroovySystem", "getVersion", true);
    }

    private static String jythonVersion() {
        return VersionInfoUtils.languageVersion("jython", "org.python.Version", "PY_VERSION", false);
    }

    private static String jrubyVersion() {
        return VersionInfoUtils.languageVersion("jruby", "org.jruby.runtime.Constants", "VERSION", false);
    }

    private static String kotlinVersion() {
        String string = VersionInfoUtils.kotlinVersionByClass();
        return string.equals("") ? VersionInfoUtils.kotlinVersionByJar() : string;
    }

    private static String kotlinVersionByClass() {
        StringBuilder stringBuilder;
        block3: {
            stringBuilder = new StringBuilder("");
            try {
                Class<?> clazz = Class.forName("kotlin.KotlinVersion");
                stringBuilder.append("kotlin");
                String string = clazz.getField("CURRENT").get(null).toString();
                VersionInfoUtils.concat(stringBuilder, string, "/");
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception exception) {
                if (!log.isTraceEnabled()) break block3;
                log.trace("Exception attempting to get Kotlin version.", exception);
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String kotlinVersionByJar() {
        StringBuilder stringBuilder = new StringBuilder("");
        JarInputStream jarInputStream = null;
        try {
            Class<?> clazz = Class.forName("kotlin.Unit");
            stringBuilder.append("kotlin");
            jarInputStream = new JarInputStream(clazz.getProtectionDomain().getCodeSource().getLocation().openStream());
            String string = jarInputStream.getManifest().getMainAttributes().getValue("Implementation-Version");
            VersionInfoUtils.concat(stringBuilder, string, "/");
            IOUtils.closeQuietly(jarInputStream, log);
        }
        catch (ClassNotFoundException classNotFoundException) {
            IOUtils.closeQuietly(jarInputStream, log);
        }
        catch (Exception exception) {
            if (log.isTraceEnabled()) {
                log.trace("Exception attempting to get Kotlin version.", exception);
            }
        }
        finally {
            IOUtils.closeQuietly(jarInputStream, log);
        }
        return stringBuilder.toString();
    }

    private static String languageVersion(String string, String string2, String string3, boolean bl) {
        StringBuilder stringBuilder;
        block3: {
            stringBuilder = new StringBuilder();
            try {
                Class<?> clazz = Class.forName(string2);
                stringBuilder.append(string);
                String string4 = bl ? (String)clazz.getMethod(string3, new Class[0]).invoke(null, new Object[0]) : (String)clazz.getField(string3).get(null);
                VersionInfoUtils.concat(stringBuilder, string4, "/");
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception exception) {
                if (!log.isTraceEnabled()) break block3;
                log.trace("Exception attempting to get " + string + " version.", exception);
            }
        }
        return stringBuilder.toString();
    }

    private static void concat(StringBuilder stringBuilder, String string, String string2) {
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(string2).append(string);
        }
    }

    static {
        log = LogFactory.getLog(VersionInfoUtils.class);
    }
}

