/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.util.MetadataCache;
import java.util.LinkedHashMap;
import java.util.Map;

@SdkInternalApi
public class ResponseMetadataCache
implements MetadataCache {
    private final InternalCache internalCache;

    public ResponseMetadataCache(int n) {
        this.internalCache = new InternalCache(n);
    }

    @Override
    public synchronized void add(Object object, ResponseMetadata responseMetadata) {
        if (object == null) {
            return;
        }
        this.internalCache.put(System.identityHashCode(object), responseMetadata);
    }

    @Override
    public synchronized ResponseMetadata get(Object object) {
        return (ResponseMetadata)this.internalCache.get(System.identityHashCode(object));
    }

    private static final class InternalCache
    extends LinkedHashMap<Integer, ResponseMetadata> {
        private static final long serialVersionUID = 1L;
        private int maxSize;

        InternalCache(int n) {
            super(n);
            this.maxSize = n;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, ResponseMetadata> entry) {
            return this.size() > this.maxSize;
        }
    }
}

