/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.internal.SdkFilterInputStream;
import com.amazonaws.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

class NamespaceRemovingInputStream
extends SdkFilterInputStream {
    private byte[] lookAheadData = new byte[200];
    private boolean hasRemovedNamespace = false;

    public NamespaceRemovingInputStream(InputStream inputStream2) {
        super(new BufferedInputStream(inputStream2));
    }

    @Override
    public int read() throws IOException {
        this.abortIfNeeded();
        int n = this.in.read();
        if (n == 120 && !this.hasRemovedNamespace) {
            this.lookAheadData[0] = (byte)n;
            this.in.mark(this.lookAheadData.length);
            int n2 = this.in.read(this.lookAheadData, 1, this.lookAheadData.length - 1);
            this.in.reset();
            String string = new String(this.lookAheadData, 0, n2 + 1, StringUtils.UTF8);
            int n3 = this.matchXmlNamespaceAttribute(string);
            if (n3 > 0) {
                for (int i = 0; i < n3 - 1; ++i) {
                    this.in.read();
                }
                n = this.in.read();
                this.hasRemovedNamespace = true;
            }
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            int n3 = this.read();
            if (n3 == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            byArray[i + n] = (byte)n3;
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    private int matchXmlNamespaceAttribute(String string) {
        StringPrefixSlicer stringPrefixSlicer = new StringPrefixSlicer(string);
        if (!stringPrefixSlicer.removePrefix("xmlns")) {
            return -1;
        }
        stringPrefixSlicer.removeRepeatingPrefix(" ");
        if (!stringPrefixSlicer.removePrefix("=")) {
            return -1;
        }
        stringPrefixSlicer.removeRepeatingPrefix(" ");
        if (!stringPrefixSlicer.removePrefix("\"")) {
            return -1;
        }
        if (!stringPrefixSlicer.removePrefixEndingWith("\"")) {
            return -1;
        }
        return string.length() - stringPrefixSlicer.getString().length();
    }

    private static final class StringPrefixSlicer {
        private String s;

        public StringPrefixSlicer(String string) {
            this.s = string;
        }

        public String getString() {
            return this.s;
        }

        public boolean removePrefix(String string) {
            if (!this.s.startsWith(string)) {
                return false;
            }
            this.s = this.s.substring(string.length());
            return true;
        }

        public boolean removeRepeatingPrefix(String string) {
            if (!this.s.startsWith(string)) {
                return false;
            }
            while (this.s.startsWith(string)) {
                this.s = this.s.substring(string.length());
            }
            return true;
        }

        public boolean removePrefixEndingWith(String string) {
            int n = this.s.indexOf(string);
            if (n < 0) {
                return false;
            }
            this.s = this.s.substring(n + string.length());
            return true;
        }
    }
}

