/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.util.ComparableUtils;
import com.amazonaws.util.NumberUtils;
import com.amazonaws.util.StringUtils;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaVersionParser {
    public static final String JAVA_VERSION_PROPERTY = "java.version";
    private static String MAJOR_VERSION_FAMILY_PATTERN = "\\d+";
    private static String MAJOR_VERSION_PATTERN = "\\d+";
    private static String MAINTENANCE_NUMBER_PATTERN = "\\d+";
    private static String UPDATE_NUMBER_PATTERN = "\\d+";
    private static Pattern VERSION_REGEX = Pattern.compile(String.format("(%s)\\.(%s)\\.(%s)(?:_(%s))?.*", MAJOR_VERSION_FAMILY_PATTERN, MAJOR_VERSION_PATTERN, MAINTENANCE_NUMBER_PATTERN, UPDATE_NUMBER_PATTERN));
    private static final JavaVersion currentJavaVersion = JavaVersionParser.parseJavaVersion(System.getProperty("java.version"));

    private JavaVersionParser() {
    }

    public static JavaVersion getCurrentJavaVersion() {
        return currentJavaVersion;
    }

    public static JavaVersion parseJavaVersion(String string) {
        Matcher matcher;
        if (!StringUtils.isNullOrEmpty(string) && (matcher = VERSION_REGEX.matcher(string)).matches()) {
            Integer n = NumberUtils.tryParseInt(matcher.group(1));
            Integer n2 = NumberUtils.tryParseInt(matcher.group(2));
            Integer n3 = NumberUtils.tryParseInt(matcher.group(3));
            Integer n4 = NumberUtils.tryParseInt(matcher.group(4));
            return new JavaVersion(n, n2, n3, n4);
        }
        return JavaVersion.UNKNOWN;
    }

    public static enum KnownJavaVersions {
        JAVA_6(1, 6),
        JAVA_7(1, 7),
        JAVA_8(1, 8),
        JAVA_9(1, 9),
        UNKNOWN(0, -1);

        private Integer knownMajorVersionFamily;
        private Integer knownMajorVersion;

        private KnownJavaVersions(int n2, int n3) {
            this.knownMajorVersionFamily = n2;
            this.knownMajorVersion = n3;
        }

        public static KnownJavaVersions fromMajorVersion(Integer n, Integer n2) {
            for (KnownJavaVersions knownJavaVersions : KnownJavaVersions.values()) {
                if (!knownJavaVersions.isMajorVersion(n, n2)) continue;
                return knownJavaVersions;
            }
            return UNKNOWN;
        }

        private boolean isMajorVersion(Integer n, Integer n2) {
            return this.knownMajorVersionFamily.equals(n) && this.knownMajorVersion.equals(n2);
        }
    }

    public static final class JavaVersion
    implements Comparable<JavaVersion> {
        public static final JavaVersion UNKNOWN = new JavaVersion(null, null, null, null);
        private final Integer[] tokenizedVersion;
        private final Integer majorVersionFamily;
        private final Integer majorVersion;
        private final Integer maintenanceNumber;
        private final Integer updateNumber;
        private final KnownJavaVersions knownVersion;

        public JavaVersion(Integer n, Integer n2, Integer n3, Integer n4) {
            this.majorVersionFamily = n;
            this.majorVersion = n2;
            this.maintenanceNumber = n3;
            this.updateNumber = n4;
            this.knownVersion = KnownJavaVersions.fromMajorVersion(n, n2);
            this.tokenizedVersion = this.getTokenizedVersion();
        }

        private Integer[] getTokenizedVersion() {
            return new Integer[]{this.majorVersionFamily, this.majorVersion, this.maintenanceNumber, this.updateNumber};
        }

        public Integer getMajorVersionFamily() {
            return this.majorVersionFamily;
        }

        public Integer getMajorVersion() {
            return this.majorVersion;
        }

        public String getMajorVersionString() {
            return String.format("%d.%d", this.majorVersionFamily, this.majorVersion);
        }

        public Integer getMaintenanceNumber() {
            return this.maintenanceNumber;
        }

        public Integer getUpdateNumber() {
            return this.updateNumber;
        }

        public KnownJavaVersions getKnownVersion() {
            return this.knownVersion;
        }

        @Override
        public int compareTo(JavaVersion javaVersion) {
            for (int i = 0; i < this.tokenizedVersion.length; ++i) {
                int n = ComparableUtils.safeCompare(this.tokenizedVersion[i], javaVersion.tokenizedVersion[i]);
                if (n == 0) continue;
                return n;
            }
            return 0;
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + (this.knownVersion == null ? 0 : this.knownVersion.hashCode());
            n2 = 31 * n2 + (this.maintenanceNumber == null ? 0 : this.maintenanceNumber.hashCode());
            n2 = 31 * n2 + (this.majorVersion == null ? 0 : this.majorVersion.hashCode());
            n2 = 31 * n2 + (this.majorVersionFamily == null ? 0 : this.majorVersionFamily.hashCode());
            n2 = 31 * n2 + Arrays.hashCode((Object[])this.tokenizedVersion);
            n2 = 31 * n2 + (this.updateNumber == null ? 0 : this.updateNumber.hashCode());
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            JavaVersion javaVersion = (JavaVersion)object;
            if (this.knownVersion != javaVersion.knownVersion) {
                return false;
            }
            if (this.maintenanceNumber == null ? javaVersion.maintenanceNumber != null : !this.maintenanceNumber.equals(javaVersion.maintenanceNumber)) {
                return false;
            }
            if (this.majorVersion == null ? javaVersion.majorVersion != null : !this.majorVersion.equals(javaVersion.majorVersion)) {
                return false;
            }
            if (this.majorVersionFamily == null ? javaVersion.majorVersionFamily != null : !this.majorVersionFamily.equals(javaVersion.majorVersionFamily)) {
                return false;
            }
            if (!Arrays.equals((Object[])this.tokenizedVersion, (Object[])javaVersion.tokenizedVersion)) {
                return false;
            }
            return !(this.updateNumber == null ? javaVersion.updateNumber != null : !this.updateNumber.equals(javaVersion.updateNumber));
        }
    }
}

