/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.annotation.SdkProtectedApi;
import com.amazonaws.internal.config.HostRegexToRegionMapping;
import com.amazonaws.internal.config.InternalConfig;
import com.amazonaws.log.InternalLogFactory;
import java.net.InetAddress;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AwsHostNameUtils {
    private static final Pattern S3_ENDPOINT_PATTERN = Pattern.compile("^(?:.+\\.)?s3[.-]([a-z0-9-]+)$");
    private static final Pattern STANDARD_CLOUDSEARCH_ENDPOINT_PATTERN = Pattern.compile("^(?:.+\\.)?([a-z0-9-]+)\\.cloudsearch$");
    private static final Pattern EXTENDED_CLOUDSEARCH_ENDPOINT_PATTERN = Pattern.compile("^(?:.+\\.)?([a-z0-9-]+)\\.cloudsearch\\..+");

    @Deprecated
    public static String parseRegionName(URI uRI) {
        return AwsHostNameUtils.parseRegionName(uRI.getHost(), null);
    }

    @Deprecated
    public static String parseRegionName(String string, String string2) {
        String string3 = AwsHostNameUtils.parseRegion(string, string2);
        return string3 == null ? "us-east-1" : string3;
    }

    public static String parseRegion(String string, String string2) {
        String string3 = AwsHostNameUtils.parseRegionFromInternalConfig(string);
        if (string3 != null) {
            return string3;
        }
        string3 = AwsHostNameUtils.parseRegionFromAwsPartitionPattern(string);
        if (string3 != null) {
            return string3;
        }
        string3 = AwsHostNameUtils.parseRegionUsingServiceHint(string, string2);
        if (string3 != null) {
            return string3;
        }
        string3 = AwsHostNameUtils.parseRegionFromAfterServiceName(string, string2);
        return string3;
    }

    @SdkProtectedApi
    public static String parseRegionFromInternalConfig(String string) {
        AwsHostNameUtils.validateHostname(string);
        InternalConfig internalConfig = InternalConfig.Factory.getInternalConfig();
        for (HostRegexToRegionMapping hostRegexToRegionMapping : internalConfig.getHostRegexToRegionMappings()) {
            if (!hostRegexToRegionMapping.isHostNameMatching(string)) continue;
            return hostRegexToRegionMapping.getRegionName();
        }
        return null;
    }

    @SdkProtectedApi
    public static String parseRegionFromAwsPartitionPattern(String string) {
        AwsHostNameUtils.validateHostname(string);
        if (string.endsWith(".amazonaws.com")) {
            int n = string.length() - ".amazonaws.com".length();
            return AwsHostNameUtils.parseStandardRegionName(string.substring(0, n));
        }
        return null;
    }

    @SdkProtectedApi
    public static String parseRegionUsingServiceHint(String string, String string2) {
        Matcher matcher;
        AwsHostNameUtils.validateHostname(string);
        if (string2 != null && string2.equals("cloudsearch") && !string.startsWith("cloudsearch.") && (matcher = EXTENDED_CLOUDSEARCH_ENDPOINT_PATTERN.matcher(string)).matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String parseRegionFromAfterServiceName(String string, String string2) {
        Pattern pattern;
        Matcher matcher;
        AwsHostNameUtils.validateHostname(string);
        if (string2 != null && (matcher = (pattern = Pattern.compile("^(?:.+\\.)?" + Pattern.quote(string2) + "[.-]([a-z0-9-]+)\\.")).matcher(string)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static void validateHostname(String string) {
        if (string == null) {
            throw new IllegalArgumentException("hostname cannot be null");
        }
    }

    private static String parseStandardRegionName(String string) {
        Matcher matcher = S3_ENDPOINT_PATTERN.matcher(string);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        matcher = STANDARD_CLOUDSEARCH_ENDPOINT_PATTERN.matcher(string);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "us-east-1";
        }
        String string2 = string.substring(n + 1);
        if ("us-gov".equals(string2)) {
            string2 = "us-gov-west-1";
        }
        return string2;
    }

    @Deprecated
    public static String parseServiceName(URI uRI) {
        String string = uRI.getHost();
        if (!string.endsWith(".amazonaws.com")) {
            throw new IllegalArgumentException("Cannot parse a service name from an unrecognized endpoint (" + string + ").");
        }
        String string2 = string.substring(0, string.indexOf(".amazonaws.com"));
        if (string2.endsWith(".s3") || S3_ENDPOINT_PATTERN.matcher(string2).matches()) {
            return "s3";
        }
        int n = 46;
        if (string2.indexOf(n) == -1) {
            return string2;
        }
        String string3 = string2.substring(0, string2.indexOf(n));
        return string3;
    }

    public static String localHostName() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostName();
        }
        catch (Exception exception) {
            InternalLogFactory.getLog(AwsHostNameUtils.class).debug("Failed to determine the local hostname; fall back to use \"localhost\".", exception);
            return "localhost";
        }
    }
}

