/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.TimingInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@NotThreadSafe
public class AWSRequestMetricsFullSupport
extends AWSRequestMetrics {
    private final Map<String, List<Object>> properties = new HashMap<String, List<Object>>();
    private final Map<String, TimingInfo> eventsBeingProfiled = new HashMap<String, TimingInfo>();
    private static final Log latencyLogger = LogFactory.getLog("com.amazonaws.latency");
    private static final Object KEY_VALUE_SEPARATOR = "=";
    private static final Object COMMA_SEPARATOR = ", ";

    public AWSRequestMetricsFullSupport() {
        super(TimingInfo.startTimingFullSupport());
    }

    @Override
    public void startEvent(String string) {
        this.eventsBeingProfiled.put(string, TimingInfo.startTimingFullSupport(System.currentTimeMillis(), System.nanoTime()));
    }

    @Override
    public void startEvent(MetricType metricType) {
        this.startEvent(metricType.name());
    }

    @Override
    public void endEvent(String string) {
        TimingInfo timingInfo = this.eventsBeingProfiled.get(string);
        if (timingInfo == null) {
            LogFactory.getLog(this.getClass()).warn("Trying to end an event which was never started: " + string);
            return;
        }
        timingInfo.endTiming();
        this.timingInfo.addSubMeasurement(string, TimingInfo.unmodifiableTimingInfo(timingInfo.getStartEpochTimeMilliIfKnown(), timingInfo.getStartTimeNano(), timingInfo.getEndTimeNano()));
    }

    @Override
    public void endEvent(MetricType metricType) {
        this.endEvent(metricType.name());
    }

    @Override
    public void incrementCounter(String string) {
        this.timingInfo.incrementCounter(string);
    }

    @Override
    public void incrementCounter(MetricType metricType) {
        this.incrementCounter(metricType.name());
    }

    @Override
    public void setCounter(String string, long l) {
        this.timingInfo.setCounter(string, l);
    }

    @Override
    public void setCounter(MetricType metricType, long l) {
        this.setCounter(metricType.name(), l);
    }

    @Override
    public void addProperty(String string, Object object) {
        List<Object> list = this.properties.get(string);
        if (list == null) {
            list = new ArrayList<Object>();
            this.properties.put(string, list);
        }
        list.add(object);
    }

    @Override
    public void addProperty(MetricType metricType, Object object) {
        this.addProperty(metricType.name(), object);
    }

    @Override
    public void log() {
        if (latencyLogger.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, List<Object>> entry : this.properties.entrySet()) {
                this.keyValueFormat(entry.getKey(), entry.getValue(), stringBuilder);
            }
            for (Map.Entry<String, Object> entry : this.timingInfo.getAllCounters().entrySet()) {
                this.keyValueFormat(entry.getKey(), entry.getValue(), stringBuilder);
            }
            for (Map.Entry<String, Object> entry : this.timingInfo.getSubMeasurementsByName().entrySet()) {
                this.keyValueFormat(entry.getKey(), entry.getValue(), stringBuilder);
            }
            latencyLogger.debug(stringBuilder.toString());
        }
    }

    private void keyValueFormat(Object object, Object object2, StringBuilder stringBuilder) {
        stringBuilder.append(object).append(KEY_VALUE_SEPARATOR).append(object2).append(COMMA_SEPARATOR);
    }

    @Override
    public List<Object> getProperty(String string) {
        return this.properties.get(string);
    }

    @Override
    public List<Object> getProperty(MetricType metricType) {
        return this.getProperty(metricType.name());
    }

    @Override
    public final boolean isEnabled() {
        return true;
    }
}

