/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;
import java.util.ArrayList;
import java.util.List;

public class ListUnmarshaller<T>
implements Unmarshaller<List<T>, JsonUnmarshallerContext> {
    private final Unmarshaller<T, JsonUnmarshallerContext> itemUnmarshaller;

    public ListUnmarshaller(Unmarshaller<T, JsonUnmarshallerContext> unmarshaller) {
        this.itemUnmarshaller = unmarshaller;
    }

    @Override
    public List<T> unmarshall(JsonUnmarshallerContext jsonUnmarshallerContext) throws Exception {
        if (jsonUnmarshallerContext.isInsideResponseHeader()) {
            return this.unmarshallResponseHeaderToList(jsonUnmarshallerContext);
        }
        return this.unmarshallJsonToList(jsonUnmarshallerContext);
    }

    private List<T> unmarshallResponseHeaderToList(JsonUnmarshallerContext jsonUnmarshallerContext) throws Exception {
        String[] stringArray;
        String string = jsonUnmarshallerContext.readText();
        ArrayList<T> arrayList = new ArrayList<T>();
        for (final String string2 : stringArray = string.split("[,]")) {
            arrayList.add(this.itemUnmarshaller.unmarshall(new JsonUnmarshallerContext(){

                @Override
                public String readText() {
                    return string2;
                }
            }));
        }
        return arrayList;
    }

    private List<T> unmarshallJsonToList(JsonUnmarshallerContext jsonUnmarshallerContext) throws Exception {
        ArrayList<T> arrayList = new ArrayList<T>();
        if (jsonUnmarshallerContext.getCurrentToken() == JsonToken.VALUE_NULL) {
            return null;
        }
        JsonToken jsonToken;
        while ((jsonToken = jsonUnmarshallerContext.nextToken()) != null) {
            if (jsonToken == JsonToken.END_ARRAY) {
                return arrayList;
            }
            arrayList.add(this.itemUnmarshaller.unmarshall(jsonUnmarshallerContext));
        }
        return arrayList;
    }
}

