/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyPartRequest;

public class CopyPartRequestFactory {
    private final String uploadId;
    private final long optimalPartSize;
    private final CopyObjectRequest origReq;
    private int partNumber = 1;
    private long offset = 0L;
    private long remainingBytes;

    public CopyPartRequestFactory(CopyObjectRequest copyObjectRequest, String string, long l, long l2) {
        this.origReq = copyObjectRequest;
        this.uploadId = string;
        this.optimalPartSize = l;
        this.remainingBytes = l2;
    }

    public synchronized boolean hasMoreRequests() {
        return this.remainingBytes > 0L;
    }

    public synchronized CopyPartRequest getNextCopyPartRequest() {
        long l = Math.min(this.optimalPartSize, this.remainingBytes);
        CopyPartRequest copyPartRequest = (CopyPartRequest)((AmazonWebServiceRequest)((AmazonWebServiceRequest)new CopyPartRequest().withSourceBucketName(this.origReq.getSourceBucketName()).withSourceKey(this.origReq.getSourceKey()).withUploadId(this.uploadId).withPartNumber(this.partNumber++).withDestinationBucketName(this.origReq.getDestinationBucketName()).withDestinationKey(this.origReq.getDestinationKey()).withSourceVersionId(this.origReq.getSourceVersionId()).withFirstByte(this.offset).withLastByte(this.offset + l - 1L).withSourceSSECustomerKey(this.origReq.getSourceSSECustomerKey()).withDestinationSSECustomerKey(this.origReq.getDestinationSSECustomerKey()).withRequesterPays(this.origReq.isRequesterPays()).withMatchingETagConstraints(this.origReq.getMatchingETagConstraints()).withModifiedSinceConstraint(this.origReq.getModifiedSinceConstraint()).withNonmatchingETagConstraints(this.origReq.getNonmatchingETagConstraints()).withSourceVersionId(this.origReq.getSourceVersionId()).withUnmodifiedSinceConstraint(this.origReq.getUnmodifiedSinceConstraint()).withGeneralProgressListener(this.origReq.getGeneralProgressListener())).withRequestMetricCollector(this.origReq.getRequestMetricCollector())).withRequestCredentialsProvider(this.origReq.getRequestCredentialsProvider());
        this.offset += l;
        this.remainingBytes -= l;
        return copyPartRequest;
    }
}

