/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.transfer.AbortableTransfer;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.internal.AbstractDownloadCallableConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@SdkInternalApi
public abstract class AbstractDownloadCallable
implements Callable<File> {
    protected final ExecutorService executor;
    protected final List<Future<Long>> futures;
    protected final File dstfile;
    private final CountDownLatch latch;
    private final AbortableTransfer abortableDownload;
    private final boolean isDownloadParallel;
    private final ScheduledExecutorService timedExecutor;
    private final long timeout;

    protected AbstractDownloadCallable(AbstractDownloadCallableConfig abstractDownloadCallableConfig) {
        if (abstractDownloadCallableConfig.getLatch() == null || abstractDownloadCallableConfig.getDestFile() == null || abstractDownloadCallableConfig.getAbortableDownload() == null) {
            throw new IllegalArgumentException();
        }
        this.executor = abstractDownloadCallableConfig.getExecutor();
        this.timedExecutor = abstractDownloadCallableConfig.getTimedExecutor();
        this.futures = new ArrayList<Future<Long>>();
        this.dstfile = abstractDownloadCallableConfig.getDestFile();
        this.latch = abstractDownloadCallableConfig.getLatch();
        this.abortableDownload = abstractDownloadCallableConfig.getAbortableDownload();
        this.isDownloadParallel = abstractDownloadCallableConfig.isDownloadParallel();
        this.timeout = abstractDownloadCallableConfig.getTimeout();
    }

    @Override
    public File call() throws Exception {
        try {
            this.latch.await();
            if (this.isTimeoutEnabled()) {
                this.timedExecutor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (AbstractDownloadCallable.this.abortableDownload.getState() != Transfer.TransferState.Completed) {
                                AbstractDownloadCallable.this.abortableDownload.abort();
                            }
                        }
                        catch (Exception exception) {
                            throw new SdkClientException("Unable to abort download after timeout", exception);
                        }
                    }
                }, this.timeout, TimeUnit.MILLISECONDS);
            }
            this.setState(Transfer.TransferState.InProgress);
            ServiceUtils.createParentDirectoryIfNecessary(this.dstfile);
            if (this.isDownloadParallel) {
                this.downloadInParallel();
            } else {
                this.downloadAsSingleObject();
            }
            return this.dstfile;
        }
        catch (Throwable throwable) {
            this.cleanupAfterException();
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw (Error)throwable;
        }
    }

    protected abstract void setState(Transfer.TransferState var1);

    protected abstract void downloadAsSingleObject();

    protected abstract void downloadInParallel() throws Exception;

    protected static AbstractDownloadCallableConfig constructCallableConfig(ExecutorService executorService, File file, CountDownLatch countDownLatch, AbortableTransfer abortableTransfer, boolean bl, ScheduledExecutorService scheduledExecutorService, long l) {
        return new AbstractDownloadCallableConfig().withExecutor(executorService).withDestFile(file).withLatch(countDownLatch).withAbortableDownload(abortableTransfer).withDownloadParallel(bl).withTimedExecutor(scheduledExecutorService).withTimeout(l);
    }

    private boolean isTimeoutEnabled() {
        return this.timeout > 0L;
    }

    private void cleanupAfterException() {
        for (Future<Long> future : this.futures) {
            future.cancel(true);
        }
        if (this.abortableDownload.getState() != Transfer.TransferState.Canceled) {
            this.setState(Transfer.TransferState.Failed);
        }
    }
}

