/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.event.ProgressListenerChain;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3Encryption;
import com.amazonaws.services.s3.AmazonS3EncryptionV2;
import com.amazonaws.services.s3.internal.FileLocks;
import com.amazonaws.services.s3.internal.Mimetypes;
import com.amazonaws.services.s3.internal.RequestCopyUtils;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.MultipartUpload;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.ObjectTagging;
import com.amazonaws.services.s3.model.PresignedUrlDownloadConfig;
import com.amazonaws.services.s3.model.PresignedUrlDownloadRequest;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.Copy;
import com.amazonaws.services.s3.transfer.Download;
import com.amazonaws.services.s3.transfer.DownloadCallable;
import com.amazonaws.services.s3.transfer.KeyFilter;
import com.amazonaws.services.s3.transfer.MultipleFileDownload;
import com.amazonaws.services.s3.transfer.MultipleFileTransferProgressUpdatingListener;
import com.amazonaws.services.s3.transfer.MultipleFileTransferStateChangeListener;
import com.amazonaws.services.s3.transfer.MultipleFileUpload;
import com.amazonaws.services.s3.transfer.ObjectCannedAclProvider;
import com.amazonaws.services.s3.transfer.ObjectMetadataProvider;
import com.amazonaws.services.s3.transfer.ObjectTaggingProvider;
import com.amazonaws.services.s3.transfer.PersistableDownload;
import com.amazonaws.services.s3.transfer.PersistableUpload;
import com.amazonaws.services.s3.transfer.PresignedUrlDownload;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferCompletionFilter;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.amazonaws.services.s3.transfer.TransferManagerConfiguration;
import com.amazonaws.services.s3.transfer.TransferManagerParams;
import com.amazonaws.services.s3.transfer.TransferProgress;
import com.amazonaws.services.s3.transfer.Upload;
import com.amazonaws.services.s3.transfer.UploadContext;
import com.amazonaws.services.s3.transfer.exception.FileLockException;
import com.amazonaws.services.s3.transfer.internal.AbstractTransfer;
import com.amazonaws.services.s3.transfer.internal.CopyCallable;
import com.amazonaws.services.s3.transfer.internal.CopyImpl;
import com.amazonaws.services.s3.transfer.internal.CopyMonitor;
import com.amazonaws.services.s3.transfer.internal.DownloadImpl;
import com.amazonaws.services.s3.transfer.internal.DownloadMonitor;
import com.amazonaws.services.s3.transfer.internal.MultipleFileDownloadImpl;
import com.amazonaws.services.s3.transfer.internal.MultipleFileTransferMonitor;
import com.amazonaws.services.s3.transfer.internal.MultipleFileUploadImpl;
import com.amazonaws.services.s3.transfer.internal.PreparedDownloadContext;
import com.amazonaws.services.s3.transfer.internal.PresignUrlDownloadCallable;
import com.amazonaws.services.s3.transfer.internal.PresignedUrlDownloadImpl;
import com.amazonaws.services.s3.transfer.internal.S3ProgressListener;
import com.amazonaws.services.s3.transfer.internal.S3ProgressListenerChain;
import com.amazonaws.services.s3.transfer.internal.TransferManagerUtils;
import com.amazonaws.services.s3.transfer.internal.TransferProgressUpdatingListener;
import com.amazonaws.services.s3.transfer.internal.TransferStateChangeListener;
import com.amazonaws.services.s3.transfer.internal.UploadCallable;
import com.amazonaws.services.s3.transfer.internal.UploadImpl;
import com.amazonaws.services.s3.transfer.internal.UploadMonitor;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.VersionInfoUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransferManager {
    private final AmazonS3 s3;
    private TransferManagerConfiguration configuration;
    private final ExecutorService executorService;
    private final ScheduledExecutorService timedThreadPool = new ScheduledThreadPoolExecutor(1, daemonThreadFactory);
    private static final Log log = LogFactory.getLog(TransferManager.class);
    private final boolean shutDownThreadPools;
    private final boolean isImmutable;
    private static final String USER_AGENT = TransferManager.class.getName() + "/" + VersionInfoUtils.getVersion();
    private static final String USER_AGENT_MULTIPART = TransferManager.class.getName() + "_multipart/" + VersionInfoUtils.getVersion();
    private static final String DEFAULT_DELIMITER = "/";
    private static final ThreadFactory daemonThreadFactory = new ThreadFactory(){
        final AtomicInteger threadCount = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable runnable2) {
            int n = this.threadCount.incrementAndGet();
            Thread thread2 = new Thread(runnable2);
            thread2.setDaemon(true);
            thread2.setName("S3TransferManagerTimedThread-" + n);
            return thread2;
        }
    };

    @Deprecated
    public TransferManager() {
        this(new AmazonS3Client(new DefaultAWSCredentialsProviderChain()));
    }

    @Deprecated
    public TransferManager(AWSCredentialsProvider aWSCredentialsProvider) {
        this(new AmazonS3Client(aWSCredentialsProvider));
    }

    @Deprecated
    public TransferManager(AWSCredentials aWSCredentials) {
        this(new AmazonS3Client(aWSCredentials));
    }

    @Deprecated
    public TransferManager(AmazonS3 amazonS3) {
        this(amazonS3, TransferManagerUtils.createDefaultExecutorService());
    }

    @Deprecated
    public TransferManager(AmazonS3 amazonS3, ExecutorService executorService) {
        this(amazonS3, executorService, true);
    }

    @Deprecated
    public TransferManager(AmazonS3 amazonS3, ExecutorService executorService, boolean bl) {
        this.s3 = amazonS3;
        this.executorService = executorService;
        this.configuration = new TransferManagerConfiguration();
        this.shutDownThreadPools = bl;
        this.isImmutable = false;
    }

    @SdkInternalApi
    TransferManager(TransferManagerParams transferManagerParams) {
        this.s3 = transferManagerParams.getS3Client();
        this.executorService = transferManagerParams.getExecutorService();
        this.configuration = transferManagerParams.getConfiguration();
        this.shutDownThreadPools = transferManagerParams.getShutDownThreadPools();
        this.isImmutable = true;
    }

    protected TransferManager(TransferManagerBuilder transferManagerBuilder) {
        this(transferManagerBuilder.getParams());
    }

    @Deprecated
    public void setConfiguration(TransferManagerConfiguration transferManagerConfiguration) {
        this.checkMutability();
        this.configuration = transferManagerConfiguration;
    }

    public TransferManagerConfiguration getConfiguration() {
        return this.configuration;
    }

    public AmazonS3 getAmazonS3Client() {
        return this.s3;
    }

    public Upload upload(String string, String string2, InputStream inputStream2, ObjectMetadata objectMetadata) throws AmazonServiceException, AmazonClientException {
        return this.upload(new PutObjectRequest(string, string2, inputStream2, objectMetadata));
    }

    public Upload upload(String string, String string2, File file) throws AmazonServiceException, AmazonClientException {
        return this.upload(new PutObjectRequest(string, string2, file));
    }

    public Upload upload(PutObjectRequest putObjectRequest) throws AmazonServiceException, AmazonClientException {
        return this.doUpload(putObjectRequest, null, null, null);
    }

    public Upload upload(PutObjectRequest putObjectRequest, S3ProgressListener s3ProgressListener) throws AmazonServiceException, AmazonClientException {
        return this.doUpload(putObjectRequest, null, s3ProgressListener, null);
    }

    private Upload doUpload(PutObjectRequest putObjectRequest, TransferStateChangeListener transferStateChangeListener, S3ProgressListener s3ProgressListener, PersistableUpload persistableUpload) throws AmazonServiceException, AmazonClientException {
        String string;
        TransferManager.assertNotObjectLambdaArn(putObjectRequest.getBucketName(), "upload");
        TransferManager.appendSingleObjectUserAgent(putObjectRequest);
        String string2 = string = persistableUpload != null ? persistableUpload.getMultipartUploadId() : null;
        if (putObjectRequest.getMetadata() == null) {
            putObjectRequest.setMetadata(new ObjectMetadata());
        }
        ObjectMetadata objectMetadata = putObjectRequest.getMetadata();
        File file = TransferManagerUtils.getRequestFile(putObjectRequest);
        if (file != null) {
            objectMetadata.setContentLength(file.length());
            if (objectMetadata.getContentType() == null) {
                objectMetadata.setContentType(Mimetypes.getInstance().getMimetype(file));
            }
        } else if (string != null) {
            throw new IllegalArgumentException("Unable to resume the upload. No file specified.");
        }
        String string3 = "Uploading to " + putObjectRequest.getBucketName() + DEFAULT_DELIMITER + putObjectRequest.getKey();
        TransferProgress transferProgress = new TransferProgress();
        transferProgress.setTotalBytesToTransfer(TransferManagerUtils.getContentLength(putObjectRequest));
        S3ProgressListenerChain s3ProgressListenerChain = new S3ProgressListenerChain(new TransferProgressUpdatingListener(transferProgress), putObjectRequest.getGeneralProgressListener(), s3ProgressListener);
        putObjectRequest.setGeneralProgressListener(s3ProgressListenerChain);
        UploadImpl uploadImpl = new UploadImpl(string3, transferProgress, s3ProgressListenerChain, transferStateChangeListener);
        UploadCallable uploadCallable = new UploadCallable(this, this.executorService, uploadImpl, putObjectRequest, s3ProgressListenerChain, string, transferProgress);
        UploadMonitor uploadMonitor = UploadMonitor.create(this, uploadImpl, this.executorService, uploadCallable, putObjectRequest, s3ProgressListenerChain);
        uploadImpl.setMonitor(uploadMonitor);
        return uploadImpl;
    }

    public Download download(String string, String string2, File file) {
        return this.download(string, string2, file, 0L);
    }

    public Download download(String string, String string2, File file, long l) {
        return this.download(new GetObjectRequest(string, string2), file, l);
    }

    public Download download(GetObjectRequest getObjectRequest, File file) {
        return this.download(getObjectRequest, file, 0L);
    }

    public Download download(GetObjectRequest getObjectRequest, File file, long l) {
        return this.doDownload(getObjectRequest, file, null, null, false, l, null);
    }

    public Download download(GetObjectRequest getObjectRequest, File file, S3ProgressListener s3ProgressListener) {
        return this.doDownload(getObjectRequest, file, null, s3ProgressListener, false, 0L, null);
    }

    public Download download(GetObjectRequest getObjectRequest, File file, S3ProgressListener s3ProgressListener, long l) {
        return this.doDownload(getObjectRequest, file, null, s3ProgressListener, false, l, null);
    }

    public Download download(GetObjectRequest getObjectRequest, File file, S3ProgressListener s3ProgressListener, long l, boolean bl) {
        return this.doDownload(getObjectRequest, file, null, s3ProgressListener, false, l, null, 0L, bl, 0L);
    }

    private Download doDownload(GetObjectRequest getObjectRequest, File file, TransferStateChangeListener transferStateChangeListener, S3ProgressListener s3ProgressListener, boolean bl, long l, PersistableDownload persistableDownload) {
        TransferManager.assertNotObjectLambdaArn(getObjectRequest.getBucketName(), "download");
        long l2 = 0L;
        Integer n = null;
        Long l3 = null;
        if (persistableDownload != null) {
            l2 = persistableDownload.getlastModifiedTime();
            n = persistableDownload.getLastFullyDownloadedPartNumber();
            l3 = persistableDownload.getLastFullyDownloadedFilePosition();
        }
        return this.doDownload(getObjectRequest, file, transferStateChangeListener, s3ProgressListener, bl, l, n, l2, false, l3);
    }

    private Download doDownload(GetObjectRequest getObjectRequest, File file, TransferStateChangeListener transferStateChangeListener, S3ProgressListener s3ProgressListener, boolean bl, long l, Integer n, long l2, boolean bl2, Long l3) {
        TransferManager.assertNotObjectLambdaArn(getObjectRequest.getBucketName(), "download");
        PreparedDownloadContext preparedDownloadContext = this.prepareDownload(getObjectRequest, file, transferStateChangeListener, s3ProgressListener, bl, l, n, l2, bl2, l3);
        return this.submitDownload(preparedDownloadContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedDownloadContext prepareDownload(GetObjectRequest getObjectRequest, File file, TransferStateChangeListener transferStateChangeListener, S3ProgressListener s3ProgressListener, boolean bl, long l, Integer n, long l2, boolean bl2, Long l3) {
        long l4;
        this.assertParameterNotNull(getObjectRequest, "A valid GetObjectRequest must be provided to initiate download");
        this.assertParameterNotNull(file, "A valid file must be provided to download into");
        TransferManager.appendSingleObjectUserAgent(getObjectRequest);
        String string = "Downloading from " + getObjectRequest.getBucketName() + DEFAULT_DELIMITER + getObjectRequest.getKey();
        TransferProgress transferProgress = new TransferProgress();
        S3ProgressListenerChain s3ProgressListenerChain = new S3ProgressListenerChain(new TransferProgressUpdatingListener(transferProgress), getObjectRequest.getGeneralProgressListener(), s3ProgressListener);
        getObjectRequest.setGeneralProgressListener(new ProgressListenerChain(new TransferCompletionFilter(), s3ProgressListenerChain));
        GetObjectMetadataRequest getObjectMetadataRequest = RequestCopyUtils.createGetObjectMetadataRequestFrom(getObjectRequest);
        ObjectMetadata objectMetadata = this.s3.getObjectMetadata(getObjectMetadataRequest);
        long l5 = objectMetadata.getLastModified().getTime();
        long l6 = 0L;
        long[] lArray = getObjectRequest.getRange();
        if (lArray != null && lArray.length == 2) {
            l6 = lArray[0];
            l4 = lArray[1];
        } else {
            l4 = objectMetadata.getContentLength() - 1L;
        }
        long l7 = l6;
        boolean bl3 = !this.configuration.isDisableParallelDownloads() && TransferManagerUtils.isDownloadParallelizable(this.s3, getObjectRequest, ServiceUtils.getPartCount(getObjectRequest, this.s3));
        DownloadImpl downloadImpl = new DownloadImpl(string, transferProgress, s3ProgressListenerChain, null, transferStateChangeListener, getObjectRequest, file, objectMetadata, bl3);
        long l8 = l4 - l6 + 1L;
        transferProgress.setTotalBytesToTransfer(l8);
        if (l8 > 0L && !bl3) {
            getObjectRequest.withRange(l6, l4);
        }
        long l9 = -1L;
        if (bl) {
            if (this.isS3ObjectModifiedSincePause(l5, l2)) {
                throw new AmazonClientException("The requested object in bucket " + getObjectRequest.getBucketName() + " with key " + getObjectRequest.getKey() + " is modified on Amazon S3 since the last pause.");
            }
            getObjectRequest.setUnmodifiedSinceConstraint(new Date(l5));
            if (!bl3) {
                if (!FileLocks.lock(file)) {
                    throw new FileLockException("Fail to lock " + file + " for resume download");
                }
                try {
                    if (file.exists()) {
                        l9 = file.length();
                        getObjectRequest.setRange(l6 += l9, l4);
                        transferProgress.updateProgress(Math.min(l9, l8));
                        l8 = l4 - l6 + 1L;
                        if (log.isDebugEnabled()) {
                            log.debug("Resume download: totalBytesToDownload=" + l8 + ", origStartingByte=" + l7 + ", startingByte=" + l6 + ", lastByte=" + l4 + ", numberOfBytesRead=" + l9 + ", file: " + file);
                        }
                    }
                }
                finally {
                    FileLocks.unlock(file);
                }
            }
        }
        if (l8 < 0L) {
            throw new IllegalArgumentException("Unable to determine the range for download operation.");
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        DownloadCallable downloadCallable = new DownloadCallable(this.s3, countDownLatch, getObjectRequest, bl, downloadImpl, file, l7, l9, l, this.timedThreadPool, this.executorService, n, bl3, bl2).withLastFullyMergedPartPosition(l3);
        return new PreparedDownloadContext(downloadImpl, downloadCallable, countDownLatch);
    }

    private DownloadImpl submitDownload(PreparedDownloadContext preparedDownloadContext) {
        Future<File> future = this.executorService.submit(preparedDownloadContext.getCallable());
        DownloadImpl downloadImpl = preparedDownloadContext.getTransfer();
        downloadImpl.setMonitor(new DownloadMonitor(downloadImpl, future));
        preparedDownloadContext.getLatch().countDown();
        return downloadImpl;
    }

    private boolean isS3ObjectModifiedSincePause(long l, long l2) {
        return l != l2;
    }

    public PresignedUrlDownload download(PresignedUrlDownloadRequest presignedUrlDownloadRequest, File file) {
        return this.download(presignedUrlDownloadRequest, file, new PresignedUrlDownloadConfig());
    }

    public PresignedUrlDownload download(PresignedUrlDownloadRequest presignedUrlDownloadRequest, File file, PresignedUrlDownloadConfig presignedUrlDownloadConfig) {
        this.assertParameterNotNull(presignedUrlDownloadRequest, "A valid PresignedUrlDownloadRequest must be provided to initiate download");
        this.assertParameterNotNull(file, "A valid file must be provided to download into");
        this.assertParameterNotNull(presignedUrlDownloadConfig, "A valid PresignedUrlDownloadContext must be provided");
        TransferManager.assertNotObjectLambdaUrl(presignedUrlDownloadRequest.getPresignedUrl(), "download");
        TransferManager.appendSingleObjectUserAgent(presignedUrlDownloadRequest);
        String string = "Downloading from the given presigned url: " + presignedUrlDownloadRequest.getPresignedUrl();
        TransferProgress transferProgress = new TransferProgress();
        S3ProgressListenerChain s3ProgressListenerChain = new S3ProgressListenerChain(new TransferProgressUpdatingListener(transferProgress), presignedUrlDownloadRequest.getGeneralProgressListener(), presignedUrlDownloadConfig.getS3progressListener());
        presignedUrlDownloadRequest.setGeneralProgressListener(new ProgressListenerChain(new TransferCompletionFilter(), s3ProgressListenerChain));
        Long l = 0L;
        Long l2 = null;
        long[] lArray = presignedUrlDownloadRequest.getRange();
        if (lArray != null && lArray.length == 2) {
            l = lArray[0];
            l2 = lArray[1];
        } else {
            ObjectMetadata objectMetadata = this.getObjectMetadataUsingRange(presignedUrlDownloadRequest);
            if (objectMetadata != null) {
                Long l3 = TransferManagerUtils.getContentLengthFromContentRange(objectMetadata);
                l2 = l3 != null ? Long.valueOf(l3 - 1L) : null;
            }
        }
        long l4 = presignedUrlDownloadConfig.getDownloadSizePerRequest();
        boolean bl = this.isDownloadParallel(presignedUrlDownloadRequest, l, l2, l4);
        PresignedUrlDownloadImpl presignedUrlDownloadImpl = new PresignedUrlDownloadImpl(string, transferProgress, (ProgressListenerChain)s3ProgressListenerChain, presignedUrlDownloadRequest);
        if (l != null && l2 != null) {
            transferProgress.setTotalBytesToTransfer(l2 - l + 1L);
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Future<File> future = this.executorService.submit(new PresignUrlDownloadCallable(this.executorService, file, countDownLatch, presignedUrlDownloadImpl, bl, this.timedThreadPool, presignedUrlDownloadConfig.getTimeoutMillis(), this.s3, presignedUrlDownloadRequest, l4, l, l2, presignedUrlDownloadConfig.isResumeOnRetry()));
        presignedUrlDownloadImpl.setMonitor(new DownloadMonitor(presignedUrlDownloadImpl, future));
        countDownLatch.countDown();
        return presignedUrlDownloadImpl;
    }

    private ObjectMetadata getObjectMetadataUsingRange(PresignedUrlDownloadRequest presignedUrlDownloadRequest) {
        PresignedUrlDownloadRequest presignedUrlDownloadRequest2 = presignedUrlDownloadRequest.clone();
        S3Object s3Object = null;
        try {
            s3Object = this.s3.download(presignedUrlDownloadRequest2.withRange(0L, 0L)).getS3Object();
            ObjectMetadata objectMetadata = s3Object.getObjectMetadata();
            return objectMetadata;
        }
        catch (AmazonS3Exception amazonS3Exception) {
            if (amazonS3Exception.getStatusCode() == 416 && "InvalidRange".equals(amazonS3Exception.getErrorCode())) {
                ObjectMetadata objectMetadata = null;
                return objectMetadata;
            }
            throw amazonS3Exception;
        }
        finally {
            if (s3Object != null) {
                S3ObjectInputStream s3ObjectInputStream = s3Object.getObjectContent();
                IOUtils.drainInputStream(s3ObjectInputStream);
                IOUtils.closeQuietly(s3ObjectInputStream, log);
            }
        }
    }

    private boolean isDownloadParallel(PresignedUrlDownloadRequest presignedUrlDownloadRequest, Long l, Long l2, long l3) {
        return !this.configuration.isDisableParallelDownloads() && !(this.s3 instanceof AmazonS3Encryption) && !(this.s3 instanceof AmazonS3EncryptionV2) && presignedUrlDownloadRequest.getRange() == null && l != null && l2 != null && l2 - l + 1L > l3;
    }

    public MultipleFileDownload downloadDirectory(String string, String string2, File file) {
        return this.downloadDirectory(string, string2, file, false);
    }

    public MultipleFileDownload downloadDirectory(String string, String string2, File file, KeyFilter keyFilter) {
        return this.downloadDirectory(string, string2, file, false, keyFilter);
    }

    public MultipleFileDownload downloadDirectory(String string, String string2, File file, boolean bl) {
        return this.downloadDirectory(string, string2, file, bl, null);
    }

    public MultipleFileDownload downloadDirectory(String string, String string2, File file, boolean bl, KeyFilter keyFilter) {
        Object object2;
        Object object3;
        Object object4;
        TransferManager.assertNotObjectLambdaArn(string, "downloadDirectory");
        if (string2 == null) {
            string2 = "";
        }
        if (keyFilter == null) {
            keyFilter = KeyFilter.INCLUDE_ALL;
        }
        LinkedList<S3ObjectSummary> linkedList = new LinkedList<S3ObjectSummary>();
        Stack<String> stack = new Stack<String>();
        stack.add(string2);
        long l = 0L;
        do {
            object4 = (String)stack.pop();
            object3 = null;
            do {
                if (object3 == null) {
                    object2 = new ListObjectsRequest().withBucketName(string).withDelimiter(DEFAULT_DELIMITER).withPrefix((String)object4);
                    object3 = this.s3.listObjects((ListObjectsRequest)object2);
                } else {
                    object3 = this.s3.listNextBatchOfObjects((ObjectListing)object3);
                }
                for (S3ObjectSummary serializable2 : ((ObjectListing)object3).getObjectSummaries()) {
                    if (!keyFilter.shouldInclude(serializable2)) {
                        log.debug("Skipping " + serializable2.getKey() + " as it does not match filter.");
                        continue;
                    }
                    if (this.leavesRoot(file, serializable2.getKey())) {
                        throw new RuntimeException("Cannot download key " + serializable2.getKey() + ", its relative path resolves outside the parent directory.");
                    }
                    if (!serializable2.getKey().equals(object4) && !((ObjectListing)object3).getCommonPrefixes().contains(serializable2.getKey() + DEFAULT_DELIMITER)) {
                        linkedList.add(serializable2);
                        l += serializable2.getSize();
                        continue;
                    }
                    log.debug("Skipping download for object " + serializable2.getKey() + " since it is also a virtual directory");
                }
                stack.addAll(((ObjectListing)object3).getCommonPrefixes());
            } while (((ObjectListing)object3).isTruncated());
        } while (!stack.isEmpty());
        object4 = new ProgressListenerChain(new ProgressListener[0]);
        object3 = new TransferProgress();
        ((TransferProgress)object3).setTotalBytesToTransfer(l);
        object2 = new MultipleFileTransferProgressUpdatingListener((TransferProgress)object3, (ProgressListenerChain)object4);
        ArrayList<DownloadImpl> arrayList = new ArrayList<DownloadImpl>();
        ArrayList<PreparedDownloadContext> arrayList2 = new ArrayList<PreparedDownloadContext>();
        String string3 = "Downloading from " + string + DEFAULT_DELIMITER + string2;
        MultipleFileDownloadImpl multipleFileDownloadImpl = new MultipleFileDownloadImpl(string3, (TransferProgress)object3, (ProgressListenerChain)object4, string2, string, arrayList);
        multipleFileDownloadImpl.setMonitor(new MultipleFileTransferMonitor(multipleFileDownloadImpl, arrayList));
        CountDownLatch countDownLatch = new CountDownLatch(1);
        MultipleFileTransferStateChangeListener multipleFileTransferStateChangeListener = new MultipleFileTransferStateChangeListener(countDownLatch, multipleFileDownloadImpl);
        if (linkedList.isEmpty()) {
            multipleFileDownloadImpl.setState(Transfer.TransferState.Completed);
            return multipleFileDownloadImpl;
        }
        for (S3ObjectSummary s3ObjectSummary : linkedList) {
            Object object = new File(file, s3ObjectSummary.getKey());
            File file2 = ((File)object).getParentFile();
            if (!file2.exists() && !file2.mkdirs()) {
                throw new RuntimeException("Couldn't create parent directories for " + ((File)object).getAbsolutePath());
            }
            GetObjectRequest getObjectRequest = (GetObjectRequest)new GetObjectRequest(s3ObjectSummary.getBucketName(), s3ObjectSummary.getKey()).withGeneralProgressListener((ProgressListener)object2);
            PreparedDownloadContext preparedDownloadContext = this.prepareDownload(getObjectRequest, (File)object, multipleFileTransferStateChangeListener, null, false, 0L, null, 0L, bl, null);
            arrayList2.add(preparedDownloadContext);
        }
        try {
            for (PreparedDownloadContext preparedDownloadContext : arrayList2) {
                arrayList.add(this.submitDownload(preparedDownloadContext));
            }
        }
        catch (Throwable throwable) {
            for (Object object : arrayList) {
                try {
                    ((AbstractTransfer)object).getMonitor().getFuture().cancel(true);
                }
                catch (Throwable throwable2) {
                    log.warn("DownloadImpl could not be aborted", throwable2);
                }
            }
            throw new SdkClientException(throwable);
        }
        countDownLatch.countDown();
        return multipleFileDownloadImpl;
    }

    private boolean leavesRoot(File file, String string) {
        try {
            Path path = new File(file, string).getCanonicalFile().toPath();
            Path path2 = file.getCanonicalFile().toPath();
            return !path.startsWith(path2);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to canonicalize paths", iOException);
        }
    }

    public MultipleFileUpload uploadDirectory(String string, String string2, File file, boolean bl) {
        return this.uploadDirectory(string, string2, file, bl, null);
    }

    public MultipleFileUpload uploadDirectory(String string, String string2, File file, boolean bl, ObjectMetadataProvider objectMetadataProvider) {
        return this.uploadDirectory(string, string2, file, bl, objectMetadataProvider, null);
    }

    public MultipleFileUpload uploadDirectory(String string, String string2, File file, boolean bl, ObjectMetadataProvider objectMetadataProvider, ObjectTaggingProvider objectTaggingProvider) {
        return this.uploadDirectory(string, string2, file, bl, objectMetadataProvider, objectTaggingProvider, null);
    }

    public MultipleFileUpload uploadDirectory(String string, String string2, File file, boolean bl, ObjectMetadataProvider objectMetadataProvider, ObjectTaggingProvider objectTaggingProvider, ObjectCannedAclProvider objectCannedAclProvider) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            throw new IllegalArgumentException("Must provide a directory to upload");
        }
        TransferManager.assertNotObjectLambdaArn(string, "uploadDirectory");
        LinkedList<File> linkedList = new LinkedList<File>();
        this.listFiles(file, linkedList, bl);
        return this.uploadFileList(string, string2, file, linkedList, objectMetadataProvider, objectTaggingProvider, objectCannedAclProvider);
    }

    public MultipleFileUpload uploadFileList(String string, String string2, File file, List<File> list) {
        return this.uploadFileList(string, string2, file, list, null);
    }

    public MultipleFileUpload uploadFileList(String string, String string2, File file, List<File> list, ObjectMetadataProvider objectMetadataProvider) {
        return this.uploadFileList(string, string2, file, list, objectMetadataProvider, null);
    }

    public MultipleFileUpload uploadFileList(String string, String string2, File file, List<File> list, ObjectMetadataProvider objectMetadataProvider, ObjectTaggingProvider objectTaggingProvider) {
        return this.uploadFileList(string, string2, file, list, objectMetadataProvider, objectTaggingProvider, null);
    }

    public MultipleFileUpload uploadFileList(String string, String string2, File file, List<File> list, ObjectMetadataProvider objectMetadataProvider, ObjectTaggingProvider objectTaggingProvider, ObjectCannedAclProvider objectCannedAclProvider) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            throw new IllegalArgumentException("Must provide a common base directory for uploaded files");
        }
        TransferManager.assertNotObjectLambdaArn(string, "uploadFileList");
        if (string2 == null || string2.length() == 0) {
            string2 = "";
        } else if (!string2.endsWith(DEFAULT_DELIMITER)) {
            string2 = string2 + DEFAULT_DELIMITER;
        }
        ProgressListenerChain progressListenerChain = new ProgressListenerChain(new ProgressListener[0]);
        TransferProgress transferProgress = new TransferProgress();
        MultipleFileTransferProgressUpdatingListener multipleFileTransferProgressUpdatingListener = new MultipleFileTransferProgressUpdatingListener(transferProgress, progressListenerChain);
        LinkedList<UploadImpl> linkedList = new LinkedList<UploadImpl>();
        MultipleFileUploadImpl multipleFileUploadImpl = new MultipleFileUploadImpl("Uploading etc", transferProgress, progressListenerChain, string2, string, linkedList);
        multipleFileUploadImpl.setMonitor(new MultipleFileTransferMonitor(multipleFileUploadImpl, linkedList));
        CountDownLatch countDownLatch = new CountDownLatch(1);
        MultipleFileTransferStateChangeListener multipleFileTransferStateChangeListener = new MultipleFileTransferStateChangeListener(countDownLatch, multipleFileUploadImpl);
        if (list == null || list.isEmpty()) {
            multipleFileUploadImpl.setState(Transfer.TransferState.Completed);
        } else {
            int n = file.getAbsolutePath().length();
            if (!file.getAbsolutePath().endsWith(File.separator)) {
                ++n;
            }
            long l = 0L;
            for (File file2 : list) {
                if (!file2.isFile()) continue;
                l += file2.length();
                String string3 = file2.getAbsolutePath().substring(n).replaceAll("\\\\", DEFAULT_DELIMITER);
                UploadContext uploadContext = new UploadContext(file2, string, string3);
                ObjectMetadata objectMetadata = new ObjectMetadata();
                CannedAccessControlList cannedAccessControlList = null;
                ObjectTagging objectTagging = null;
                if (objectMetadataProvider != null) {
                    objectMetadataProvider.provideObjectMetadata(file2, objectMetadata);
                }
                if (objectTaggingProvider != null) {
                    objectTagging = objectTaggingProvider.provideObjectTags(uploadContext);
                }
                if (objectCannedAclProvider != null) {
                    cannedAccessControlList = objectCannedAclProvider.provideObjectCannedAcl(file2);
                }
                linkedList.add((UploadImpl)this.doUpload((PutObjectRequest)new PutObjectRequest(string, string2 + string3, file2).withMetadata(objectMetadata).withTagging(objectTagging).withCannedAcl(cannedAccessControlList).withGeneralProgressListener(multipleFileTransferProgressUpdatingListener), multipleFileTransferStateChangeListener, null, null));
            }
            transferProgress.setTotalBytesToTransfer(l);
        }
        countDownLatch.countDown();
        return multipleFileUploadImpl;
    }

    private void listFiles(File file, List<File> list, boolean bl) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    if (!bl) continue;
                    this.listFiles(file2, list, bl);
                    continue;
                }
                list.add(file2);
            }
        }
    }

    public void abortMultipartUploads(String string, Date date) throws AmazonServiceException, AmazonClientException {
        Object object;
        TransferManager.assertNotObjectLambdaArn(string, "abortMultipartUploads");
        MultipartUploadListing multipartUploadListing = this.s3.listMultipartUploads(TransferManager.appendSingleObjectUserAgent(new ListMultipartUploadsRequest(string)));
        do {
            object = multipartUploadListing.getMultipartUploads().iterator();
            while (object.hasNext()) {
                MultipartUpload multipartUpload = object.next();
                if (multipartUpload.getInitiated().compareTo(date) >= 0) continue;
                this.s3.abortMultipartUpload(TransferManager.appendSingleObjectUserAgent(new AbortMultipartUploadRequest(string, multipartUpload.getKey(), multipartUpload.getUploadId())));
            }
        } while ((multipartUploadListing = this.s3.listMultipartUploads((ListMultipartUploadsRequest)TransferManager.appendSingleObjectUserAgent(object = new ListMultipartUploadsRequest(string).withUploadIdMarker(multipartUploadListing.getNextUploadIdMarker()).withKeyMarker(multipartUploadListing.getNextKeyMarker())))).isTruncated());
    }

    public void shutdownNow() {
        this.shutdownNow(true);
    }

    public void shutdownNow(boolean bl) {
        if (this.shutDownThreadPools) {
            this.executorService.shutdownNow();
            this.timedThreadPool.shutdownNow();
        }
        if (bl) {
            this.s3.shutdown();
        }
    }

    private void shutdownThreadPools() {
        if (this.shutDownThreadPools) {
            this.executorService.shutdown();
            this.timedThreadPool.shutdown();
        }
    }

    public static <X extends AmazonWebServiceRequest> X appendSingleObjectUserAgent(X x) {
        x.getRequestClientOptions().appendUserAgent(USER_AGENT);
        return x;
    }

    public static <X extends AmazonWebServiceRequest> X appendMultipartUserAgent(X x) {
        x.getRequestClientOptions().appendUserAgent(USER_AGENT_MULTIPART);
        return x;
    }

    public Copy copy(String string, String string2, String string3, String string4) throws AmazonServiceException, AmazonClientException {
        return this.copy(new CopyObjectRequest(string, string2, string3, string4));
    }

    public Copy copy(CopyObjectRequest copyObjectRequest) {
        return this.copy(copyObjectRequest, null);
    }

    public Copy copy(CopyObjectRequest copyObjectRequest, TransferStateChangeListener transferStateChangeListener) throws AmazonServiceException, AmazonClientException {
        return this.copy(copyObjectRequest, this.s3, transferStateChangeListener);
    }

    public Copy copy(CopyObjectRequest copyObjectRequest, AmazonS3 amazonS3, TransferStateChangeListener transferStateChangeListener) throws AmazonServiceException, AmazonClientException {
        TransferManager.assertNotObjectLambdaArn(copyObjectRequest.getDestinationBucketName(), "copy");
        TransferManager.assertNotObjectLambdaArn(copyObjectRequest.getSourceBucketName(), "copy");
        TransferManager.appendSingleObjectUserAgent(copyObjectRequest);
        this.assertParameterNotNull(copyObjectRequest.getSourceBucketName(), "The source bucket name must be specified when a copy request is initiated.");
        this.assertParameterNotNull(copyObjectRequest.getSourceKey(), "The source object key must be specified when a copy request is initiated.");
        this.assertParameterNotNull(copyObjectRequest.getDestinationBucketName(), "The destination bucket name must be specified when a copy request is initiated.");
        this.assertParameterNotNull(copyObjectRequest.getDestinationKey(), "The destination object key must be specified when a copy request is initiated.");
        this.assertParameterNotNull(amazonS3, "The srcS3 parameter is mandatory");
        String string = "Copying object from " + copyObjectRequest.getSourceBucketName() + DEFAULT_DELIMITER + copyObjectRequest.getSourceKey() + " to " + copyObjectRequest.getDestinationBucketName() + DEFAULT_DELIMITER + copyObjectRequest.getDestinationKey();
        GetObjectMetadataRequest getObjectMetadataRequest = (GetObjectMetadataRequest)new GetObjectMetadataRequest(copyObjectRequest.getSourceBucketName(), copyObjectRequest.getSourceKey()).withSSECustomerKey(copyObjectRequest.getSourceSSECustomerKey()).withRequesterPays(copyObjectRequest.isRequesterPays()).withVersionId(copyObjectRequest.getSourceVersionId()).withRequestCredentialsProvider(copyObjectRequest.getRequestCredentialsProvider());
        ObjectMetadata objectMetadata = amazonS3.getObjectMetadata(getObjectMetadataRequest);
        TransferProgress transferProgress = new TransferProgress();
        transferProgress.setTotalBytesToTransfer(objectMetadata.getContentLength());
        ProgressListenerChain progressListenerChain = new ProgressListenerChain(new TransferProgressUpdatingListener(transferProgress));
        CopyImpl copyImpl = new CopyImpl(string, transferProgress, progressListenerChain, transferStateChangeListener);
        CopyCallable copyCallable = new CopyCallable(this, this.executorService, copyImpl, copyObjectRequest, objectMetadata, progressListenerChain);
        CopyMonitor copyMonitor = CopyMonitor.create(this, copyImpl, this.executorService, copyCallable, copyObjectRequest, progressListenerChain);
        copyImpl.setMonitor(copyMonitor);
        return copyImpl;
    }

    public Upload resumeUpload(PersistableUpload persistableUpload) {
        this.assertParameterNotNull(persistableUpload, "PauseUpload is mandatory to resume a upload.");
        TransferManager.assertNotObjectLambdaArn(persistableUpload.getBucketName(), "resumeUpload");
        this.configuration.setMinimumUploadPartSize(persistableUpload.getPartSize());
        this.configuration.setMultipartUploadThreshold(persistableUpload.getMutlipartUploadThreshold());
        return this.doUpload(new PutObjectRequest(persistableUpload.getBucketName(), persistableUpload.getKey(), new File(persistableUpload.getFile())), null, null, persistableUpload);
    }

    public Download resumeDownload(PersistableDownload persistableDownload) {
        this.assertParameterNotNull(persistableDownload, "PausedDownload is mandatory to resume a download.");
        TransferManager.assertNotObjectLambdaArn(persistableDownload.getBucketName(), "resumeDownload");
        GetObjectRequest getObjectRequest = new GetObjectRequest(persistableDownload.getBucketName(), persistableDownload.getKey(), persistableDownload.getVersionId());
        if (persistableDownload.getRange() != null && persistableDownload.getRange().length == 2) {
            long[] lArray = persistableDownload.getRange();
            getObjectRequest.setRange(lArray[0], lArray[1]);
        }
        getObjectRequest.setRequesterPays(persistableDownload.isRequesterPays());
        getObjectRequest.setResponseHeaders(persistableDownload.getResponseHeaders());
        return this.doDownload(getObjectRequest, new File(persistableDownload.getFile()), null, null, true, 0L, persistableDownload);
    }

    private void assertParameterNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string);
        }
    }

    protected void finalize() throws Throwable {
        this.shutdownThreadPools();
    }

    private void checkMutability() {
        if (this.isImmutable) {
            throw new UnsupportedOperationException("TransferManager is immutable when created with the builder.");
        }
    }

    private static void assertNotObjectLambdaArn(String string, String string2) {
        if (TransferManager.isObjectLambdaArn(string)) {
            String string3 = String.format("%s does not support S3 Object Lambda resources", string2);
            throw new IllegalArgumentException(string3);
        }
    }

    private static void assertNotObjectLambdaUrl(URL uRL, String string) {
        if (TransferManager.isObjectLambdaHost(uRL)) {
            String string2 = String.format("%s does not support S3 Object Lambda resources", string);
            throw new IllegalArgumentException(string2);
        }
    }

    private static boolean isObjectLambdaArn(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("arn:") && string.contains(":s3-object-lambda");
    }

    private static boolean isObjectLambdaHost(URL uRL) {
        String string = uRL.getHost();
        if (string == null) {
            return false;
        }
        return string.contains(".s3-object-lambda.");
    }
}

