/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.services.s3.internal.XmlWriter;
import com.amazonaws.services.s3.model.intelligenttiering.IntelligentTieringAndOperator;
import com.amazonaws.services.s3.model.intelligenttiering.IntelligentTieringFilterPredicate;
import com.amazonaws.services.s3.model.intelligenttiering.IntelligentTieringPredicateVisitor;
import com.amazonaws.services.s3.model.intelligenttiering.IntelligentTieringPrefixPredicate;
import com.amazonaws.services.s3.model.intelligenttiering.IntelligentTieringTagPredicate;
import com.amazonaws.services.s3.model.transform.BucketConfigurationXmlFactoryFunctions;

class XmlIntelligentTieringPredicateVisitor
implements IntelligentTieringPredicateVisitor {
    private final XmlWriter xml;

    public XmlIntelligentTieringPredicateVisitor(XmlWriter xmlWriter) {
        this.xml = xmlWriter;
    }

    @Override
    public void visit(IntelligentTieringPrefixPredicate intelligentTieringPrefixPredicate) {
        BucketConfigurationXmlFactoryFunctions.writePrefix(this.xml, intelligentTieringPrefixPredicate.getPrefix());
    }

    @Override
    public void visit(IntelligentTieringTagPredicate intelligentTieringTagPredicate) {
        BucketConfigurationXmlFactoryFunctions.writeTag(this.xml, intelligentTieringTagPredicate.getTag());
    }

    @Override
    public void visit(IntelligentTieringAndOperator intelligentTieringAndOperator) {
        this.xml.start("And");
        for (IntelligentTieringFilterPredicate intelligentTieringFilterPredicate : intelligentTieringAndOperator.getOperands()) {
            intelligentTieringFilterPredicate.accept(this);
        }
        this.xml.end();
    }
}

