/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.services.s3.model.ServerSideEncryptionRule;
import com.amazonaws.services.s3.model.transform.ServerSideEncryptionByDefaultStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

class ServerSideEncryptionRuleStaxUnmarshaller
implements Unmarshaller<ServerSideEncryptionRule, StaxUnmarshallerContext> {
    private static final ServerSideEncryptionRuleStaxUnmarshaller instance = new ServerSideEncryptionRuleStaxUnmarshaller();

    public static ServerSideEncryptionRuleStaxUnmarshaller getInstance() {
        return instance;
    }

    private ServerSideEncryptionRuleStaxUnmarshaller() {
    }

    @Override
    public ServerSideEncryptionRule unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
        int n = staxUnmarshallerContext.getCurrentDepth();
        int n2 = n + 1;
        if (staxUnmarshallerContext.isStartOfDocument()) {
            ++n2;
        }
        ServerSideEncryptionRule serverSideEncryptionRule = new ServerSideEncryptionRule();
        while (true) {
            XMLEvent xMLEvent;
            if ((xMLEvent = staxUnmarshallerContext.nextEvent()).isEndDocument()) {
                return serverSideEncryptionRule;
            }
            if (xMLEvent.isAttribute() || xMLEvent.isStartElement()) {
                if (staxUnmarshallerContext.testExpression("ApplyServerSideEncryptionByDefault", n2)) {
                    serverSideEncryptionRule.setApplyServerSideEncryptionByDefault(ServerSideEncryptionByDefaultStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                    continue;
                }
                if (!staxUnmarshallerContext.testExpression("BucketKeyEnabled", n2)) continue;
                serverSideEncryptionRule.setBucketKeyEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                continue;
            }
            if (xMLEvent.isEndElement() && staxUnmarshallerContext.getCurrentDepth() < n) break;
        }
        return serverSideEncryptionRule;
    }
}

