/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.services.s3.model.ServerSideEncryptionByDefault;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

class ServerSideEncryptionByDefaultStaxUnmarshaller
implements Unmarshaller<ServerSideEncryptionByDefault, StaxUnmarshallerContext> {
    private static final ServerSideEncryptionByDefaultStaxUnmarshaller instance = new ServerSideEncryptionByDefaultStaxUnmarshaller();

    public static ServerSideEncryptionByDefaultStaxUnmarshaller getInstance() {
        return instance;
    }

    private ServerSideEncryptionByDefaultStaxUnmarshaller() {
    }

    @Override
    public ServerSideEncryptionByDefault unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
        int n = staxUnmarshallerContext.getCurrentDepth();
        int n2 = n + 1;
        if (staxUnmarshallerContext.isStartOfDocument()) {
            ++n2;
        }
        ServerSideEncryptionByDefault serverSideEncryptionByDefault = new ServerSideEncryptionByDefault();
        while (true) {
            XMLEvent xMLEvent;
            if ((xMLEvent = staxUnmarshallerContext.nextEvent()).isEndDocument()) {
                return serverSideEncryptionByDefault;
            }
            if (xMLEvent.isAttribute() || xMLEvent.isStartElement()) {
                if (staxUnmarshallerContext.testExpression("SSEAlgorithm", n2)) {
                    serverSideEncryptionByDefault.setSSEAlgorithm(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                }
                if (!staxUnmarshallerContext.testExpression("KMSMasterKeyID", n2)) continue;
                serverSideEncryptionByDefault.setKMSMasterKeyID(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                continue;
            }
            if (xMLEvent.isEndElement() && staxUnmarshallerContext.getCurrentDepth() < n) break;
        }
        return serverSideEncryptionByDefault;
    }
}

