/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.internal.XmlWriter;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.CSVInput;
import com.amazonaws.services.s3.model.CSVOutput;
import com.amazonaws.services.s3.model.Encryption;
import com.amazonaws.services.s3.model.GlacierJobParameters;
import com.amazonaws.services.s3.model.Grant;
import com.amazonaws.services.s3.model.InputSerialization;
import com.amazonaws.services.s3.model.JSONInput;
import com.amazonaws.services.s3.model.JSONOutput;
import com.amazonaws.services.s3.model.MetadataEntry;
import com.amazonaws.services.s3.model.ObjectTagging;
import com.amazonaws.services.s3.model.OutputLocation;
import com.amazonaws.services.s3.model.OutputSerialization;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.RequestProgress;
import com.amazonaws.services.s3.model.RestoreObjectRequest;
import com.amazonaws.services.s3.model.S3Location;
import com.amazonaws.services.s3.model.ScanRange;
import com.amazonaws.services.s3.model.SelectObjectContentRequest;
import com.amazonaws.services.s3.model.SelectParameters;
import com.amazonaws.services.s3.model.Tag;
import com.amazonaws.services.s3.model.transform.AclXmlFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class RequestXmlFactory {
    public static byte[] convertToXmlByteArray(List<PartETag> list) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("CompleteMultipartUpload");
        if (list != null) {
            ArrayList<PartETag> arrayList = new ArrayList<PartETag>(list);
            Collections.sort(arrayList, new Comparator<PartETag>(){

                @Override
                public int compare(PartETag partETag, PartETag partETag2) {
                    if (partETag.getPartNumber() < partETag2.getPartNumber()) {
                        return -1;
                    }
                    if (partETag.getPartNumber() > partETag2.getPartNumber()) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (PartETag partETag : arrayList) {
                xmlWriter.start("Part");
                xmlWriter.start("PartNumber").value(Integer.toString(partETag.getPartNumber())).end();
                xmlWriter.start("ETag").value(partETag.getETag()).end();
                xmlWriter.end();
            }
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public static byte[] convertToXmlByteArray(RestoreObjectRequest restoreObjectRequest) throws SdkClientException {
        GlacierJobParameters glacierJobParameters;
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("RestoreRequest");
        if (restoreObjectRequest.getExpirationInDays() != -1) {
            xmlWriter.start("Days").value(Integer.toString(restoreObjectRequest.getExpirationInDays())).end();
        }
        if ((glacierJobParameters = restoreObjectRequest.getGlacierJobParameters()) != null) {
            xmlWriter.start("GlacierJobParameters");
            RequestXmlFactory.addIfNotNull(xmlWriter, "Tier", glacierJobParameters.getTier());
            xmlWriter.end();
        }
        RequestXmlFactory.addIfNotNull(xmlWriter, "Type", restoreObjectRequest.getType());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Tier", restoreObjectRequest.getTier());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Description", restoreObjectRequest.getDescription());
        RequestXmlFactory.addSelectParametersIfNotNull(xmlWriter, restoreObjectRequest.getSelectParameters());
        RequestXmlFactory.addOutputLocationIfNotNull(xmlWriter, restoreObjectRequest.getOutputLocation());
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public static byte[] convertToXmlByteArray(SelectObjectContentRequest selectObjectContentRequest) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("SelectObjectContentRequest");
        RequestXmlFactory.addIfNotNull(xmlWriter, "Expression", selectObjectContentRequest.getExpression());
        RequestXmlFactory.addIfNotNull(xmlWriter, "ExpressionType", selectObjectContentRequest.getExpressionType());
        RequestXmlFactory.addScanRangeIfNotNull(xmlWriter, selectObjectContentRequest.getScanRange());
        RequestXmlFactory.addRequestProgressIfNotNull(xmlWriter, selectObjectContentRequest.getRequestProgress());
        RequestXmlFactory.addInputSerializationIfNotNull(xmlWriter, selectObjectContentRequest.getInputSerialization());
        RequestXmlFactory.addOutputSerializationIfNotNull(xmlWriter, selectObjectContentRequest.getOutputSerialization());
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    private static void addRequestProgressIfNotNull(XmlWriter xmlWriter, RequestProgress requestProgress) {
        if (requestProgress == null) {
            return;
        }
        xmlWriter.start("RequestProgress");
        RequestXmlFactory.addIfNotNull(xmlWriter, "Enabled", requestProgress.getEnabled());
        xmlWriter.end();
    }

    private static void addSelectParametersIfNotNull(XmlWriter xmlWriter, SelectParameters selectParameters) {
        if (selectParameters == null) {
            return;
        }
        xmlWriter.start("SelectParameters");
        RequestXmlFactory.addInputSerializationIfNotNull(xmlWriter, selectParameters.getInputSerialization());
        RequestXmlFactory.addIfNotNull(xmlWriter, "ExpressionType", selectParameters.getExpressionType());
        RequestXmlFactory.addIfNotNull(xmlWriter, "Expression", selectParameters.getExpression());
        RequestXmlFactory.addOutputSerializationIfNotNull(xmlWriter, selectParameters.getOutputSerialization());
        xmlWriter.end();
    }

    private static void addScanRangeIfNotNull(XmlWriter xmlWriter, ScanRange scanRange) {
        if (scanRange != null) {
            xmlWriter.start("ScanRange");
            RequestXmlFactory.addIfNotNull(xmlWriter, "Start", scanRange.getStart());
            RequestXmlFactory.addIfNotNull(xmlWriter, "End", scanRange.getEnd());
            xmlWriter.end();
        }
    }

    private static void addInputSerializationIfNotNull(XmlWriter xmlWriter, InputSerialization inputSerialization) {
        if (inputSerialization != null) {
            Serializable serializable;
            xmlWriter.start("InputSerialization");
            if (inputSerialization.getCsv() != null) {
                xmlWriter.start("CSV");
                serializable = inputSerialization.getCsv();
                RequestXmlFactory.addIfNotNull(xmlWriter, "FileHeaderInfo", ((CSVInput)serializable).getFileHeaderInfo());
                RequestXmlFactory.addIfNotNull(xmlWriter, "Comments", ((CSVInput)serializable).getCommentsAsString());
                RequestXmlFactory.addIfNotNull(xmlWriter, "QuoteEscapeCharacter", ((CSVInput)serializable).getQuoteEscapeCharacterAsString());
                RequestXmlFactory.addIfNotNull(xmlWriter, "RecordDelimiter", ((CSVInput)serializable).getRecordDelimiterAsString());
                RequestXmlFactory.addIfNotNull(xmlWriter, "FieldDelimiter", ((CSVInput)serializable).getFieldDelimiterAsString());
                RequestXmlFactory.addIfNotNull(xmlWriter, "QuoteCharacter", ((CSVInput)serializable).getQuoteCharacterAsString());
                RequestXmlFactory.addIfNotNull(xmlWriter, "AllowQuotedRecordDelimiter", ((CSVInput)serializable).getAllowQuotedRecordDelimiter());
                xmlWriter.end();
            }
            if (inputSerialization.getJson() != null) {
                xmlWriter.start("JSON");
                serializable = inputSerialization.getJson();
                RequestXmlFactory.addIfNotNull(xmlWriter, "Type", ((JSONInput)serializable).getType());
                xmlWriter.end();
            }
            if (inputSerialization.getParquet() != null) {
                xmlWriter.start("Parquet");
                xmlWriter.end();
            }
            RequestXmlFactory.addIfNotNull(xmlWriter, "CompressionType", inputSerialization.getCompressionType());
            xmlWriter.end();
        }
    }

    private static void addOutputSerializationIfNotNull(XmlWriter xmlWriter, OutputSerialization outputSerialization) {
        if (outputSerialization != null) {
            Serializable serializable;
            xmlWriter.start("OutputSerialization");
            if (outputSerialization.getCsv() != null) {
                xmlWriter.start("CSV");
                serializable = outputSerialization.getCsv();
                RequestXmlFactory.addIfNotNull(xmlWriter, "QuoteFields", ((CSVOutput)serializable).getQuoteFields());
                RequestXmlFactory.addIfNotNull(xmlWriter, "QuoteEscapeCharacter", ((CSVOutput)serializable).getQuoteEscapeCharacterAsString());
                RequestXmlFactory.addIfNotNull(xmlWriter, "RecordDelimiter", ((CSVOutput)serializable).getRecordDelimiterAsString());
                RequestXmlFactory.addIfNotNull(xmlWriter, "FieldDelimiter", ((CSVOutput)serializable).getFieldDelimiterAsString());
                RequestXmlFactory.addIfNotNull(xmlWriter, "QuoteCharacter", ((CSVOutput)serializable).getQuoteCharacterAsString());
                xmlWriter.end();
            }
            if (outputSerialization.getJson() != null) {
                xmlWriter.start("JSON");
                serializable = outputSerialization.getJson();
                RequestXmlFactory.addIfNotNull(xmlWriter, "RecordDelimiter", ((JSONOutput)serializable).getRecordDelimiterAsString());
                xmlWriter.end();
            }
            xmlWriter.end();
        }
    }

    private static void addTaggingIfNotNull(XmlWriter xmlWriter, ObjectTagging objectTagging) {
        if (objectTagging == null) {
            return;
        }
        xmlWriter.start("Tagging");
        xmlWriter.start("TagSet");
        for (Tag tag : objectTagging.getTagSet()) {
            xmlWriter.start("Tag");
            xmlWriter.start("Key").value(tag.getKey()).end();
            xmlWriter.start("Value").value(tag.getValue()).end();
            xmlWriter.end();
        }
        xmlWriter.end();
        xmlWriter.end();
    }

    private static void addOutputLocationIfNotNull(XmlWriter xmlWriter, OutputLocation outputLocation) {
        if (outputLocation == null) {
            return;
        }
        xmlWriter.start("OutputLocation");
        if (outputLocation.getS3() != null) {
            S3Location s3Location = outputLocation.getS3();
            xmlWriter.start("S3");
            RequestXmlFactory.addIfNotNull(xmlWriter, "BucketName", s3Location.getBucketName());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Prefix", s3Location.getPrefix());
            if (s3Location.getEncryption() != null) {
                Encryption encryption = s3Location.getEncryption();
                xmlWriter.start("Encryption");
                RequestXmlFactory.addIfNotNull(xmlWriter, "EncryptionType", encryption.getEncryptionType());
                RequestXmlFactory.addIfNotNull(xmlWriter, "KMSKeyId", encryption.getKmsKeyId());
                RequestXmlFactory.addIfNotNull(xmlWriter, "KMSContext", encryption.getKmsContext());
                xmlWriter.end();
            }
            RequestXmlFactory.addIfNotNull(xmlWriter, "CannedACL", s3Location.getCannedACL());
            RequestXmlFactory.addGrantsIfNotNull(xmlWriter, s3Location.getAccessControlList());
            RequestXmlFactory.addTaggingIfNotNull(xmlWriter, s3Location.getTagging());
            RequestXmlFactory.addIfNotNull(xmlWriter, "StorageClass", s3Location.getStorageClass());
            RequestXmlFactory.addUserMetaDataIfNotNull(xmlWriter, s3Location.getUserMetadata());
            xmlWriter.end();
        }
        xmlWriter.end();
    }

    private static void addGrantsIfNotNull(XmlWriter xmlWriter, AccessControlList accessControlList) {
        if (accessControlList == null) {
            return;
        }
        AclXmlFactory aclXmlFactory = new AclXmlFactory();
        xmlWriter.start("AccessControlList");
        for (Grant grant : accessControlList.getGrantsAsList()) {
            xmlWriter.start("Grant");
            if (grant.getGrantee() != null) {
                aclXmlFactory.convertToXml(grant.getGrantee(), xmlWriter);
            }
            RequestXmlFactory.addIfNotNull(xmlWriter, "Permission", (Object)grant.getPermission());
            xmlWriter.end();
        }
        xmlWriter.end();
    }

    private static void addUserMetaDataIfNotNull(XmlWriter xmlWriter, List<MetadataEntry> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        xmlWriter.start("UserMetadata");
        for (MetadataEntry metadataEntry : list) {
            xmlWriter.start("MetadataEntry");
            RequestXmlFactory.addIfNotNull(xmlWriter, "Name", metadataEntry.getName());
            RequestXmlFactory.addIfNotNull(xmlWriter, "Value", metadataEntry.getValue());
            xmlWriter.end();
        }
        xmlWriter.end();
    }

    private static void addIfNotNull(XmlWriter xmlWriter, String string, String string2) {
        if (string2 != null) {
            xmlWriter.start(string).value(string2).end();
        }
    }

    private static void addIfNotNull(XmlWriter xmlWriter, String string, Object object) {
        if (object != null && object.toString() != null) {
            xmlWriter.start(string).value(object.toString()).end();
        }
    }
}

