/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.services.s3.model.CloudFunctionConfiguration;
import com.amazonaws.services.s3.model.Filter;
import com.amazonaws.services.s3.model.LambdaConfiguration;
import com.amazonaws.services.s3.model.NotificationConfiguration;
import com.amazonaws.services.s3.model.transform.FilterStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;

class LambdaConfigurationStaxUnmarshaller
implements Unmarshaller<Map.Entry<String, NotificationConfiguration>, StaxUnmarshallerContext> {
    private static final LambdaConfigurationStaxUnmarshaller instance = new LambdaConfigurationStaxUnmarshaller();

    public static LambdaConfigurationStaxUnmarshaller getInstance() {
        return instance;
    }

    private LambdaConfigurationStaxUnmarshaller() {
    }

    @Override
    public Map.Entry<String, NotificationConfiguration> unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
        int n = staxUnmarshallerContext.getCurrentDepth();
        int n2 = n + 1;
        if (staxUnmarshallerContext.isStartOfDocument()) {
            ++n2;
        }
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        Filter filter = null;
        String string2 = null;
        String string3 = null;
        while (true) {
            XMLEvent xMLEvent;
            if ((xMLEvent = staxUnmarshallerContext.nextEvent()).isEndDocument()) {
                return this.createLambdaConfig(string, arrayList, string2, string3, filter);
            }
            if (xMLEvent.isAttribute() || xMLEvent.isStartElement()) {
                if (staxUnmarshallerContext.testExpression("Id", n2)) {
                    string = SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext);
                    continue;
                }
                if (staxUnmarshallerContext.testExpression("Event", n2)) {
                    arrayList.add(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                    continue;
                }
                if (staxUnmarshallerContext.testExpression("Filter", n2)) {
                    filter = FilterStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext);
                    continue;
                }
                if (staxUnmarshallerContext.testExpression("CloudFunction", n2)) {
                    string2 = SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext);
                    continue;
                }
                if (!staxUnmarshallerContext.testExpression("InvocationRole", n2)) continue;
                string3 = SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext);
                continue;
            }
            if (xMLEvent.isEndElement() && staxUnmarshallerContext.getCurrentDepth() < n) break;
        }
        return this.createLambdaConfig(string, arrayList, string2, string3, filter);
    }

    private Map.Entry<String, NotificationConfiguration> createLambdaConfig(String string, List<String> list, String string2, String string3, Filter filter) {
        NotificationConfiguration notificationConfiguration = string3 == null ? new LambdaConfiguration(string2, list.toArray(new String[0])) : new CloudFunctionConfiguration(string3, string2, list.toArray(new String[0]));
        return new AbstractMap.SimpleEntry<String, NotificationConfiguration>(string, notificationConfiguration.withFilter(filter));
    }
}

