/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.services.s3.model.GetBucketPolicyStatusResult;
import com.amazonaws.services.s3.model.PolicyStatus;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XmlUtils;
import java.io.InputStream;
import javax.xml.stream.events.XMLEvent;

public class GetBucketPolicyStatusStaxUnmarshaller
implements Unmarshaller<GetBucketPolicyStatusResult, InputStream> {
    private static final GetBucketPolicyStatusStaxUnmarshaller instance = new GetBucketPolicyStatusStaxUnmarshaller();

    public static GetBucketPolicyStatusStaxUnmarshaller getInstance() {
        return instance;
    }

    private GetBucketPolicyStatusStaxUnmarshaller() {
    }

    @Override
    public GetBucketPolicyStatusResult unmarshall(InputStream inputStream2) throws Exception {
        StaxUnmarshallerContext staxUnmarshallerContext = new StaxUnmarshallerContext(XmlUtils.getXmlInputFactory().createXMLEventReader(inputStream2));
        int n = staxUnmarshallerContext.getCurrentDepth();
        int n2 = n + 1;
        if (staxUnmarshallerContext.isStartOfDocument()) {
            ++n2;
        }
        GetBucketPolicyStatusResult getBucketPolicyStatusResult = new GetBucketPolicyStatusResult();
        PolicyStatus policyStatus = new PolicyStatus();
        getBucketPolicyStatusResult.setPolicyStatus(policyStatus);
        while (true) {
            XMLEvent xMLEvent;
            if ((xMLEvent = staxUnmarshallerContext.nextEvent()).isEndDocument()) {
                return getBucketPolicyStatusResult;
            }
            if (xMLEvent.isAttribute() || xMLEvent.isStartElement()) {
                if (!staxUnmarshallerContext.testExpression("IsPublic", n2)) continue;
                policyStatus.setIsPublic(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                continue;
            }
            if (xMLEvent.isEndElement() && staxUnmarshallerContext.getCurrentDepth() < n) break;
        }
        return getBucketPolicyStatusResult;
    }
}

