/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.services.s3.model.GetBucketEncryptionResult;
import com.amazonaws.services.s3.model.ServerSideEncryptionConfiguration;
import com.amazonaws.services.s3.model.ServerSideEncryptionRule;
import com.amazonaws.services.s3.model.transform.ServerSideEncryptionRuleStaxUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XmlUtils;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class GetBucketEncryptionStaxUnmarshaller
implements Unmarshaller<GetBucketEncryptionResult, InputStream> {
    private static final GetBucketEncryptionStaxUnmarshaller instance = new GetBucketEncryptionStaxUnmarshaller();

    public static GetBucketEncryptionStaxUnmarshaller getInstance() {
        return instance;
    }

    private GetBucketEncryptionStaxUnmarshaller() {
    }

    @Override
    public GetBucketEncryptionResult unmarshall(InputStream inputStream2) throws Exception {
        StaxUnmarshallerContext staxUnmarshallerContext = new StaxUnmarshallerContext(XmlUtils.getXmlInputFactory().createXMLEventReader(inputStream2));
        int n = staxUnmarshallerContext.getCurrentDepth();
        int n2 = n + 1;
        if (staxUnmarshallerContext.isStartOfDocument()) {
            ++n2;
        }
        GetBucketEncryptionResult getBucketEncryptionResult = new GetBucketEncryptionResult();
        ServerSideEncryptionConfiguration serverSideEncryptionConfiguration = new ServerSideEncryptionConfiguration();
        getBucketEncryptionResult.setServerSideEncryptionConfiguration(serverSideEncryptionConfiguration);
        while (true) {
            XMLEvent xMLEvent;
            if ((xMLEvent = staxUnmarshallerContext.nextEvent()).isEndDocument()) {
                return getBucketEncryptionResult;
            }
            if (xMLEvent.isAttribute() || xMLEvent.isStartElement()) {
                if (!staxUnmarshallerContext.testExpression("Rule", n2)) continue;
                if (serverSideEncryptionConfiguration.getRules() == null) {
                    serverSideEncryptionConfiguration.setRules(new ArrayList<ServerSideEncryptionRule>());
                }
                serverSideEncryptionConfiguration.getRules().add(ServerSideEncryptionRuleStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                continue;
            }
            if (xMLEvent.isEndElement() && staxUnmarshallerContext.getCurrentDepth() < n) break;
        }
        return getBucketEncryptionResult;
    }
}

