/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.services.s3.UploadObjectObserver;
import com.amazonaws.services.s3.internal.MultiFileOutputStream;
import com.amazonaws.services.s3.model.AbstractPutObjectRequest;
import com.amazonaws.services.s3.model.MaterialsDescriptionProvider;
import com.amazonaws.services.s3.model.ObjectMetadata;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class UploadObjectRequest
extends AbstractPutObjectRequest
implements MaterialsDescriptionProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    static final int MIN_PART_SIZE = 0x500000;
    private ObjectMetadata uploadPartMetadata;
    private Map<String, String> materialsDescription;
    private long partSize = 0x500000L;
    private transient ExecutorService executorService;
    private transient MultiFileOutputStream multiFileOutputStream;
    private transient UploadObjectObserver uploadObjectObserver;
    private long diskLimit = Long.MAX_VALUE;

    public UploadObjectRequest(String string, String string2, File file) {
        super(string, string2, file);
    }

    public UploadObjectRequest(String string, String string2, InputStream inputStream2, ObjectMetadata objectMetadata) {
        super(string, string2, inputStream2, objectMetadata);
    }

    public long getPartSize() {
        return this.partSize;
    }

    public UploadObjectRequest withPartSize(long l) {
        if (l < 0x500000L) {
            throw new IllegalArgumentException("partSize must be at least 5242880");
        }
        this.partSize = l;
        return this;
    }

    public long getDiskLimit() {
        return this.diskLimit;
    }

    public UploadObjectRequest withDiskLimit(long l) {
        this.diskLimit = l;
        return this;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public UploadObjectRequest withExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public MultiFileOutputStream getMultiFileOutputStream() {
        return this.multiFileOutputStream;
    }

    public UploadObjectRequest withMultiFileOutputStream(MultiFileOutputStream multiFileOutputStream) {
        this.multiFileOutputStream = multiFileOutputStream;
        return this;
    }

    public UploadObjectObserver getUploadObjectObserver() {
        return this.uploadObjectObserver;
    }

    public UploadObjectRequest withUploadObjectObserver(UploadObjectObserver uploadObjectObserver) {
        this.uploadObjectObserver = uploadObjectObserver;
        return this;
    }

    @Override
    public Map<String, String> getMaterialsDescription() {
        return this.materialsDescription;
    }

    public void setMaterialsDescription(Map<String, String> map) {
        this.materialsDescription = map == null ? null : Collections.unmodifiableMap(new HashMap<String, String>(map));
    }

    public UploadObjectRequest withMaterialsDescription(Map<String, String> map) {
        this.setMaterialsDescription(map);
        return this;
    }

    public ObjectMetadata getUploadPartMetadata() {
        return this.uploadPartMetadata;
    }

    public void setUploadPartMetadata(ObjectMetadata objectMetadata) {
        this.uploadPartMetadata = objectMetadata;
    }

    public <T extends UploadObjectRequest> T withUploadPartMetadata(ObjectMetadata objectMetadata) {
        this.setUploadPartMetadata(objectMetadata);
        UploadObjectRequest uploadObjectRequest = this;
        return (T)uploadObjectRequest;
    }

    @Override
    public UploadObjectRequest clone() {
        UploadObjectRequest uploadObjectRequest = (UploadObjectRequest)super.clone();
        super.copyPutObjectBaseTo(uploadObjectRequest);
        Map<String, String> map = this.getMaterialsDescription();
        ObjectMetadata objectMetadata = this.getUploadPartMetadata();
        return uploadObjectRequest.withMaterialsDescription((Map<String, String>)(map == null ? null : new HashMap<String, String>(map))).withDiskLimit(this.getDiskLimit()).withExecutorService(this.getExecutorService()).withMultiFileOutputStream(this.getMultiFileOutputStream()).withPartSize(this.getPartSize()).withUploadObjectObserver(this.getUploadObjectObserver()).withUploadPartMetadata(objectMetadata == null ? null : objectMetadata.clone());
    }
}

