/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsAccessor;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import java.io.Serializable;
import java.util.Map;

public class StaticEncryptionMaterialsProvider
implements EncryptionMaterialsProvider,
Serializable {
    private final EncryptionMaterials materials;

    public StaticEncryptionMaterialsProvider(EncryptionMaterials encryptionMaterials) {
        this.materials = encryptionMaterials;
    }

    @Override
    public EncryptionMaterials getEncryptionMaterials() {
        return this.materials;
    }

    @Override
    public void refresh() {
    }

    @Override
    public EncryptionMaterials getEncryptionMaterials(Map<String, String> map) {
        EncryptionMaterials encryptionMaterials;
        if (this.materials == null) {
            return null;
        }
        Map<String, String> map2 = this.materials.getMaterialsDescription();
        if (map != null && map.equals(map2)) {
            return this.materials;
        }
        EncryptionMaterialsAccessor encryptionMaterialsAccessor = this.materials.getAccessor();
        if (encryptionMaterialsAccessor != null && (encryptionMaterials = encryptionMaterialsAccessor.getEncryptionMaterials(map)) != null) {
            return encryptionMaterials;
        }
        boolean bl = map == null || map.size() == 0;
        boolean bl2 = map2 == null || map2.size() == 0;
        return bl && bl2 ? this.materials : null;
    }
}

