/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.services.s3.model.ExpressionType;
import com.amazonaws.services.s3.model.InputSerialization;
import com.amazonaws.services.s3.model.OutputSerialization;
import com.amazonaws.services.s3.model.ScanRange;
import java.io.Serializable;

public class SelectParameters
implements Serializable,
Cloneable {
    private InputSerialization inputSerialization;
    private String expressionType;
    private String expression;
    private ScanRange scanRange;
    private OutputSerialization outputSerialization;

    public InputSerialization getInputSerialization() {
        return this.inputSerialization;
    }

    public void setInputSerialization(InputSerialization inputSerialization) {
        this.inputSerialization = inputSerialization;
    }

    public SelectParameters withInputSerialization(InputSerialization inputSerialization) {
        this.setInputSerialization(inputSerialization);
        return this;
    }

    public String getExpressionType() {
        return this.expressionType;
    }

    public void setExpressionType(String string) {
        this.expressionType = string;
    }

    public SelectParameters withExpressionType(String string) {
        this.setExpressionType(string);
        return this;
    }

    public SelectParameters withExpressionType(ExpressionType expressionType) {
        this.setExpressionType(expressionType == null ? null : expressionType.toString());
        return this;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String string) {
        this.expression = string;
    }

    public SelectParameters withExpression(String string) {
        this.setExpression(string);
        return this;
    }

    public ScanRange getScanRange() {
        return this.scanRange;
    }

    public void setScanRange(ScanRange scanRange) {
        this.scanRange = scanRange;
    }

    public SelectParameters withRange(ScanRange scanRange) {
        this.setScanRange(scanRange);
        return this;
    }

    public OutputSerialization getOutputSerialization() {
        return this.outputSerialization;
    }

    public void setOutputSerialization(OutputSerialization outputSerialization) {
        this.outputSerialization = outputSerialization;
    }

    public SelectParameters withOutputSerialization(OutputSerialization outputSerialization) {
        this.setOutputSerialization(outputSerialization);
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof SelectParameters)) {
            return false;
        }
        SelectParameters selectParameters = (SelectParameters)object;
        if (selectParameters.getInputSerialization() == null ^ this.getInputSerialization() == null) {
            return false;
        }
        if (selectParameters.getInputSerialization() != null && !selectParameters.getInputSerialization().equals(this.getInputSerialization())) {
            return false;
        }
        if (selectParameters.getExpressionType() == null ^ this.getExpressionType() == null) {
            return false;
        }
        if (selectParameters.getExpressionType() != null && !selectParameters.getExpressionType().equals(this.getExpressionType())) {
            return false;
        }
        if (selectParameters.getExpression() == null ^ this.getExpression() == null) {
            return false;
        }
        if (selectParameters.getExpression() != null && !selectParameters.getExpression().equals(this.getExpression())) {
            return false;
        }
        if (selectParameters.getOutputSerialization() == null ^ this.getOutputSerialization() == null) {
            return false;
        }
        return selectParameters.getOutputSerialization() == null || selectParameters.getOutputSerialization().equals(this.getOutputSerialization());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getInputSerialization() == null ? 0 : this.getInputSerialization().hashCode());
        n2 = 31 * n2 + (this.getExpressionType() == null ? 0 : this.getExpressionType().hashCode());
        n2 = 31 * n2 + (this.getExpression() == null ? 0 : this.getExpression().hashCode());
        n2 = 31 * n2 + (this.getOutputSerialization() == null ? 0 : this.getOutputSerialization().hashCode());
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getInputSerialization() != null) {
            stringBuilder.append("InputSerialization: ").append(this.getInputSerialization()).append(",");
        }
        if (this.getExpressionType() != null) {
            stringBuilder.append("ExpressionType: ").append(this.getExpressionType()).append(",");
        }
        if (this.getExpression() != null) {
            stringBuilder.append("Expression: ").append(this.getExpression()).append(",");
        }
        if (this.getOutputSerialization() != null) {
            stringBuilder.append("OutputSerialization: ").append(this.getOutputSerialization());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public SelectParameters clone() {
        try {
            return (SelectParameters)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", cloneNotSupportedException);
        }
    }
}

