/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

public enum SSEAlgorithm {
    AES256("AES256"),
    KMS("aws:kms");

    private final String algorithm;

    public String getAlgorithm() {
        return this.algorithm;
    }

    private SSEAlgorithm(String string2) {
        this.algorithm = string2;
    }

    public String toString() {
        return this.algorithm;
    }

    public static SSEAlgorithm fromString(String string) {
        if (string == null) {
            return null;
        }
        for (SSEAlgorithm sSEAlgorithm : SSEAlgorithm.values()) {
            if (!sSEAlgorithm.getAlgorithm().equals(string)) continue;
            return sSEAlgorithm;
        }
        throw new IllegalArgumentException("Unsupported algorithm " + string);
    }

    public static SSEAlgorithm getDefault() {
        return AES256;
    }
}

