/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.services.s3.model.S3ObjectId;
import java.io.Serializable;

public final class S3ObjectIdBuilder
implements Serializable {
    private String bucket;
    private String key;
    private String versionId;

    public S3ObjectIdBuilder() {
    }

    public S3ObjectIdBuilder(S3ObjectId s3ObjectId) {
        this.bucket = s3ObjectId.getBucket();
        this.key = s3ObjectId.getKey();
        this.versionId = s3ObjectId.getVersionId();
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setBucket(String string) {
        this.bucket = string;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public void setVersionId(String string) {
        this.versionId = string;
    }

    public S3ObjectIdBuilder withBucket(String string) {
        this.bucket = string;
        return this;
    }

    public S3ObjectIdBuilder withKey(String string) {
        this.key = string;
        return this;
    }

    public S3ObjectIdBuilder withVersionId(String string) {
        this.versionId = string;
        return this;
    }

    public S3ObjectId build() {
        return new S3ObjectId(this.bucket, this.key, this.versionId);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        S3ObjectIdBuilder s3ObjectIdBuilder = (S3ObjectIdBuilder)object;
        if (this.bucket != null ? !this.bucket.equals(s3ObjectIdBuilder.bucket) : s3ObjectIdBuilder.bucket != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(s3ObjectIdBuilder.key) : s3ObjectIdBuilder.key != null) {
            return false;
        }
        return this.versionId != null ? this.versionId.equals(s3ObjectIdBuilder.versionId) : s3ObjectIdBuilder.versionId == null;
    }

    public int hashCode() {
        int n = this.bucket != null ? this.bucket.hashCode() : 0;
        n = 31 * n + (this.key != null ? this.key.hashCode() : 0);
        n = 31 * n + (this.versionId != null ? this.versionId.hashCode() : 0);
        return n;
    }
}

