/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.services.s3.model.DeleteMarkerReplication;
import com.amazonaws.services.s3.model.ExistingObjectReplication;
import com.amazonaws.services.s3.model.ReplicationDestinationConfig;
import com.amazonaws.services.s3.model.ReplicationRuleStatus;
import com.amazonaws.services.s3.model.SourceSelectionCriteria;
import com.amazonaws.services.s3.model.replication.ReplicationFilter;
import com.amazonaws.util.json.Jackson;
import java.io.Serializable;

public class ReplicationRule
implements Serializable {
    private String prefix;
    private String status;
    private ReplicationDestinationConfig destinationConfig;
    private SourceSelectionCriteria sourceSelectionCriteria;
    private ReplicationFilter filter;
    private Integer priority;
    private ExistingObjectReplication existingObjectReplication;
    private DeleteMarkerReplication deleteMarkerReplication;

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer n) {
        if (n < 0) {
            throw new IllegalArgumentException("Priority has to be a positive number");
        }
        this.priority = n;
    }

    public ReplicationRule withPriority(Integer n) {
        this.setPriority(n);
        return this;
    }

    public ExistingObjectReplication getExistingObjectReplication() {
        return this.existingObjectReplication;
    }

    public void setExistingObjectReplication(ExistingObjectReplication existingObjectReplication) {
        this.existingObjectReplication = existingObjectReplication;
    }

    public ReplicationRule withExistingObjectReplication(ExistingObjectReplication existingObjectReplication) {
        this.setExistingObjectReplication(existingObjectReplication);
        return this;
    }

    public DeleteMarkerReplication getDeleteMarkerReplication() {
        return this.deleteMarkerReplication;
    }

    public void setDeleteMarkerReplication(DeleteMarkerReplication deleteMarkerReplication) {
        this.deleteMarkerReplication = deleteMarkerReplication;
    }

    public ReplicationRule withDeleteMarkerReplication(DeleteMarkerReplication deleteMarkerReplication) {
        this.setDeleteMarkerReplication(deleteMarkerReplication);
        return this;
    }

    @Deprecated
    public String getPrefix() {
        return this.prefix;
    }

    @Deprecated
    public void setPrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Prefix cannot be null for a replication rule");
        }
        if (this.filter != null) {
            throw new IllegalArgumentException("You cannot use both prefix and filter at the same time in a replication rule");
        }
        this.prefix = string;
    }

    @Deprecated
    public ReplicationRule withPrefix(String string) {
        this.setPrefix(string);
        return this;
    }

    public ReplicationFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ReplicationFilter replicationFilter) {
        if (replicationFilter == null) {
            throw new IllegalArgumentException("Filter cannot be null for a replication rule");
        }
        if (this.prefix != null) {
            throw new IllegalArgumentException("You cannot use both prefix and filter at the same time in a replication rule");
        }
        this.filter = replicationFilter;
    }

    public ReplicationRule withFilter(ReplicationFilter replicationFilter) {
        this.setFilter(replicationFilter);
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public ReplicationRule withStatus(String string) {
        this.setStatus(string);
        return this;
    }

    public void setStatus(ReplicationRuleStatus replicationRuleStatus) {
        this.setStatus(replicationRuleStatus.getStatus());
    }

    public ReplicationRule withStatus(ReplicationRuleStatus replicationRuleStatus) {
        this.setStatus(replicationRuleStatus.getStatus());
        return this;
    }

    public ReplicationDestinationConfig getDestinationConfig() {
        return this.destinationConfig;
    }

    public void setDestinationConfig(ReplicationDestinationConfig replicationDestinationConfig) {
        if (replicationDestinationConfig == null) {
            throw new IllegalArgumentException("Destination cannot be null in the replication rule");
        }
        this.destinationConfig = replicationDestinationConfig;
    }

    public ReplicationRule withDestinationConfig(ReplicationDestinationConfig replicationDestinationConfig) {
        this.setDestinationConfig(replicationDestinationConfig);
        return this;
    }

    public SourceSelectionCriteria getSourceSelectionCriteria() {
        return this.sourceSelectionCriteria;
    }

    public void setSourceSelectionCriteria(SourceSelectionCriteria sourceSelectionCriteria) {
        this.sourceSelectionCriteria = sourceSelectionCriteria;
    }

    public ReplicationRule withSourceSelectionCriteria(SourceSelectionCriteria sourceSelectionCriteria) {
        this.setSourceSelectionCriteria(sourceSelectionCriteria);
        return this;
    }

    public String toString() {
        return Jackson.toJsonString(this);
    }
}

